/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BloomFilterBase;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashMap;
import com.intellij.util.lang.Loader;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

public class ClasspathCache {
    static final Logger LOG = Logger.getInstance(ClasspathCache.class);
    static final boolean doDebug = LOG.isDebugEnabled();
    private final DebugInfo myDebugInfo;
    private final TIntObjectHashMap<Object> myResourcePackagesCache = new TIntObjectHashMap();
    private final TIntObjectHashMap<Object> myClassPackagesCache = new TIntObjectHashMap();
    private Map<String, Set<Loader>> myResources2LoadersTempMap = new THashMap<String, Set<Loader>>();
    private Name2LoaderFilter myNameFilter;
    private boolean myTempMapMode = true;
    private int registeredBeforeClose;
    private int registeredAfterClose;
    private static int hits;
    private static int requests;
    private static int falseHits;
    private static int requests2;
    private static int hits2;
    private static int falseHits2;
    private static int diffs;
    private static int diffs2;
    private static int diffs3;

    public ClasspathCache() {
        this.myDebugInfo = doDebug ? new DebugInfo() : new NullDebugInfo();
    }

    public void addResourceEntry(String resourcePath, Loader loader) {
        this.myDebugInfo.addResourceEntry(resourcePath, loader);
        String packageName = ClasspathCache.getPackageName(resourcePath);
        TIntObjectHashMap<Object> map = resourcePath.endsWith(".class") ? this.myClassPackagesCache : this.myResourcePackagesCache;
        int hash = packageName.hashCode();
        Object o = map.get(hash);
        if (o == null) {
            map.put(hash, loader);
        } else if (o instanceof Loader) {
            if (o != loader) {
                map.put(hash, new Loader[]{(Loader)o, loader});
            }
        } else {
            Loader[] loadersArray;
            for (Loader l : loadersArray = (Loader[])o) {
                if (l != loader) continue;
                return;
            }
            map.put(hash, ArrayUtil.append(loadersArray, loader));
        }
    }

    @Nullable
    <ResultType, ParameterType, ParameterType2> ResultType iterateLoaders(String resourcePath, LoaderIterator<ResultType, ParameterType, ParameterType2> iterator2, ParameterType parameter, ParameterType2 parameter2) {
        Loader[] loaders;
        TIntObjectHashMap<Object> map = resourcePath.endsWith(".class") ? this.myClassPackagesCache : this.myResourcePackagesCache;
        String packageName = ClasspathCache.getPackageName(resourcePath);
        int hash = packageName.hashCode();
        Object o = map.get(hash);
        this.myDebugInfo.checkLoadersCount(resourcePath, o);
        if (o == null) {
            return null;
        }
        if (o instanceof Loader) {
            return iterator2.process((Loader)o, parameter, parameter2);
        }
        for (Loader l : loaders = (Loader[])o) {
            ResultType result2 = iterator2.process(l, parameter, parameter2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    private static String getPackageName(String resourcePath) {
        int idx = resourcePath.lastIndexOf(47);
        return idx > 0 ? resourcePath.substring(0, idx) : "";
    }

    public void addNameEntry(String name, Loader loader) {
        name = ClasspathCache.transformName(name);
        this.myDebugInfo.addNameEntry(name, loader);
        if (this.myTempMapMode) {
            Set<Loader> loaders = this.myResources2LoadersTempMap.get(name);
            if (loaders == null) {
                loaders = new THashSet<Loader>();
                this.myResources2LoadersTempMap.put(name, loaders);
            }
            boolean added = loaders.add(loader);
            if (doDebug && added) {
                ++this.registeredBeforeClose;
            }
        } else {
            if (doDebug && !this.myNameFilter.maybeContains(name, loader)) {
                ++this.registeredAfterClose;
            }
            this.myNameFilter.add(name, loader);
        }
    }

    public boolean loaderHasName(String name, Loader loader) {
        boolean result2;
        String origName = name;
        name = ClasspathCache.transformName(name);
        if (this.myTempMapMode) {
            ++requests;
            Set<Loader> loaders = this.myResources2LoadersTempMap.get(name);
            boolean bl = result2 = loaders != null && loaders.contains(loader);
            if (!result2) {
                ++hits;
            }
            if (doDebug) {
                Resource resource;
                boolean result22 = this.myDebugInfo.loaderHashName(name, loader);
                if (result22 != result2) {
                    ++diffs3;
                }
                if ((resource = loader.getResource(origName, true)) != null && !result2 || resource == null && result2) {
                    ++falseHits;
                }
            }
            if (requests % 1000 == 0 && doDebug) {
                LOG.debug("Avoided disk hits: " + hits + " from " + requests + ", false hits:" + falseHits + ", bitmap diffs:" + diffs3);
            }
        } else {
            ++requests2;
            result2 = this.myNameFilter.maybeContains(name, loader);
            if (!result2) {
                ++hits2;
            }
            if (doDebug) {
                Resource resource;
                Set<Loader> loaders;
                boolean result23 = this.myDebugInfo.loaderHashName(name, loader);
                if (result23 != result2) {
                    ++diffs2;
                }
                if (result2 != ((loaders = this.myResources2LoadersTempMap.get(name)) != null && loaders.contains(loader))) {
                    ++diffs;
                }
                if ((resource = loader.getResource(origName, true)) == null && result2) {
                    ++falseHits2;
                }
                if (resource != null && !result2) {
                    ++falseHits2;
                }
            }
            if (requests2 % 1000 == 0 && doDebug) {
                LOG.debug("Avoided disk hits2: " + hits2 + " from " + requests2 + "," + diffs + ", false hits:" + falseHits2 + ", bitmap diffs:" + diffs2);
            }
        }
        return result2;
    }

    private static String transformName(String name) {
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((name = name.substring(name.lastIndexOf(47) + 1)).endsWith(".class")) {
            String name1 = name;
            int $ = name1.indexOf(36);
            if ($ != -1) {
                name1 = name1.substring(0, $);
            } else {
                int index = name1.lastIndexOf(46);
                if (index >= 0) {
                    name1 = name1.substring(0, index);
                }
            }
            name = name1;
        }
        return name;
    }

    void nameSymbolsLoaded() {
        if (!this.myTempMapMode) {
            if (doDebug && this.registeredAfterClose > 0) {
                LOG.debug("Registered number of classes after close " + this.registeredAfterClose + " " + this.toString());
            }
            return;
        }
        if (doDebug) {
            LOG.debug("Registered number of classes before classes " + this.registeredBeforeClose + " " + this.toString());
        }
        this.myTempMapMode = false;
        int nBits = 0;
        int uniques = 0;
        for (Map.Entry<String, Set<Loader>> e : this.myResources2LoadersTempMap.entrySet()) {
            int size = e.getValue().size();
            if (size == 1) {
                ++uniques;
            }
            nBits += size;
        }
        if (nBits > 20000) {
            nBits += (int)((double)nBits * 0.03);
        }
        this.myNameFilter = new Name2LoaderFilter(nBits, 0.005);
        for (Map.Entry<String, Set<Loader>> e : this.myResources2LoadersTempMap.entrySet()) {
            String name = e.getKey();
            for (Loader loader : e.getValue()) {
                this.myNameFilter.add(name, loader);
            }
        }
        if (!doDebug) {
            this.myResources2LoadersTempMap = null;
        }
    }

    private static class NullDebugInfo
    extends DebugInfo {
        private NullDebugInfo() {
        }

        @Override
        public void checkLoadersCount(String resourcePath, Object o) {
        }

        @Override
        protected void addResourceEntry(String resourcePath, Loader loader) {
        }

        @Override
        protected void addNameEntry(String name, Loader loader) {
        }

        @Override
        protected boolean loaderHashName(String name, Loader loader) {
            return false;
        }
    }

    private static class DebugInfo {
        private final HashMap<String, List<Loader>> myClassPackagesCache = new HashMap();
        private final HashMap<String, List<Loader>> myResourcePackagesCache = new HashMap();
        private final TIntHashSet myResourceIndex = new TIntHashSet();

        private DebugInfo() {
        }

        private List<Loader> getLoaders(String resourcePath) {
            int idx;
            String packageName;
            boolean isClassFile = resourcePath.endsWith(".class");
            HashMap<String, List<Loader>> map = isClassFile ? this.myClassPackagesCache : this.myResourcePackagesCache;
            SmartList list = (SmartList)map.get(packageName = (idx = resourcePath.lastIndexOf(47)) > 0 ? resourcePath.substring(0, idx) : "");
            if (list == null) {
                list = new SmartList();
                map.put(packageName, list);
            }
            return list;
        }

        protected void addResourceEntry(String resourcePath, Loader loader) {
            List<Loader> loaders = this.getLoaders(resourcePath);
            if (!loaders.contains(loader)) {
                loaders.add(loader);
            }
        }

        protected void addNameEntry(String name, Loader loader) {
            int hash = DebugInfo.hashFromNameAndLoader(name, loader);
            this.myResourceIndex.add(hash);
        }

        protected static int hashFromNameAndLoader(String name, Loader loader) {
            int hash = name.hashCode();
            for (int i = loader.getIndex(); i > 0; i /= 10) {
                hash = hash * 31 + (i % 10 + 48);
            }
            return hash;
        }

        public void checkLoadersCount(String resourcePath, Object o) {
            List<Loader> loaders1 = this.getLoaders(resourcePath);
            if (o == null && !loaders1.isEmpty() || o instanceof Loader && loaders1.size() != 1 || o instanceof Loader[] && loaders1.size() != ((Loader[])o).length) assert (false);
        }

        protected boolean loaderHashName(String name, Loader loader) {
            return this.myResourceIndex.contains(DebugInfo.hashFromNameAndLoader(name, loader));
        }
    }

    private static class Name2LoaderFilter
    extends BloomFilterBase {
        Name2LoaderFilter(int nBits, double probability) {
            super(nBits, probability);
        }

        private boolean maybeContains(String name, Loader loader) {
            int hash = Name2LoaderFilter.hashFromNameAndLoader(name, loader, StringHash.murmur(name, 31));
            int hash2 = Name2LoaderFilter.hashFromNameAndLoader(name, loader, hash);
            return this.maybeContains(hash, hash2);
        }

        private void add(String name, Loader loader) {
            int hash = Name2LoaderFilter.hashFromNameAndLoader(name, loader, StringHash.murmur(name, 31));
            int hash2 = Name2LoaderFilter.hashFromNameAndLoader(name, loader, hash);
            this.addIt(hash, hash2);
        }

        private static int hashFromNameAndLoader(String name, Loader loader, int n) {
            int hash = StringHash.murmur(name, n);
            for (int i = loader.getIndex(); i > 0; i /= 10) {
                hash = hash * n + (i % 10 + 48);
            }
            return hash;
        }
    }

    static abstract class LoaderIterator<ResultType, ParameterType, ParameterType2> {
        LoaderIterator() {
        }

        @Nullable
        abstract ResultType process(Loader var1, ParameterType var2, ParameterType2 var3);
    }
}

