/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.collect.Sets;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.BoundsOwner;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.Variance;

public class TypeValue
implements BoundsOwner {
    private final Set<TypeValue> upperBounds;
    private final Set<TypeValue> lowerBounds;
    private final Variance positionVariance;
    private final TypeParameterDescriptor typeParameterDescriptor;
    private final JetType originalType;
    private JetType value;

    public TypeValue(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull Variance positionVariance) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/jet/lang/resolve/calls/inference/TypeValue", "<init>"));
        }
        if (positionVariance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "positionVariance", "org/jetbrains/jet/lang/resolve/calls/inference/TypeValue", "<init>"));
        }
        this.upperBounds = Sets.newLinkedHashSet();
        this.lowerBounds = Sets.newLinkedHashSet();
        this.positionVariance = positionVariance;
        this.typeParameterDescriptor = typeParameterDescriptor;
        this.originalType = typeParameterDescriptor.getDefaultType();
    }

    public TypeValue(@NotNull JetType knownType) {
        if (knownType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "knownType", "org/jetbrains/jet/lang/resolve/calls/inference/TypeValue", "<init>"));
        }
        this.upperBounds = Sets.newLinkedHashSet();
        this.lowerBounds = Sets.newLinkedHashSet();
        this.positionVariance = null;
        this.typeParameterDescriptor = null;
        this.originalType = knownType;
        this.value = knownType;
    }

    public boolean isKnown() {
        return this.typeParameterDescriptor == null;
    }

    public TypeParameterDescriptor getTypeParameterDescriptor() {
        return this.typeParameterDescriptor;
    }

    @NotNull
    public Variance getPositionVariance() {
        Variance variance = this.positionVariance;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeValue", "getPositionVariance"));
        }
        return variance;
    }

    @Override
    @NotNull
    public Set<TypeValue> getUpperBounds() {
        Set<TypeValue> set = this.upperBounds;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeValue", "getUpperBounds"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<TypeValue> getLowerBounds() {
        Set<TypeValue> set = this.lowerBounds;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeValue", "getLowerBounds"));
        }
        return set;
    }

    @NotNull
    public JetType getType() {
        JetType jetType = this.value;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeValue", "getType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getOriginalType() {
        JetType jetType = this.originalType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/TypeValue", "getOriginalType"));
        }
        return jetType;
    }

    public void addUpperBound(@NotNull TypeValue bound) {
        if (bound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bound", "org/jetbrains/jet/lang/resolve/calls/inference/TypeValue", "addUpperBound"));
        }
        this.upperBounds.add(bound);
    }

    public void addLowerBound(@NotNull TypeValue bound) {
        if (bound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bound", "org/jetbrains/jet/lang/resolve/calls/inference/TypeValue", "addLowerBound"));
        }
        this.lowerBounds.add(bound);
    }

    public void setValue(@NotNull JetType value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/resolve/calls/inference/TypeValue", "setValue"));
        }
        this.value = value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String toString() {
        return this.isKnown() ? this.getType().toString() : this.getTypeParameterDescriptor() + (this.hasValue() ? " |-> " + this.getType() : "");
    }
}

