/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.CallKey;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetConstructorCalleeExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThisReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.CallTransformer;
import org.jetbrains.jet.lang.resolve.calls.CandidateResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCacheImpl;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionDebugInfo;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionResultsHandler;
import org.jetbrains.jet.lang.resolve.calls.tasks.CallableDescriptorCollectors;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.tasks.TaskPrioritizer;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.util.DelegatingCall;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.calls.util.JetFakeReference;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.LabelResolver;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class CallResolver {
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private CandidateResolver candidateResolver;
    @NotNull
    private ArgumentTypeResolver argumentTypeResolver;

    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "setTypeResolver"));
        }
        this.typeResolver = typeResolver;
    }

    public void setCandidateResolver(@NotNull CandidateResolver candidateResolver) {
        if (candidateResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateResolver", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "setCandidateResolver"));
        }
        this.candidateResolver = candidateResolver;
    }

    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        if (argumentTypeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypeResolver", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "setArgumentTypeResolver"));
        }
        this.argumentTypeResolver = argumentTypeResolver;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull BasicCallResolutionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveSimpleProperty"));
        }
        JetExpression calleeExpression = context.call.getCalleeExpression();
        assert (calleeExpression instanceof JetSimpleNameExpression);
        JetSimpleNameExpression nameExpression = (JetSimpleNameExpression)calleeExpression;
        Name referencedName = nameExpression.getReferencedNameAsName();
        ArrayList callableDescriptorCollectors = Lists.newArrayList();
        if (nameExpression.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER) {
            referencedName = Name.identifier(referencedName.asString().substring(1));
            callableDescriptorCollectors.add(CallableDescriptorCollectors.PROPERTIES);
        } else {
            callableDescriptorCollectors.add(CallableDescriptorCollectors.VARIABLES);
        }
        List prioritizedTasks = TaskPrioritizer.computePrioritizedTasks(context, referencedName, nameExpression, callableDescriptorCollectors);
        OverloadResolutionResultsImpl<VariableDescriptor> overloadResolutionResultsImpl = this.doResolveCallOrGetCachedResults(ResolutionResultsCache.PROPERTY_MEMBER_TYPE, context, prioritizedTasks, CallTransformer.PROPERTY_CALL_TRANSFORMER, nameExpression);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveSimpleProperty"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ExpressionTypingContext context, @NotNull Call call, @NotNull JetReferenceExpression functionReference, @NotNull Name name) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (functionReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallWithGivenName(BasicCallResolutionContext.create(context, call, CheckValueArgumentsMode.ENABLED), functionReference, name);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull BasicCallResolutionContext context, @NotNull JetReferenceExpression functionReference, @NotNull Name name) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (functionReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallWithGivenName(context, functionReference, name, true);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull BasicCallResolutionContext context, @NotNull JetReferenceExpression functionReference, @NotNull Name name, boolean allowVariableWithInvoke) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (functionReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        List collectors = allowVariableWithInvoke ? CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES : Collections.singletonList(CallableDescriptorCollectors.FUNCTIONS);
        List tasks = TaskPrioritizer.computePrioritizedTasks(context, name, functionReference, collectors);
        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.doResolveCallOrGetCachedResults(ResolutionResultsCache.FUNCTION_MEMBER_TYPE, context, tasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, functionReference);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveBinaryCall(ExpressionTypingContext context, ExpressionReceiver receiver, JetBinaryExpression binaryExpression, Name name) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallWithGivenName(context, CallMaker.makeCall((ReceiverValue)receiver, binaryExpression), binaryExpression.getOperationReference(), name);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveBinaryCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull Call call, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, boolean isAnnotationContext) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.resolveFunctionCall(BasicCallResolutionContext.create(trace, scope, call, expectedType, dataFlowInfo, ContextDependency.INDEPENDENT, CheckValueArgumentsMode.ENABLED, ResolutionResultsCacheImpl.create(), LabelResolver.create(), null, this.expressionTypingServices.createExtension(scope, isAnnotationContext), isAnnotationContext));
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        return overloadResolutionResultsImpl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    OverloadResolutionResultsImpl<FunctionDescriptor> resolveFunctionCall(@NotNull BasicCallResolutionContext context) {
        void var4_8;
        List prioritizedTasks;
        JetExpression calleeExpression;
        block30: {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            ProgressIndicatorProvider.checkCanceled();
            calleeExpression = context.call.getCalleeExpression();
            if (calleeExpression instanceof JetSimpleNameExpression) {
                JetSimpleNameExpression expression;
                JetSimpleNameExpression jetSimpleNameExpression = expression = (JetSimpleNameExpression)calleeExpression;
                Name name = expression.getReferencedNameAsName();
                prioritizedTasks = TaskPrioritizer.computePrioritizedTasks(context, name, jetSimpleNameExpression, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES);
                ResolutionTask.DescriptorCheckStrategy abstractConstructorCheck = new ResolutionTask.DescriptorCheckStrategy(){

                    @Override
                    public <D extends CallableDescriptor> boolean performAdvancedChecks(D descriptor, BindingTrace trace, TracingStrategy tracing) {
                        Modality modality;
                        if (descriptor instanceof ConstructorDescriptor && (modality = ((ConstructorDescriptor)descriptor).getContainingDeclaration().getModality()) == Modality.ABSTRACT) {
                            tracing.instantiationOfAbstractClass(trace);
                            return false;
                        }
                        return true;
                    }
                };
                for (ResolutionTask task : prioritizedTasks) {
                    task.setCheckingStrategy(abstractConstructorCheck);
                }
            } else {
                JetValueArgumentList reportAbsenceOn;
                JetValueArgumentList valueArgumentList = context.call.getValueArgumentList();
                PsiElement psiElement = reportAbsenceOn = valueArgumentList == null ? context.call.getCallElement() : valueArgumentList;
                if (calleeExpression instanceof JetConstructorCalleeExpression) {
                    assert (!context.call.getExplicitReceiver().exists());
                    JetConstructorCalleeExpression expression = (JetConstructorCalleeExpression)calleeExpression;
                    JetReferenceExpression jetReferenceExpression = expression.getConstructorReferenceExpression();
                    if (jetReferenceExpression == null) {
                        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
                        if (overloadResolutionResultsImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                        }
                        return overloadResolutionResultsImpl;
                    }
                    JetTypeReference typeReference = expression.getTypeReference();
                    assert (typeReference != null);
                    JetType constructedType = this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
                    if (constructedType.isError()) {
                        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
                        if (overloadResolutionResultsImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                        }
                        return overloadResolutionResultsImpl;
                    }
                    ClassifierDescriptor declarationDescriptor = constructedType.getConstructor().getDeclarationDescriptor();
                    if (declarationDescriptor instanceof ClassDescriptor) {
                        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
                        Collection<ConstructorDescriptor> constructors = classDescriptor.getConstructors();
                        if (constructors.isEmpty()) {
                            context.trace.report(Errors.NO_CONSTRUCTOR.on(reportAbsenceOn));
                            OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
                            if (overloadResolutionResultsImpl == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                            }
                            return overloadResolutionResultsImpl;
                        }
                        Collection candidates = TaskPrioritizer.convertWithImpliedThisAndNoReceiver(context.scope, constructors);
                        prioritizedTasks = TaskPrioritizer.computePrioritizedTasksFromCandidates(context, jetReferenceExpression, candidates, null);
                        break block30;
                    } else {
                        context.trace.report(Errors.NOT_A_CLASS.on(calleeExpression));
                        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
                        if (overloadResolutionResultsImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                        }
                        return overloadResolutionResultsImpl;
                    }
                }
                if (calleeExpression instanceof JetThisReferenceExpression) {
                    JetThisReferenceExpression jetThisReferenceExpression = (JetThisReferenceExpression)calleeExpression;
                    DeclarationDescriptor containingDeclaration = context.scope.getContainingDeclaration();
                    if (containingDeclaration instanceof ConstructorDescriptor) {
                        containingDeclaration = containingDeclaration.getContainingDeclaration();
                    }
                    assert (containingDeclaration instanceof ClassDescriptor);
                    ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
                    Collection<ConstructorDescriptor> constructors = classDescriptor.getConstructors();
                    if (constructors.isEmpty()) {
                        context.trace.report(Errors.NO_CONSTRUCTOR.on(reportAbsenceOn));
                        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
                        if (overloadResolutionResultsImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                        }
                        return overloadResolutionResultsImpl;
                    }
                    List candidates = ResolutionCandidate.convertCollection(constructors, JetPsiUtil.isSafeCall(context.call));
                    prioritizedTasks = Collections.singletonList(new ResolutionTask(candidates, jetThisReferenceExpression, context));
                } else if (calleeExpression != null) {
                    JetType calleeType = this.expressionTypingServices.safeGetType(context.scope, calleeExpression, TypeUtils.NO_EXPECTED_TYPE, context.dataFlowInfo, context.trace);
                    if (!KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(calleeType)) {
                        if (!calleeType.isError()) {
                            context.trace.report(Errors.CALLEE_NOT_A_FUNCTION.on(calleeExpression, calleeType));
                        }
                        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
                        if (overloadResolutionResultsImpl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                        }
                        return overloadResolutionResultsImpl;
                    }
                    ExpressionAsFunctionDescriptor functionDescriptor = new ExpressionAsFunctionDescriptor(context.scope.getContainingDeclaration(), Name.special("<for expression " + calleeExpression.getText() + ">"), calleeExpression);
                    FunctionDescriptorUtil.initializeFromFunctionType(functionDescriptor, calleeType, ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, Modality.FINAL, Visibilities.LOCAL);
                    ResolutionCandidate<ExpressionAsFunctionDescriptor> resolutionCandidate = ResolutionCandidate.create(functionDescriptor, JetPsiUtil.isSafeCall(context.call));
                    resolutionCandidate.setReceiverArgument(context.call.getExplicitReceiver());
                    resolutionCandidate.setExplicitReceiverKind(ExplicitReceiverKind.RECEIVER_ARGUMENT);
                    JetFakeReference jetFakeReference = new JetFakeReference(calleeExpression);
                    prioritizedTasks = Collections.singletonList(new ResolutionTask(Collections.singleton(resolutionCandidate), jetFakeReference, context));
                } else {
                    OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
                    if (overloadResolutionResultsImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
                    }
                    return overloadResolutionResultsImpl;
                }
            }
        }
        OverloadResolutionResultsImpl<FunctionDescriptor> results = this.doResolveCallOrGetCachedResults(ResolutionResultsCache.FUNCTION_MEMBER_TYPE, context, prioritizedTasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, (JetReferenceExpression)var4_8);
        if (calleeExpression instanceof JetSimpleNameExpression) {
            ExpressionTypingUtils.checkCapturingInClosure((JetSimpleNameExpression)calleeExpression, context.trace, context.scope);
        }
        OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        return overloadResolutionResultsImpl;
    }

    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithKnownCandidate(@NotNull Call call, @Nullable TracingStrategy tracing, @NotNull JetReferenceExpression reference, @NotNull ResolutionContext<?> context, @NotNull ResolutionCandidate<CallableDescriptor> candidate, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context, call, CheckValueArgumentsMode.ENABLED, dataFlowInfoForArguments);
        List tasks = TaskPrioritizer.computePrioritizedTasksFromCandidates(basicCallResolutionContext, reference, Collections.singleton(candidate), tracing);
        return this.doResolveCallOrGetCachedResults(ResolutionResultsCache.FUNCTION_MEMBER_TYPE, basicCallResolutionContext, tasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, reference);
    }

    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> doResolveCallOrGetCachedResults(@NotNull ResolutionResultsCache.MemberType<F> memberType, @NotNull BasicCallResolutionContext context, @NotNull List<ResolutionTask<D, F>> prioritizedTasks, @NotNull CallTransformer<D, F> callTransformer, @NotNull JetReferenceExpression reference) {
        OverloadResolutionResultsImpl<F> cachedResults;
        if (memberType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberType", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (prioritizedTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prioritizedTasks", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        OverloadResolutionResultsImpl<Object> results = null;
        TracingStrategy tracing = prioritizedTasks.isEmpty() ? TracingStrategy.EMPTY : prioritizedTasks.iterator().next().tracing;
        TemporaryBindingTrace traceToResolveCall = TemporaryBindingTrace.create(context.trace, "trace to resolve call", context.call);
        CallKey callKey = CallResolverUtil.createCallKey(context);
        if (callKey != null && (cachedResults = context.resolutionResultsCache.getResolutionResults(callKey, memberType)) != null) {
            DelegatingBindingTrace deltasTraceForResolve = context.resolutionResultsCache.getResolutionTrace(callKey);
            assert (deltasTraceForResolve != null);
            deltasTraceForResolve.addAllMyDataTo(traceToResolveCall);
            results = cachedResults;
        }
        if (results == null) {
            BasicCallResolutionContext newContext = (BasicCallResolutionContext)context.replaceBindingTrace(traceToResolveCall);
            results = this.doResolveCall(newContext, prioritizedTasks, callTransformer, reference);
            DelegatingBindingTrace deltasTraceForTypeInference = results.getTrace();
            if (deltasTraceForTypeInference != null) {
                deltasTraceForTypeInference.addAllMyDataTo(traceToResolveCall);
            }
            this.completeTypeInferenceDependentOnFunctionLiterals(newContext, results, tracing);
            CallResolver.cacheResults(memberType, context, results, traceToResolveCall, tracing);
        }
        traceToResolveCall.commit();
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            if ((results = this.completeTypeInferenceDependentOnExpectedType(context, results, tracing)).isSingleResult()) {
                results.getResultingCall().markCallAsCompleted();
            } else {
                this.argumentTypeResolver.checkTypesForFunctionArgumentsWithNoCallee(context);
                this.candidateResolver.completeNestedCallsForNotResolvedInvocation(context);
            }
        }
        if (results.isSingleResult()) {
            context.callResolverExtension.run(results.getResultingCall(), context);
        }
        return results;
    }

    private <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiterals(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (context.call.getCallType() == Call.CallType.INVOKE) {
            return;
        }
        if (!results.isSingleResult()) {
            if (results.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                this.argumentTypeResolver.checkTypesWithNoCallee(context, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            }
            return;
        }
        CallCandidateResolutionContext candidateContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(results.getResultingCall().getCallToCompleteTypeArgumentInference(), context, tracing);
        this.candidateResolver.completeTypeInferenceDependentOnFunctionLiteralsForCall(candidateContext);
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeTypeInferenceDependentOnExpectedType(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "completeTypeInferenceDependentOnExpectedType"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "completeTypeInferenceDependentOnExpectedType"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "completeTypeInferenceDependentOnExpectedType"));
        }
        if (context.call.getCallType() == Call.CallType.INVOKE) {
            return results;
        }
        if (results.isSingleResult()) {
            Set<ValueArgument> unmappedArguments = results.getResultingCall().getCallToCompleteTypeArgumentInference().getUnmappedArguments();
            this.argumentTypeResolver.checkUnmappedArgumentTypes(context, unmappedArguments);
            this.candidateResolver.completeUnmappedArguments(context, unmappedArguments);
        }
        if (!results.isSingleResult()) {
            return results;
        }
        ResolvedCall resolvedCall = results.getResultingCall();
        ResolvedCallImpl callToCompleteInference = resolvedCall.getCallToCompleteTypeArgumentInference();
        if (!callToCompleteInference.hasIncompleteTypeParameters()) {
            CallCandidateResolutionContext callCandidateResolutionContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(callToCompleteInference, context, tracing);
            this.candidateResolver.completeNestedCallsInference(callCandidateResolutionContext);
            this.candidateResolver.checkValueArgumentTypes(callCandidateResolutionContext);
            return results;
        }
        CallCandidateResolutionContext callCandidateResolutionContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(callToCompleteInference, context, tracing);
        this.candidateResolver.completeTypeInferenceDependentOnExpectedTypeForCall(callCandidateResolutionContext, false);
        if (callToCompleteInference.getStatus().isSuccess()) {
            return OverloadResolutionResultsImpl.success(resolvedCall);
        }
        return OverloadResolutionResultsImpl.incompleteTypeInference(resolvedCall);
    }

    private static <F extends CallableDescriptor> void cacheResults(@NotNull ResolutionResultsCache.MemberType<F> memberType, @NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<F> results, @NotNull DelegatingBindingTrace traceToResolveCall, @NotNull TracingStrategy tracing) {
        if (memberType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberType", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "cacheResults"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "cacheResults"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "cacheResults"));
        }
        if (traceToResolveCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceToResolveCall", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "cacheResults"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "cacheResults"));
        }
        CallKey callKey = CallResolverUtil.createCallKey(context);
        if (callKey == null) {
            return;
        }
        DelegatingBindingTrace deltasTraceToCacheResolve = new DelegatingBindingTrace(BindingContext.EMPTY, "delta trace for caching resolve of", context.call);
        traceToResolveCall.addAllMyDataTo(deltasTraceToCacheResolve);
        context.resolutionResultsCache.recordResolutionResults(callKey, memberType, results);
        context.resolutionResultsCache.recordResolutionTrace(callKey, deltasTraceToCacheResolve);
        if (results.isSingleResult()) {
            ResolvedCall resultingCall = results.getResultingCall();
            CallCandidateResolutionContext contextForCallToCompleteTypeArgumentInference = CallCandidateResolutionContext.createForCallBeingAnalyzed(results.getResultingCall().getCallToCompleteTypeArgumentInference(), context, tracing);
            context.resolutionResultsCache.recordDeferredComputationForCall(callKey, resultingCall, contextForCallToCompleteTypeArgumentInference);
        }
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> checkArgumentTypesAndFail(BasicCallResolutionContext context) {
        this.argumentTypeResolver.checkTypesWithNoCallee(context);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> doResolveCall(@NotNull BasicCallResolutionContext context, @NotNull List<ResolutionTask<D, F>> prioritizedTasks, @NotNull CallTransformer<D, F> callTransformer, @NotNull JetReferenceExpression reference) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (prioritizedTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prioritizedTasks", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCall"));
        }
        ResolutionDebugInfo.Data debugInfo = ResolutionDebugInfo.create();
        context.trace.record(ResolutionDebugInfo.RESOLUTION_DEBUG_INFO, context.call.getCallElement(), debugInfo);
        context.trace.record(BindingContext.RESOLUTION_SCOPE, context.call.getCalleeExpression(), context.scope);
        if (context.dataFlowInfo.hasTypeInfoConstraints()) {
            context.trace.record(BindingContext.NON_DEFAULT_EXPRESSION_DATA_FLOW, context.call.getCalleeExpression(), context.dataFlowInfo);
        }
        debugInfo.set(ResolutionDebugInfo.TASKS, prioritizedTasks);
        if (context.checkArguments == CheckValueArgumentsMode.ENABLED) {
            this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(context);
        }
        TemporaryBindingTrace traceForFirstNonemptyCandidateSet = null;
        OverloadResolutionResultsImpl<Object> resultsForFirstNonemptyCandidateSet = null;
        for (ResolutionTask<D, F> task : prioritizedTasks) {
            boolean updateResults;
            TemporaryBindingTrace taskTrace;
            OverloadResolutionResultsImpl<F> results = this.performResolutionGuardedForExtraFunctionLiteralArguments((ResolutionTask)task.replaceBindingTrace(taskTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve a task for", task.reference)), callTransformer);
            if (results.isSuccess() || results.isAmbiguity()) {
                taskTrace.commit();
                if (results.isSuccess()) {
                    debugInfo.set(ResolutionDebugInfo.RESULT, results.getResultingCall());
                }
                OverloadResolutionResultsImpl<F> overloadResolutionResultsImpl = results;
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCall"));
                }
                return overloadResolutionResultsImpl;
            }
            if (results.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                results.setTrace(taskTrace);
                OverloadResolutionResultsImpl<F> overloadResolutionResultsImpl = results;
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCall"));
                }
                return overloadResolutionResultsImpl;
            }
            boolean bl = updateResults = traceForFirstNonemptyCandidateSet == null || resultsForFirstNonemptyCandidateSet.getResultCode() == OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER && results.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER;
            if (task.getCandidates().isEmpty() || results.isNothing() || !updateResults) continue;
            traceForFirstNonemptyCandidateSet = taskTrace;
            resultsForFirstNonemptyCandidateSet = results;
        }
        if (traceForFirstNonemptyCandidateSet != null) {
            traceForFirstNonemptyCandidateSet.commit();
            if (resultsForFirstNonemptyCandidateSet.isSingleResult()) {
                debugInfo.set(ResolutionDebugInfo.RESULT, resultsForFirstNonemptyCandidateSet.getResultingCall());
            }
        } else {
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
            this.argumentTypeResolver.checkTypesWithNoCallee(context, CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
        }
        OverloadResolutionResultsImpl<Object> overloadResolutionResultsImpl = resultsForFirstNonemptyCandidateSet != null ? resultsForFirstNonemptyCandidateSet : OverloadResolutionResultsImpl.nameNotFound();
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "doResolveCall"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> performResolutionGuardedForExtraFunctionLiteralArguments(@NotNull ResolutionTask<D, F> task, @NotNull CallTransformer<D, F> callTransformer) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "performResolutionGuardedForExtraFunctionLiteralArguments"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "performResolutionGuardedForExtraFunctionLiteralArguments"));
        }
        OverloadResolutionResultsImpl<F> results = this.performResolution(task, callTransformer);
        ImmutableSet<OverloadResolutionResults.Code> someFailed = ImmutableSet.of(OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES, OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH);
        if (someFailed.contains((Object)results.getResultCode()) && !task.call.getFunctionLiteralArguments().isEmpty() && task.contextDependency == ContextDependency.INDEPENDENT) {
            DelegatingCall callWithoutFLArgs = new DelegatingCall(task.call){

                @Override
                @NotNull
                public List<JetExpression> getFunctionLiteralArguments() {
                    List<JetExpression> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver$2", "getFunctionLiteralArguments"));
                    }
                    return list;
                }
            };
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(task.trace, "trace for resolution guarded for extra function literal arguments");
            ResolutionTask newTask = ((ResolutionTask)task.replaceBindingTrace(temporaryTrace)).replaceCall(callWithoutFLArgs);
            OverloadResolutionResultsImpl resultsWithFunctionLiteralsStripped = this.performResolution(newTask, callTransformer);
            if (resultsWithFunctionLiteralsStripped.isSuccess() || resultsWithFunctionLiteralsStripped.isAmbiguity()) {
                task.tracing.danglingFunctionLiteralArgumentSuspected(task.trace, task.call.getFunctionLiteralArguments());
            }
        }
        OverloadResolutionResultsImpl<F> overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "performResolutionGuardedForExtraFunctionLiteralArguments"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> performResolution(@NotNull ResolutionTask<D, F> task, @NotNull CallTransformer<D, F> callTransformer) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "performResolution"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "performResolution"));
        }
        for (ResolutionCandidate<D> resolutionCandidate : task.getCandidates()) {
            TemporaryBindingTrace candidateTrace = TemporaryBindingTrace.create(task.trace, "trace to resolve candidate");
            Collection<CallCandidateResolutionContext<D>> contexts = callTransformer.createCallContexts(resolutionCandidate, task, candidateTrace);
            for (CallCandidateResolutionContext<D> context : contexts) {
                this.candidateResolver.performResolutionForCandidateCall(context, task);
                task.tracing.bindReference(context.candidateCall.getTrace(), context.candidateCall);
                Collection<ResolvedCallWithTrace<F>> calls = callTransformer.transformCall(context, this, task);
                for (ResolvedCallWithTrace<F> call : calls) {
                    task.tracing.bindReference(call.getTrace(), call);
                    task.tracing.bindResolvedCall(call.getTrace(), call);
                    task.getResolvedCalls().add(call);
                }
            }
        }
        OverloadResolutionResultsImpl results = ResolutionResultsHandler.INSTANCE.computeResultAndReportErrors(task.trace, task.tracing, task.getResolvedCalls());
        if (!results.isSingleResult() && !results.isIncomplete()) {
            this.argumentTypeResolver.checkTypesWithNoCallee(task.toBasic());
        }
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolver", "performResolution"));
        }
        return overloadResolutionResultsImpl;
    }
}

