/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lexer.JetTokens;

public class JetCallExpression
extends JetReferenceExpression
implements JetCallElement {
    public JetCallExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetCallExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetCallExpression", "accept"));
        }
        return visitor.visitCallExpression(this, data2);
    }

    @Override
    @Nullable
    public JetExpression getCalleeExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    @Nullable
    public JetValueArgumentList getValueArgumentList() {
        return (JetValueArgumentList)this.findChildByType(JetNodeTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @Nullable
    public JetTypeArgumentList getTypeArgumentList() {
        return (JetTypeArgumentList)this.findChildByType(JetNodeTypes.TYPE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<JetExpression> getFunctionLiteralArguments() {
        SmartList<JetExpression> result2 = new SmartList<JetExpression>();
        for (ASTNode node = (calleeExpression = this.getCalleeExpression()) instanceof JetFunctionLiteralExpression ? calleeExpression.getNode().getTreeNext() : this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            JetExpression labeledExpression;
            JetPrefixExpression prefixExpression;
            PsiElement psi = node.getPsi();
            if (psi instanceof JetFunctionLiteralExpression) {
                result2.add((JetFunctionLiteralExpression)psi);
                continue;
            }
            if (!(psi instanceof JetPrefixExpression) || !JetTokens.LABELS.contains((prefixExpression = (JetPrefixExpression)psi).getOperationReference().getReferencedNameElementType()) || !((labeledExpression = prefixExpression.getBaseExpression()) instanceof JetFunctionLiteralExpression)) continue;
            result2.add(prefixExpression);
        }
        SmartList<JetExpression> smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetCallExpression", "getFunctionLiteralArguments"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<? extends ValueArgument> getValueArguments() {
        JetValueArgumentList list = this.getValueArgumentList();
        List<Object> list2 = list != null ? list.getArguments() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetCallExpression", "getValueArguments"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<JetTypeProjection> getTypeArguments() {
        JetTypeArgumentList list = this.getTypeArgumentList();
        List<JetTypeProjection> list2 = list != null ? list.getArguments() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetCallExpression", "getTypeArguments"));
        }
        return list2;
    }
}

