/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.tree.AbstractInsnNode;
import org.jetbrains.asm4.tree.FieldInsnNode;
import org.jetbrains.asm4.tree.MethodNode;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.LambdaInfo;
import org.jetbrains.jet.codegen.inline.MethodInliner;
import org.jetbrains.jet.codegen.inline.Parameters;
import org.jetbrains.jet.codegen.inline.ParametersBuilder;

public class FieldRemapper {
    private final String lambdaInternalName;
    protected FieldRemapper parent;
    private final Parameters params;

    public FieldRemapper(@Nullable String lambdaInternalName, @Nullable FieldRemapper parent, @NotNull Parameters methodParams) {
        if (methodParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodParams", "org/jetbrains/jet/codegen/inline/FieldRemapper", "<init>"));
        }
        this.lambdaInternalName = lambdaInternalName;
        this.parent = parent;
        this.params = methodParams;
    }

    public void addCapturedFields(LambdaInfo lambdaInfo, ParametersBuilder builder) {
        for (CapturedParamInfo info : lambdaInfo.getCapturedVars()) {
            builder.addCapturedParam(info, info);
        }
    }

    public boolean canProcess(@NotNull String fieldOwner) {
        if (fieldOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldOwner", "org/jetbrains/jet/codegen/inline/FieldRemapper", "canProcess"));
        }
        return fieldOwner.equals(this.getLambdaInternalName());
    }

    @Nullable
    public AbstractInsnNode transformIfNeeded(@NotNull List<AbstractInsnNode> capturedFieldAccess, @NotNull MethodNode node) {
        if (capturedFieldAccess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capturedFieldAccess", "org/jetbrains/jet/codegen/inline/FieldRemapper", "transformIfNeeded"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/FieldRemapper", "transformIfNeeded"));
        }
        if (capturedFieldAccess.size() == 1) {
            return null;
        }
        return this.transformIfNeeded(capturedFieldAccess, 1, node);
    }

    @Nullable
    private AbstractInsnNode transformIfNeeded(@NotNull List<AbstractInsnNode> capturedFieldAccess, int currentInstruction, @NotNull MethodNode node) {
        boolean checkParent;
        if (capturedFieldAccess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capturedFieldAccess", "org/jetbrains/jet/codegen/inline/FieldRemapper", "transformIfNeeded"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/FieldRemapper", "transformIfNeeded"));
        }
        AbstractInsnNode transformed2 = null;
        boolean bl = checkParent = !this.isRoot() && currentInstruction < capturedFieldAccess.size() - 1;
        if (checkParent) {
            transformed2 = this.parent.transformIfNeeded(capturedFieldAccess, currentInstruction + 1, node);
        }
        if (transformed2 == null) {
            FieldInsnNode insnNode = (FieldInsnNode)capturedFieldAccess.get(currentInstruction);
            if (this.canProcess(insnNode.owner)) {
                insnNode.name = "$$$" + insnNode.name;
                insnNode.setOpcode(178);
                for (AbstractInsnNode next = capturedFieldAccess.get(0); next != insnNode; next = next.getNext()) {
                    AbstractInsnNode toDelete = next;
                    node.instructions.remove(toDelete);
                }
                transformed2 = capturedFieldAccess.get(capturedFieldAccess.size() - 1);
            }
        }
        return transformed2;
    }

    public CapturedParamInfo findField(@NotNull FieldInsnNode fieldInsnNode) {
        if (fieldInsnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldInsnNode", "org/jetbrains/jet/codegen/inline/FieldRemapper", "findField"));
        }
        return this.findField(fieldInsnNode, this.params.getCaptured());
    }

    @Nullable
    public CapturedParamInfo findField(@NotNull FieldInsnNode fieldInsnNode, @NotNull Collection<CapturedParamInfo> captured) {
        if (fieldInsnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldInsnNode", "org/jetbrains/jet/codegen/inline/FieldRemapper", "findField"));
        }
        if (captured == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captured", "org/jetbrains/jet/codegen/inline/FieldRemapper", "findField"));
        }
        for (CapturedParamInfo valueDescriptor : captured) {
            if (!valueDescriptor.getFieldName().equals(fieldInsnNode.name) || !fieldInsnNode.owner.equals(valueDescriptor.getContainingLambdaName())) continue;
            return valueDescriptor;
        }
        return null;
    }

    public FieldRemapper getParent() {
        return this.parent;
    }

    public String getLambdaInternalName() {
        return this.lambdaInternalName;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    @Nullable
    public StackValue getFieldForInline(@NotNull FieldInsnNode node, @Nullable StackValue prefix) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/FieldRemapper", "getFieldForInline"));
        }
        CapturedParamInfo field = MethodInliner.findCapturedField(node, this);
        return field.getRemapValue();
    }
}

