/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollectorPlainTextToStream;

public class MessageCollectorToString
implements MessageCollector {
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private final MessageCollector actualCollector = new MessageCollectorPlainTextToStream(new PrintStream(this.outputStream), MessageCollectorPlainTextToStream.NON_VERBOSE);
    private static final Charset UTF8 = Charset.forName("utf-8");

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/jet/cli/common/messages/MessageCollectorToString", "report"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jet/cli/common/messages/MessageCollectorToString", "report"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/jet/cli/common/messages/MessageCollectorToString", "report"));
        }
        this.actualCollector.report(severity, message, location);
    }

    @NotNull
    public String getString() {
        String string = UTF8.decode(ByteBuffer.wrap(this.outputStream.toByteArray())).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/messages/MessageCollectorToString", "getString"));
        }
        return string;
    }
}

