/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.tasks.AbstractTracingStrategy;
import org.jetbrains.jet.lang.types.JetType;

public class TracingStrategyForInvoke
extends AbstractTracingStrategy {
    private final JetType calleeType;

    public TracingStrategyForInvoke(@NotNull JetExpression reference, @NotNull Call call, @NotNull JetType calleeType) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyForInvoke", "<init>"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyForInvoke", "<init>"));
        }
        if (calleeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeType", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyForInvoke", "<init>"));
        }
        super(reference, call);
        this.calleeType = calleeType;
    }

    @Override
    public void bindCall(@NotNull BindingTrace trace, @NotNull Call call) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyForInvoke", "bindCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyForInvoke", "bindCall"));
        }
        if (this.reference instanceof JetSimpleNameExpression) {
            return;
        }
        trace.record(BindingContext.CALL, this.reference, call);
    }

    @Override
    public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyForInvoke", "bindReference"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyForInvoke", "bindReference"));
        }
    }

    @Override
    public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyForInvoke", "bindResolvedCall"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyForInvoke", "bindResolvedCall"));
        }
        trace.record(BindingContext.RESOLVED_CALL, this.reference, resolvedCall);
    }

    @Override
    public void unresolvedReference(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyForInvoke", "unresolvedReference"));
        }
        trace.report(Errors.FUNCTION_EXPECTED.on(this.reference, this.reference, this.calleeType));
    }

    @Override
    public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyForInvoke", "unresolvedReferenceWrongReceiver"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyForInvoke", "unresolvedReferenceWrongReceiver"));
        }
        trace.report(Errors.FUNCTION_EXPECTED.on(this.reference, this.reference, this.calleeType));
    }
}

