/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.stubs.PsiJetClassStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetClassElementType;
import org.jetbrains.jet.lang.psi.stubs.impl.JetStubBaseImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class PsiJetClassStubImpl
extends JetStubBaseImpl<JetClass>
implements PsiJetClassStub {
    private final StringRef qualifiedName;
    private final StringRef name;
    private final StringRef[] superNames;
    private final boolean isTrait;
    private final boolean isEnumEntry;
    private final boolean isLocal;
    private final boolean isTopLevel;

    public PsiJetClassStubImpl(JetClassElementType type, StubElement parent, StringRef qualifiedName, StringRef name, StringRef[] superNames, boolean isTrait, boolean isEnumEntry, boolean isLocal, boolean isTopLevel) {
        super((StubElement<? extends PsiElement>)parent, (IStubElementType<? extends StubElement<? extends Object>, ? extends PsiElement>)type);
        this.qualifiedName = qualifiedName;
        this.name = name;
        this.superNames = superNames;
        this.isTrait = isTrait;
        this.isEnumEntry = isEnumEntry;
        this.isLocal = isLocal;
        this.isTopLevel = isTopLevel;
    }

    @Override
    public FqName getFqName() {
        String stringRef = StringRef.toString(this.qualifiedName);
        if (stringRef == null) {
            return null;
        }
        return new FqName(stringRef);
    }

    @Override
    public boolean isTrait() {
        return this.isTrait;
    }

    @Override
    public boolean isEnumEntry() {
        return this.isEnumEntry;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public String getName() {
        return StringRef.toString(this.name);
    }

    @Override
    @NotNull
    public List<String> getSuperNames() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (StringRef ref : this.superNames) {
            result2.add(ref.toString());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetClassStubImpl", "getSuperNames"));
        }
        return arrayList;
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }
}

