/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.jet.lang.psi.stubs.PsiJetObjectStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.StubIndexServiceFactory;
import org.jetbrains.jet.lang.psi.stubs.impl.PsiJetObjectStubImpl;
import org.jetbrains.jet.lang.psi.stubs.impl.Utils;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class JetObjectElementType
extends JetStubElementType<PsiJetObjectStub, JetObjectDeclaration> {
    public JetObjectElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/psi/stubs/elements/JetObjectElementType", "<init>"));
        }
        super(debugName, JetObjectDeclaration.class, PsiJetObjectStub.class);
    }

    @Override
    public PsiJetObjectStub createStub(@NotNull JetObjectDeclaration psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/jet/lang/psi/stubs/elements/JetObjectElementType", "createStub"));
        }
        String name = psi.getName();
        FqName fqName = ResolveSessionUtils.safeFqNameForLazyResolve(psi);
        List<String> superNames = PsiUtilPackage.getSuperNames(psi);
        return new PsiJetObjectStubImpl(parentStub, StringRef.fromString(name), fqName, Utils.instance$.wrapStrings(superNames), psi.isTopLevel(), JetObjectElementType.isClassObject(psi), psi.isLocal(), psi.isObjectLiteral());
    }

    @Override
    public void serialize(@NotNull PsiJetObjectStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetObjectElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/jet/lang/psi/stubs/elements/JetObjectElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        FqName fqName = stub.getFqName();
        dataStream.writeName(fqName != null ? fqName.toString() : null);
        dataStream.writeBoolean(stub.isTopLevel());
        dataStream.writeBoolean(stub.isClassObject());
        dataStream.writeBoolean(stub.isLocal());
        dataStream.writeBoolean(stub.isObjectLiteral());
        List<String> superNames = stub.getSuperNames();
        dataStream.writeVarInt(superNames.size());
        for (String name : superNames) {
            dataStream.writeName(name);
        }
    }

    @Override
    @NotNull
    public PsiJetObjectStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/jet/lang/psi/stubs/elements/JetObjectElementType", "deserialize"));
        }
        StringRef name = dataStream.readName();
        StringRef fqNameStr = dataStream.readName();
        FqName fqName = fqNameStr != null ? new FqName(fqNameStr.toString()) : null;
        boolean isTopLevel = dataStream.readBoolean();
        boolean isClassObject = dataStream.readBoolean();
        boolean isLocal = dataStream.readBoolean();
        boolean isObjectLiteral = dataStream.readBoolean();
        int superCount = dataStream.readVarInt();
        StringRef[] superNames = StringRef.createArray(superCount);
        for (int i = 0; i < superCount; ++i) {
            superNames[i] = dataStream.readName();
        }
        PsiJetObjectStubImpl psiJetObjectStubImpl = new PsiJetObjectStubImpl(parentStub, name, fqName, superNames, isTopLevel, isClassObject, isLocal, isObjectLiteral);
        if (psiJetObjectStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetObjectElementType", "deserialize"));
        }
        return psiJetObjectStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiJetObjectStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetObjectElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/jet/lang/psi/stubs/elements/JetObjectElementType", "indexStub"));
        }
        StubIndexServiceFactory.getInstance().indexObject(stub, sink);
    }

    private static boolean isClassObject(@NotNull JetObjectDeclaration objectDeclaration) {
        if (objectDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDeclaration", "org/jetbrains/jet/lang/psi/stubs/elements/JetObjectElementType", "isClassObject"));
        }
        return objectDeclaration.getParent() instanceof JetClassObject;
    }
}

