/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PositioningStrategy<E extends PsiElement> {
    @NotNull
    public List<TextRange> mark(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "mark"));
        }
        List<TextRange> list = PositioningStrategy.markElement(element);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "mark"));
        }
        return list;
    }

    public boolean isValid(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "isValid"));
        }
        return !PositioningStrategy.hasSyntaxErrors(element);
    }

    @NotNull
    protected static List<TextRange> markElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markElement"));
        }
        List<TextRange> list = Collections.singletonList(element.getTextRange());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markElement"));
        }
        return list;
    }

    @NotNull
    protected static List<TextRange> markNode(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markNode"));
        }
        List<TextRange> list = Collections.singletonList(node.getTextRange());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markNode"));
        }
        return list;
    }

    @NotNull
    protected static List<TextRange> markRange(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markRange"));
        }
        List<TextRange> list = Collections.singletonList(range);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "markRange"));
        }
        return list;
    }

    protected static boolean hasSyntaxErrors(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/jet/lang/diagnostics/PositioningStrategy", "hasSyntaxErrors"));
        }
        if (psiElement instanceof PsiErrorElement) {
            return true;
        }
        PsiElement[] children = psiElement.getChildren();
        return children.length > 0 && PositioningStrategy.hasSyntaxErrors(children[children.length - 1]);
    }
}

