/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public abstract class DeclarationDescriptorImpl
extends AnnotatedImpl
implements DeclarationDescriptor {
    @NotNull
    private final Name name;

    public DeclarationDescriptorImpl(@NotNull Annotations annotations, @NotNull Name name) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/descriptors/impl/DeclarationDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/DeclarationDescriptorImpl", "<init>"));
        }
        super(annotations);
        this.name = name;
    }

    @Override
    @NotNull
    public Name getName() {
        Name name = this.name;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/DeclarationDescriptorImpl", "getName"));
        }
        return name;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        DeclarationDescriptorImpl declarationDescriptorImpl = this;
        if (declarationDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/DeclarationDescriptorImpl", "getOriginal"));
        }
        return declarationDescriptorImpl;
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        this.accept(visitor, null);
    }

    public String toString() {
        return DeclarationDescriptorImpl.toString(this);
    }

    @NotNull
    static String toString(@NotNull DeclarationDescriptor descriptor) {
        String string;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/descriptors/impl/DeclarationDescriptorImpl", "toString"));
        }
        try {
            string = DescriptorRenderer.DEBUG_TEXT.render(descriptor) + "[" + descriptor.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(descriptor)) + "]";
        }
        catch (Throwable e) {
            String string2 = descriptor.getClass().getSimpleName() + " " + descriptor.getName();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/DeclarationDescriptorImpl", "toString"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/DeclarationDescriptorImpl", "toString"));
        }
        return string;
    }
}

