/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartFMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.GenerationTrigger;
import org.jetbrains.jet.lang.cfg.JetControlFlowBuilder;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.LoopInfo;
import org.jetbrains.jet.lang.cfg.WhenChecker;
import org.jetbrains.jet.lang.cfg.pseudocode.AllTypes;
import org.jetbrains.jet.lang.cfg.pseudocode.JetControlFlowInstructionsGenerator;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudoValue;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudocodePackage;
import org.jetbrains.jet.lang.cfg.pseudocode.SingleType;
import org.jetbrains.jet.lang.cfg.pseudocode.TypePredicate;
import org.jetbrains.jet.lang.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.jet.lang.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.jet.lang.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotatedExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionWithLabel;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFinallySection;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetLabeledExpression;
import org.jetbrains.jet.lang.psi.JetLoopExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetMultiDeclarationEntry;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStatementExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoidWithParameter;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.CompileTimeConstantUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ArgumentMapping;
import org.jetbrains.jet.lang.resolve.calls.model.ArgumentMatch;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class JetControlFlowProcessor {
    private final JetControlFlowBuilder builder = new JetControlFlowInstructionsGenerator();
    private final BindingTrace trace;

    public JetControlFlowProcessor(BindingTrace trace) {
        this.trace = trace;
    }

    @NotNull
    public Pseudocode generatePseudocode(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generatePseudocode"));
        }
        Pseudocode pseudocode = this.generate(subroutine);
        ((PseudocodeImpl)pseudocode).postProcess();
        Pseudocode pseudocode2 = pseudocode;
        if (pseudocode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generatePseudocode"));
        }
        return pseudocode2;
    }

    @NotNull
    private Pseudocode generate(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generate"));
        }
        this.builder.enterSubroutine(subroutine);
        CFPVisitor cfpVisitor = new CFPVisitor(this.builder);
        if (subroutine instanceof JetDeclarationWithBody) {
            JetDeclarationWithBody declarationWithBody = (JetDeclarationWithBody)subroutine;
            List<JetParameter> valueParameters = declarationWithBody.getValueParameters();
            for (JetParameter valueParameter : valueParameters) {
                cfpVisitor.generateInstructions(valueParameter, CFPContext.NOT_IN_CONDITION);
            }
            JetExpression bodyExpression = declarationWithBody.getBodyExpression();
            if (bodyExpression != null) {
                cfpVisitor.generateInstructions(bodyExpression, CFPContext.NOT_IN_CONDITION);
            }
        } else {
            cfpVisitor.generateInstructions(subroutine, CFPContext.NOT_IN_CONDITION);
        }
        Pseudocode pseudocode = this.builder.exitSubroutine(subroutine);
        if (pseudocode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "generate"));
        }
        return pseudocode;
    }

    private void processLocalDeclaration(@NotNull JetDeclaration subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor", "processLocalDeclaration"));
        }
        JetElement parent = PsiTreeUtil.getParentOfType((PsiElement)subroutine, JetElement.class);
        assert (parent != null);
        Label afterDeclaration = this.builder.createUnboundLabel();
        this.builder.nondeterministicJump(afterDeclaration, parent, null);
        this.generate(subroutine);
        this.builder.bindLabel(afterDeclaration);
    }

    private class CFPVisitor
    extends JetVisitorVoidWithParameter<CFPContext> {
        private final JetControlFlowBuilder builder;
        private final JetVisitorVoidWithParameter<CFPContext> conditionVisitor;

        private CFPVisitor(@NotNull JetControlFlowBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "<init>"));
            }
            this.conditionVisitor = new JetVisitorVoidWithParameter<CFPContext>(){

                @Override
                public void visitWhenConditionInRangeVoid(@NotNull JetWhenConditionInRange condition, CFPContext context) {
                    if (condition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionInRangeVoid"));
                    }
                    CFPVisitor.this.generateInstructions(condition.getRangeExpression(), context);
                    CFPVisitor.this.generateInstructions(condition.getOperationReference(), context);
                    CFPVisitor.this.createNonSyntheticValue(condition, new JetElement[]{condition.getRangeExpression(), condition.getOperationReference()});
                }

                @Override
                public void visitWhenConditionIsPatternVoid(@NotNull JetWhenConditionIsPattern condition, CFPContext context) {
                    if (condition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionIsPatternVoid"));
                    }
                }

                @Override
                public void visitWhenConditionWithExpressionVoid(@NotNull JetWhenConditionWithExpression condition, CFPContext context) {
                    if (condition == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionWithExpressionVoid"));
                    }
                    CFPVisitor.this.generateInstructions(condition.getExpression(), context);
                    CFPVisitor.this.copyValue(condition.getExpression(), condition);
                }

                @Override
                public void visitJetElementVoid(@NotNull JetElement element, CFPContext context) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitJetElementVoid"));
                    }
                    throw new UnsupportedOperationException("[JetControlFlowProcessor] " + element.toString());
                }
            };
            this.builder = builder;
        }

        private void mark(JetElement element) {
            this.builder.mark(element);
        }

        public void generateInstructions(@Nullable JetElement element, CFPContext context) {
            if (element == null) {
                return;
            }
            element.accept(this, context);
            this.checkNothingType(element);
        }

        private void checkNothingType(JetElement element) {
            if (!(element instanceof JetExpression)) {
                return;
            }
            JetExpression expression = JetPsiUtil.deparenthesize((JetExpression)element);
            if (expression == null) {
                return;
            }
            if (expression instanceof JetStatementExpression || expression instanceof JetTryExpression || expression instanceof JetIfExpression || expression instanceof JetWhenExpression) {
                return;
            }
            JetType type = JetControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression);
            if (type != null && KotlinBuiltIns.getInstance().isNothing(type)) {
                this.builder.jumpToError(expression);
            }
        }

        @NotNull
        private PseudoValue createSyntheticValue(@NotNull JetElement instructionElement, JetElement ... from) {
            if (instructionElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructionElement", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            List<PseudoValue> values = this.elementsToValues(from.length > 0 ? Arrays.asList(from) : Collections.emptyList());
            PseudoValue pseudoValue = this.builder.magic(instructionElement, null, values, this.defaultTypeMap(values), true).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            return pseudoValue;
        }

        @NotNull
        private PseudoValue createNonSyntheticValue(@NotNull JetElement to, @NotNull List<? extends JetElement> from) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            List<PseudoValue> values = this.elementsToValues(from);
            PseudoValue pseudoValue = this.builder.magic(to, to, values, this.defaultTypeMap(values), false).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            return pseudoValue;
        }

        @NotNull
        private PseudoValue createNonSyntheticValue(@NotNull JetElement to, JetElement ... from) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            PseudoValue pseudoValue = this.createNonSyntheticValue(to, Arrays.asList(from));
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            return pseudoValue;
        }

        @NotNull
        private Map<PseudoValue, TypePredicate> defaultTypeMap(List<PseudoValue> values) {
            Map<PseudoValue, TypePredicate> map2 = PseudocodePackage.expectedTypeFor(AllTypes.instance$, values);
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "defaultTypeMap"));
            }
            return map2;
        }

        private void mergeValues(@NotNull List<JetExpression> from, @NotNull JetExpression to) {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "mergeValues"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "mergeValues"));
            }
            List<PseudoValue> values = this.elementsToValues(from);
            switch (values.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.builder.bindValue(values.get(0), to);
                    break;
                }
                default: {
                    this.builder.merge(to, values);
                }
            }
        }

        private void copyValue(@Nullable JetElement from, @NotNull JetElement to) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "copyValue"));
            }
            PseudoValue value = this.builder.getBoundValue(from);
            if (value != null) {
                this.builder.bindValue(value, to);
            }
        }

        private List<PseudoValue> elementsToValues(List<? extends JetElement> from) {
            if (from.isEmpty()) {
                return Collections.emptyList();
            }
            return KotlinPackage.filterNotNull(KotlinPackage.map(from, new Function1<JetElement, PseudoValue>(){

                @Override
                public PseudoValue invoke(JetElement element) {
                    return CFPVisitor.this.builder.getBoundValue(element);
                }
            }));
        }

        private void generateInitializer(@NotNull JetDeclaration declaration, @NotNull PseudoValue initValue) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateInitializer"));
            }
            if (initValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initValue", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateInitializer"));
            }
            this.builder.write(declaration, declaration, initValue, this.getDeclarationAccessTarget(declaration), Collections.<PseudoValue, ReceiverValue>emptyMap());
        }

        @NotNull
        private AccessTarget getResolvedCallAccessTarget(JetElement element) {
            ResolvedCall<?> resolvedCall = JetControlFlowProcessor.this.trace.get(BindingContext.RESOLVED_CALL, element);
            AccessTarget accessTarget = resolvedCall != null ? new AccessTarget.Call(resolvedCall) : AccessTarget.BlackBox.instance$;
            if (accessTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "getResolvedCallAccessTarget"));
            }
            return accessTarget;
        }

        @NotNull
        private AccessTarget getDeclarationAccessTarget(JetElement element) {
            DeclarationDescriptor descriptor = JetControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
            AccessTarget accessTarget = descriptor instanceof VariableDescriptor ? new AccessTarget.Declaration((VariableDescriptor)descriptor) : AccessTarget.BlackBox.instance$;
            if (accessTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "getDeclarationAccessTarget"));
            }
            return accessTarget;
        }

        @Override
        public void visitParenthesizedExpressionVoid(@NotNull JetParenthesizedExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitParenthesizedExpressionVoid"));
            }
            this.mark(expression);
            JetExpression innerExpression = expression.getExpression();
            if (innerExpression != null) {
                this.generateInstructions(innerExpression, context);
                this.copyValue(innerExpression, expression);
            }
        }

        @Override
        public void visitAnnotatedExpressionVoid(@NotNull JetAnnotatedExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitAnnotatedExpressionVoid"));
            }
            JetExpression baseExpression = expression.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression, context);
                this.copyValue(baseExpression, expression);
            }
        }

        @Override
        public void visitThisExpressionVoid(@NotNull JetThisExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitThisExpressionVoid"));
            }
            ResolvedCall<?> resolvedCall = this.getResolvedCall(expression);
            if (resolvedCall == null) {
                this.createNonSyntheticValue((JetElement)expression, new JetElement[0]);
                return;
            }
            Object resultingDescriptor = resolvedCall.getResultingDescriptor();
            if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
                this.builder.readVariable(expression, expression, resolvedCall, this.getReceiverValues(expression, resolvedCall, true));
            }
            this.copyValue(expression, expression.getInstanceReference());
        }

        @Override
        public void visitConstantExpressionVoid(@NotNull JetConstantExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitConstantExpressionVoid"));
            }
            CompileTimeConstant<?> constant = JetControlFlowProcessor.this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
            this.builder.loadConstant(expression, constant);
        }

        @Override
        public void visitSimpleNameExpressionVoid(@NotNull JetSimpleNameExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitSimpleNameExpressionVoid"));
            }
            ResolvedCall<?> resolvedCall = this.getResolvedCall(expression);
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)((Object)resolvedCall);
                this.generateCall(expression, expression, variableAsFunctionResolvedCall.getVariableCall());
            } else if (!this.generateCall(expression, expression) && !(expression.getParent() instanceof JetCallExpression)) {
                this.createNonSyntheticValue((JetElement)expression, this.generateAndGetReceiverIfAny(expression));
            }
        }

        @Override
        public void visitLabeledExpressionVoid(@NotNull JetLabeledExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitLabeledExpressionVoid"));
            }
            this.mark(expression);
            JetExpression baseExpression = expression.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression, context);
                this.copyValue(baseExpression, expression);
            }
        }

        @Override
        public void visitBinaryExpressionVoid(@NotNull JetBinaryExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBinaryExpressionVoid"));
            }
            JetSimpleNameExpression operationReference = expression.getOperationReference();
            IElementType operationType = operationReference.getReferencedNameElementType();
            if (!ImmutableSet.of(JetTokens.ANDAND, JetTokens.OROR, JetTokens.EQ, JetTokens.ELVIS).contains(operationType)) {
                this.mark(expression);
            }
            JetExpression left = expression.getLeft();
            JetExpression right = expression.getRight();
            if (operationType == JetTokens.ANDAND) {
                this.generateInstructions(left, CFPContext.IN_CONDITION);
                Label resultLabel = this.builder.createUnboundLabel();
                this.builder.jumpOnFalse(resultLabel, expression, this.builder.getBoundValue(left));
                if (right != null) {
                    this.generateInstructions(right, CFPContext.IN_CONDITION);
                }
                this.builder.bindLabel(resultLabel);
                if (!context.inCondition()) {
                    this.predefinedOperation(expression, JetControlFlowBuilder.PredefinedOperation.AND);
                }
            } else if (operationType == JetTokens.OROR) {
                this.generateInstructions(left, CFPContext.IN_CONDITION);
                Label resultLabel = this.builder.createUnboundLabel();
                this.builder.jumpOnTrue(resultLabel, expression, this.builder.getBoundValue(left));
                if (right != null) {
                    this.generateInstructions(right, CFPContext.IN_CONDITION);
                }
                this.builder.bindLabel(resultLabel);
                if (!context.inCondition()) {
                    this.predefinedOperation(expression, JetControlFlowBuilder.PredefinedOperation.OR);
                }
            } else if (operationType == JetTokens.EQ) {
                this.visitAssignment(left, this.getDeferredValue(right), expression);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
                ResolvedCall<?> resolvedCall = this.getResolvedCall(operationReference);
                if (resolvedCall != null) {
                    Object descriptor = resolvedCall.getResultingDescriptor();
                    Name assignMethodName = OperatorConventions.getNameForOperationSymbol((JetToken)expression.getOperationToken());
                    if (descriptor.getName().equals(assignMethodName)) {
                        this.generateCall(expression, operationReference, resolvedCall);
                    } else {
                        Function0<PseudoValue> rhsDeferredValue = this.getValueAsFunction(this.generateCall(null, operationReference, resolvedCall).getOutputValue());
                        this.visitAssignment(left, rhsDeferredValue, expression);
                    }
                } else {
                    this.generateBothArguments(expression);
                }
            } else if (operationType == JetTokens.ELVIS) {
                this.generateInstructions(left, CFPContext.NOT_IN_CONDITION);
                Label afterElvis = this.builder.createUnboundLabel();
                this.builder.jumpOnTrue(afterElvis, expression, this.builder.getBoundValue(left));
                if (right != null) {
                    this.generateInstructions(right, CFPContext.NOT_IN_CONDITION);
                }
                this.builder.bindLabel(afterElvis);
                this.mergeValues(Arrays.asList(left, right), expression);
            } else if (!this.generateCall(expression, operationReference)) {
                this.generateBothArguments(expression);
            }
        }

        private Function0<PseudoValue> getValueAsFunction(final PseudoValue value) {
            return new Function0<PseudoValue>(){

                @Override
                public PseudoValue invoke() {
                    return value;
                }
            };
        }

        private Function0<PseudoValue> getDeferredValue(final JetExpression expression) {
            return new Function0<PseudoValue>(){

                @Override
                public PseudoValue invoke() {
                    CFPVisitor.this.generateInstructions(expression, CFPContext.NOT_IN_CONDITION);
                    return CFPVisitor.this.builder.getBoundValue(expression);
                }
            };
        }

        private void predefinedOperation(JetBinaryExpression expression, JetControlFlowBuilder.PredefinedOperation operation) {
            this.builder.predefinedOperation(expression, operation, this.elementsToValues(Arrays.asList(expression.getLeft(), expression.getRight())));
        }

        private void generateBothArguments(JetBinaryExpression expression) {
            JetExpression right;
            JetExpression left = JetPsiUtil.deparenthesize(expression.getLeft());
            if (left != null) {
                this.generateInstructions(left, CFPContext.NOT_IN_CONDITION);
            }
            if ((right = expression.getRight()) != null) {
                this.generateInstructions(right, CFPContext.NOT_IN_CONDITION);
            }
            this.createNonSyntheticValue((JetElement)expression, left, right);
        }

        private void visitAssignment(JetExpression lhs, @NotNull Function0<PseudoValue> rhsDeferredValue, JetExpression parentExpression) {
            if (rhsDeferredValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhsDeferredValue", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitAssignment"));
            }
            JetExpression left = JetPsiUtil.deparenthesize(lhs);
            if (left == null) {
                this.builder.compilationError(lhs, "No lValue in assignment");
                return;
            }
            if (left instanceof JetArrayAccessExpression) {
                this.generateArrayAssignment((JetArrayAccessExpression)left, rhsDeferredValue, parentExpression);
                return;
            }
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = SmartFMap.emptyMap();
            AccessTarget accessTarget = AccessTarget.BlackBox.instance$;
            boolean unsupported = false;
            if (left instanceof JetSimpleNameExpression || left instanceof JetQualifiedExpression) {
                accessTarget = this.getResolvedCallAccessTarget(PsiUtilPackage.getQualifiedElementSelector(left));
                if (accessTarget instanceof AccessTarget.Call) {
                    receiverValues = this.getReceiverValues(lhs, ((AccessTarget.Call)accessTarget).getResolvedCall(), true);
                }
            } else if (left instanceof JetProperty) {
                accessTarget = this.getDeclarationAccessTarget(left);
            } else {
                unsupported = true;
            }
            PseudoValue rhsValue = rhsDeferredValue.invoke();
            if (unsupported) {
                this.builder.unsupported(parentExpression);
            } else {
                this.recordWrite(left, accessTarget, rhsValue, receiverValues, parentExpression);
            }
        }

        private void generateArrayAssignment(JetArrayAccessExpression lhs, @NotNull Function0<PseudoValue> rhsDeferredValue, JetExpression parentExpression) {
            if (rhsDeferredValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhsDeferredValue", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateArrayAssignment"));
            }
            ResolvedCall<FunctionDescriptor> setResolvedCall = JetControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_SET, lhs);
            if (setResolvedCall == null) {
                this.generateArrayAccess(lhs, null);
                return;
            }
            if (((JetOperationExpression)((Object)parentExpression)).getOperationReference().getReferencedNameElementType() == JetTokens.EQ) {
                this.mark(lhs);
            }
            this.generateInstructions(lhs.getArrayExpression(), CFPContext.NOT_IN_CONDITION);
            Map<PseudoValue, ReceiverValue> receiverValues = this.getReceiverValues(lhs, setResolvedCall, false);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = this.getArraySetterArguments(rhsDeferredValue, setResolvedCall);
            this.builder.call(parentExpression, parentExpression, setResolvedCall, receiverValues, argumentValues);
        }

        private SmartFMap<PseudoValue, ValueParameterDescriptor> getArraySetterArguments(Function0<PseudoValue> rhsDeferredValue, final ResolvedCall<FunctionDescriptor> setResolvedCall) {
            List valueArguments = KotlinPackage.flatMapTo(setResolvedCall.getResultingDescriptor().getValueParameters(), new ArrayList(), new Function1<ValueParameterDescriptor, Iterable<? extends ValueArgument>>(){

                @Override
                public Iterable<? extends ValueArgument> invoke(ValueParameterDescriptor descriptor) {
                    ResolvedValueArgument resolvedValueArgument = setResolvedCall.getValueArguments().get(descriptor);
                    return resolvedValueArgument != null ? resolvedValueArgument.getArguments() : Collections.emptyList();
                }
            });
            ValueArgument rhsArgument = (ValueArgument)KotlinPackage.lastOrNull(valueArguments);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = SmartFMap.emptyMap();
            for (ValueArgument valueArgument : valueArguments) {
                ArgumentMapping argumentMapping = setResolvedCall.getArgumentMapping(valueArgument);
                if (argumentMapping.isError() || !(argumentMapping instanceof ArgumentMatch)) continue;
                ValueParameterDescriptor parameterDescriptor = ((ArgumentMatch)argumentMapping).getValueParameter();
                if (valueArgument != rhsArgument) {
                    argumentValues = this.generateValueArgument(valueArgument, parameterDescriptor, argumentValues);
                    continue;
                }
                PseudoValue rhsValue = rhsDeferredValue.invoke();
                if (rhsValue == null) continue;
                argumentValues = argumentValues.plus(rhsValue, parameterDescriptor);
            }
            return argumentValues;
        }

        private void recordWrite(@NotNull JetExpression left, @NotNull AccessTarget target, @Nullable PseudoValue rightValue, @NotNull Map<PseudoValue, ReceiverValue> receiverValues, @NotNull JetExpression parentExpression) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "recordWrite"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "recordWrite"));
            }
            if (receiverValues == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValues", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "recordWrite"));
            }
            if (parentExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentExpression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "recordWrite"));
            }
            VariableDescriptor descriptor = BindingContextUtils.extractVariableDescriptorIfAny(JetControlFlowProcessor.this.trace.getBindingContext(), left, false);
            if (descriptor != null) {
                PseudoValue rValue = rightValue != null ? rightValue : this.createSyntheticValue(parentExpression, new JetElement[0]);
                this.builder.write(parentExpression, left, rValue, target, receiverValues);
            }
        }

        private void generateArrayAccess(JetArrayAccessExpression arrayAccessExpression, @Nullable ResolvedCall<?> resolvedCall) {
            this.mark(arrayAccessExpression);
            if (!this.checkAndGenerateCall(arrayAccessExpression, arrayAccessExpression, resolvedCall)) {
                this.generateArrayAccessWithoutCall(arrayAccessExpression);
            }
        }

        private void generateArrayAccessWithoutCall(JetArrayAccessExpression arrayAccessExpression) {
            this.createNonSyntheticValue((JetElement)arrayAccessExpression, this.generateArrayAccessArguments(arrayAccessExpression));
        }

        private List<JetExpression> generateArrayAccessArguments(JetArrayAccessExpression arrayAccessExpression) {
            ArrayList<JetExpression> inputExpressions = new ArrayList<JetExpression>();
            JetExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            inputExpressions.add(arrayExpression);
            this.generateInstructions(arrayExpression, CFPContext.NOT_IN_CONDITION);
            for (JetExpression index : arrayAccessExpression.getIndexExpressions()) {
                this.generateInstructions(index, CFPContext.NOT_IN_CONDITION);
                inputExpressions.add(index);
            }
            return inputExpressions;
        }

        @Override
        public void visitUnaryExpressionVoid(@NotNull JetUnaryExpression expression, CFPContext context) {
            PseudoValue rhsValue;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitUnaryExpressionVoid"));
            }
            this.mark(expression);
            JetSimpleNameExpression operationSign = expression.getOperationReference();
            IElementType operationType = operationSign.getReferencedNameElementType();
            JetExpression baseExpression = expression.getBaseExpression();
            if (baseExpression == null) {
                return;
            }
            if (JetTokens.EXCLEXCL == operationType) {
                this.generateInstructions(baseExpression, CFPContext.NOT_IN_CONDITION);
                this.builder.predefinedOperation(expression, JetControlFlowBuilder.PredefinedOperation.NOT_NULL_ASSERTION, this.elementsToValues(Collections.singletonList(baseExpression)));
                return;
            }
            boolean incrementOrDecrement = this.isIncrementOrDecrement(operationType);
            ResolvedCall<?> resolvedCall = this.getResolvedCall(operationSign);
            if (resolvedCall != null) {
                rhsValue = this.generateCall(incrementOrDecrement ? null : expression, operationSign, resolvedCall).getOutputValue();
            } else {
                this.generateInstructions(baseExpression, CFPContext.NOT_IN_CONDITION);
                rhsValue = this.createNonSyntheticValue((JetElement)expression, baseExpression);
            }
            if (incrementOrDecrement) {
                this.visitAssignment(baseExpression, this.getValueAsFunction(rhsValue), expression);
            }
        }

        private boolean isIncrementOrDecrement(IElementType operationType) {
            return operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS;
        }

        @Override
        public void visitIfExpressionVoid(@NotNull JetIfExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitIfExpressionVoid"));
            }
            this.mark(expression);
            ArrayList<JetExpression> branches = new ArrayList<JetExpression>(2);
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition, CFPContext.IN_CONDITION);
            }
            Label elseLabel = this.builder.createUnboundLabel();
            this.builder.jumpOnFalse(elseLabel, expression, this.builder.getBoundValue(condition));
            JetExpression thenBranch = expression.getThen();
            if (thenBranch != null) {
                branches.add(thenBranch);
                this.generateInstructions(thenBranch, context);
            } else {
                this.builder.loadUnit(expression);
            }
            Label resultLabel = this.builder.createUnboundLabel();
            this.builder.jump(resultLabel, expression);
            this.builder.bindLabel(elseLabel);
            JetExpression elseBranch = expression.getElse();
            if (elseBranch != null) {
                branches.add(elseBranch);
                this.generateInstructions(elseBranch, context);
            } else {
                this.builder.loadUnit(expression);
            }
            this.builder.bindLabel(resultLabel);
            this.mergeValues(branches, expression);
        }

        @Override
        public void visitTryExpressionVoid(@NotNull JetTryExpression expression, CFPContext context) {
            boolean hasFinally;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitTryExpressionVoid"));
            }
            this.mark(expression);
            JetFinallySection finallyBlock = expression.getFinallyBlock();
            final FinallyBlockGenerator finallyBlockGenerator = new FinallyBlockGenerator(finallyBlock, context);
            boolean bl = hasFinally = finallyBlock != null;
            if (hasFinally) {
                this.builder.enterTryFinally(new GenerationTrigger(){
                    private boolean working = false;

                    @Override
                    public void generate() {
                        if (this.working) {
                            return;
                        }
                        this.working = true;
                        finallyBlockGenerator.generate();
                        this.working = false;
                    }
                });
            }
            Label onExceptionToFinallyBlock = this.generateTryAndCatches(expression, context);
            if (hasFinally) {
                assert (onExceptionToFinallyBlock != null) : "No finally lable generated: " + expression.getText();
                this.builder.exitTryFinally();
                Label skipFinallyToErrorBlock = this.builder.createUnboundLabel("skipFinallyToErrorBlock");
                this.builder.jump(skipFinallyToErrorBlock, expression);
                this.builder.bindLabel(onExceptionToFinallyBlock);
                finallyBlockGenerator.generate();
                this.builder.jumpToError(expression);
                this.builder.bindLabel(skipFinallyToErrorBlock);
                finallyBlockGenerator.generate();
            }
            ArrayList<JetExpression> branches = new ArrayList<JetExpression>();
            branches.add(expression.getTryBlock());
            for (JetCatchClause catchClause : expression.getCatchClauses()) {
                branches.add(catchClause.getCatchBody());
            }
            this.mergeValues(branches, expression);
        }

        @Nullable
        private Label generateTryAndCatches(@NotNull JetTryExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateTryAndCatches"));
            }
            List<JetCatchClause> catchClauses = expression.getCatchClauses();
            boolean hasCatches = !catchClauses.isEmpty();
            Label onException = null;
            if (hasCatches) {
                onException = this.builder.createUnboundLabel("onException");
                this.builder.nondeterministicJump(onException, expression, null);
            }
            Label onExceptionToFinallyBlock = null;
            if (expression.getFinallyBlock() != null) {
                onExceptionToFinallyBlock = this.builder.createUnboundLabel("onExceptionToFinallyBlock");
                this.builder.nondeterministicJump(onExceptionToFinallyBlock, expression, null);
            }
            JetBlockExpression tryBlock = expression.getTryBlock();
            this.generateInstructions(tryBlock, context);
            if (hasCatches) {
                Label afterCatches = this.builder.createUnboundLabel("afterCatches");
                this.builder.jump(afterCatches, expression);
                this.builder.bindLabel(onException);
                LinkedList<Label> catchLabels = Lists.newLinkedList();
                int catchClausesSize = catchClauses.size();
                for (int i = 0; i < catchClausesSize - 1; ++i) {
                    catchLabels.add(this.builder.createUnboundLabel("catch " + i));
                }
                if (!catchLabels.isEmpty()) {
                    this.builder.nondeterministicJump(catchLabels, expression);
                }
                boolean isFirst = true;
                for (JetCatchClause catchClause : catchClauses) {
                    JetExpression catchBody;
                    this.builder.enterLexicalScope(catchClause);
                    if (!isFirst) {
                        this.builder.bindLabel(catchLabels.remove());
                    } else {
                        isFirst = false;
                    }
                    JetParameter catchParameter = catchClause.getCatchParameter();
                    if (catchParameter != null) {
                        this.builder.declareParameter(catchParameter);
                        this.generateInitializer(catchParameter, this.createSyntheticValue(catchParameter, new JetElement[0]));
                    }
                    if ((catchBody = catchClause.getCatchBody()) != null) {
                        this.generateInstructions(catchBody, CFPContext.NOT_IN_CONDITION);
                    }
                    this.builder.jump(afterCatches, expression);
                    this.builder.exitLexicalScope(catchClause);
                }
                this.builder.bindLabel(afterCatches);
            }
            return onExceptionToFinallyBlock;
        }

        @Override
        public void visitWhileExpressionVoid(@NotNull JetWhileExpression expression, CFPContext context) {
            boolean conditionIsTrueConstant;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitWhileExpressionVoid"));
            }
            this.mark(expression);
            LoopInfo loopInfo = this.builder.enterLoop(expression, null, null);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition, CFPContext.IN_CONDITION);
            }
            if (!(conditionIsTrueConstant = CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition, JetControlFlowProcessor.this.trace, true))) {
                this.builder.jumpOnFalse(loopInfo.getExitPoint(), expression, this.builder.getBoundValue(condition));
            }
            this.builder.bindLabel(loopInfo.getBodyEntryPoint());
            JetExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body, CFPContext.NOT_IN_CONDITION);
            }
            this.builder.jump(loopInfo.getEntryPoint(), expression);
            this.builder.exitLoop(expression);
            this.builder.loadUnit(expression);
        }

        @Override
        public void visitDoWhileExpressionVoid(@NotNull JetDoWhileExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDoWhileExpressionVoid"));
            }
            this.builder.enterLexicalScope(expression);
            this.mark(expression);
            LoopInfo loopInfo = this.builder.enterLoop(expression, null, null);
            this.builder.bindLabel(loopInfo.getBodyEntryPoint());
            JetExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body, CFPContext.NOT_IN_CONDITION);
            }
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            JetExpression condition = expression.getCondition();
            if (condition != null) {
                this.generateInstructions(condition, CFPContext.IN_CONDITION);
            }
            this.builder.jumpOnTrue(loopInfo.getEntryPoint(), expression, this.builder.getBoundValue(condition));
            this.builder.exitLoop(expression);
            this.builder.loadUnit(expression);
            this.builder.exitLexicalScope(expression);
        }

        @Override
        public void visitForExpressionVoid(@NotNull JetForExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitForExpressionVoid"));
            }
            this.builder.enterLexicalScope(expression);
            this.mark(expression);
            JetExpression loopRange = expression.getLoopRange();
            if (loopRange != null) {
                this.generateInstructions(loopRange, CFPContext.NOT_IN_CONDITION);
            }
            this.declareLoopParameter(expression);
            Label loopExitPoint = this.builder.createUnboundLabel();
            Label conditionEntryPoint = this.builder.createUnboundLabel();
            this.builder.bindLabel(conditionEntryPoint);
            this.builder.nondeterministicJump(loopExitPoint, expression, null);
            LoopInfo loopInfo = this.builder.enterLoop(expression, loopExitPoint, conditionEntryPoint);
            this.builder.bindLabel(loopInfo.getBodyEntryPoint());
            this.writeLoopParameterAssignment(expression);
            JetExpression body = expression.getBody();
            if (body != null) {
                this.generateInstructions(body, CFPContext.NOT_IN_CONDITION);
            }
            this.builder.nondeterministicJump(loopInfo.getEntryPoint(), expression, null);
            this.builder.exitLoop(expression);
            this.builder.loadUnit(expression);
            this.builder.exitLexicalScope(expression);
        }

        private void declareLoopParameter(JetForExpression expression) {
            JetParameter loopParameter = expression.getLoopParameter();
            JetMultiDeclaration multiDeclaration = expression.getMultiParameter();
            if (loopParameter != null) {
                this.builder.declareParameter(loopParameter);
            } else if (multiDeclaration != null) {
                this.visitMultiDeclaration(multiDeclaration, false);
            }
        }

        private void writeLoopParameterAssignment(JetForExpression expression) {
            JetParameter loopParameter = expression.getLoopParameter();
            JetMultiDeclaration multiDeclaration = expression.getMultiParameter();
            JetExpression loopRange = expression.getLoopRange();
            JetType loopRangeType = JetControlFlowProcessor.this.trace.get(BindingContext.EXPRESSION_TYPE, loopRange);
            TypePredicate loopRangeTypeSet = loopRangeType != null ? new SingleType(loopRangeType) : AllTypes.instance$;
            PseudoValue loopRangeValue = this.builder.getBoundValue(loopRange);
            PseudoValue value = this.builder.magic(loopRange != null ? loopRange : expression, null, Collections.singletonList(loopRangeValue), Collections.singletonMap(loopRangeValue, loopRangeTypeSet), true).getOutputValue();
            if (loopParameter != null) {
                this.generateInitializer(loopParameter, value);
            } else if (multiDeclaration != null) {
                for (JetMultiDeclarationEntry entry : multiDeclaration.getEntries()) {
                    this.generateInitializer(entry, value);
                }
            }
        }

        @Override
        public void visitBreakExpressionVoid(@NotNull JetBreakExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBreakExpressionVoid"));
            }
            JetElement loop = this.getCorrespondingLoop(expression);
            if (loop != null) {
                this.checkJumpDoesNotCrossFunctionBoundary(expression, loop);
                this.builder.jump(this.builder.getExitPoint(loop), expression);
            }
        }

        @Override
        public void visitContinueExpressionVoid(@NotNull JetContinueExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitContinueExpressionVoid"));
            }
            JetElement loop = this.getCorrespondingLoop(expression);
            if (loop != null) {
                this.checkJumpDoesNotCrossFunctionBoundary(expression, loop);
                this.builder.jump(this.builder.getEntryPoint(loop), expression);
            }
        }

        private JetElement getCorrespondingLoop(JetExpressionWithLabel expression) {
            JetElement loop;
            String labelName = expression.getLabelName();
            if (labelName != null) {
                JetSimpleNameExpression targetLabel = expression.getTargetLabel();
                assert (targetLabel != null);
                PsiElement labeledElement = JetControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
                if (labeledElement instanceof JetLoopExpression) {
                    loop = (JetLoopExpression)labeledElement;
                } else {
                    JetControlFlowProcessor.this.trace.report(Errors.NOT_A_LOOP_LABEL.on(expression, targetLabel.getText()));
                    loop = null;
                }
            } else {
                loop = this.builder.getCurrentLoop();
                if (loop == null) {
                    JetControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on(expression));
                }
            }
            return loop;
        }

        private void checkJumpDoesNotCrossFunctionBoundary(@NotNull JetExpressionWithLabel jumpExpression, @NotNull JetElement jumpTarget) {
            FunctionDescriptor labelTargetEnclosingFunc;
            if (jumpExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jumpExpression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "checkJumpDoesNotCrossFunctionBoundary"));
            }
            if (jumpTarget == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jumpTarget", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "checkJumpDoesNotCrossFunctionBoundary"));
            }
            BindingContext bindingContext = JetControlFlowProcessor.this.trace.getBindingContext();
            FunctionDescriptor labelExprEnclosingFunc = BindingContextUtils.getEnclosingFunctionDescriptor(bindingContext, jumpExpression);
            if (labelExprEnclosingFunc != (labelTargetEnclosingFunc = BindingContextUtils.getEnclosingFunctionDescriptor(bindingContext, jumpTarget))) {
                JetControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY.on(jumpExpression));
            }
        }

        @Override
        public void visitReturnExpressionVoid(@NotNull JetReturnExpression expression, CFPContext context) {
            JetElement subroutine;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitReturnExpressionVoid"));
            }
            JetExpression returnedExpression = expression.getReturnedExpression();
            if (returnedExpression != null) {
                this.generateInstructions(returnedExpression, CFPContext.NOT_IN_CONDITION);
            }
            JetSimpleNameExpression labelElement = expression.getTargetLabel();
            String labelName = expression.getLabelName();
            if (labelElement != null && labelName != null) {
                PsiElement labeledElement = JetControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, labelElement);
                if (labeledElement != null) {
                    assert (labeledElement instanceof JetElement);
                    subroutine = (JetElement)labeledElement;
                } else {
                    subroutine = null;
                }
            } else {
                subroutine = this.builder.getReturnSubroutine();
            }
            if (subroutine instanceof JetFunction || subroutine instanceof JetPropertyAccessor) {
                PseudoValue returnValue;
                PseudoValue pseudoValue = returnValue = returnedExpression != null ? this.builder.getBoundValue(returnedExpression) : null;
                if (returnValue == null) {
                    this.builder.returnNoValue(expression, subroutine);
                } else {
                    this.builder.returnValue(expression, returnValue, subroutine);
                }
            }
        }

        @Override
        public void visitParameterVoid(@NotNull JetParameter parameter, CFPContext context) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitParameterVoid"));
            }
            this.builder.declareParameter(parameter);
            JetExpression defaultValue = parameter.getDefaultValue();
            if (defaultValue != null) {
                this.generateInstructions(defaultValue, context);
            }
            this.generateInitializer(parameter, this.createSyntheticValue(parameter, new JetElement[0]));
        }

        @Override
        public void visitBlockExpressionVoid(@NotNull JetBlockExpression expression, CFPContext context) {
            boolean declareLexicalScope;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBlockExpressionVoid"));
            }
            boolean bl = declareLexicalScope = !this.isBlockInDoWhile(expression);
            if (declareLexicalScope) {
                this.builder.enterLexicalScope(expression);
            }
            this.mark(expression);
            List<JetElement> statements = expression.getStatements();
            for (JetElement statement : statements) {
                this.generateInstructions(statement, CFPContext.NOT_IN_CONDITION);
            }
            if (statements.isEmpty()) {
                this.builder.loadUnit(expression);
            } else {
                this.copyValue(KotlinPackage.lastOrNull(statements), expression);
            }
            if (declareLexicalScope) {
                this.builder.exitLexicalScope(expression);
            }
        }

        private boolean isBlockInDoWhile(@NotNull JetBlockExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "isBlockInDoWhile"));
            }
            PsiElement parent = expression.getParent();
            if (parent == null) {
                return false;
            }
            return parent.getParent() instanceof JetDoWhileExpression;
        }

        @Override
        public void visitNamedFunctionVoid(@NotNull JetNamedFunction function, CFPContext context) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitNamedFunctionVoid"));
            }
            JetControlFlowProcessor.this.processLocalDeclaration(function);
        }

        @Override
        public void visitFunctionLiteralExpressionVoid(@NotNull JetFunctionLiteralExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitFunctionLiteralExpressionVoid"));
            }
            this.mark(expression);
            JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
            JetControlFlowProcessor.this.processLocalDeclaration(functionLiteral);
            this.builder.createFunctionLiteral(expression);
        }

        @Override
        public void visitQualifiedExpressionVoid(@NotNull JetQualifiedExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitQualifiedExpressionVoid"));
            }
            this.mark(expression);
            JetExpression selectorExpression = expression.getSelectorExpression();
            JetExpression receiverExpression = expression.getReceiverExpression();
            if (selectorExpression instanceof JetCallExpression || selectorExpression instanceof JetSimpleNameExpression) {
                this.generateInstructions(selectorExpression, CFPContext.NOT_IN_CONDITION);
                this.copyValue(selectorExpression, expression);
            } else {
                this.generateInstructions(receiverExpression, CFPContext.NOT_IN_CONDITION);
                this.createNonSyntheticValue((JetElement)expression, receiverExpression);
            }
        }

        @Override
        public void visitCallExpressionVoid(@NotNull JetCallExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitCallExpressionVoid"));
            }
            this.mark(expression);
            JetExpression calleeExpression = expression.getCalleeExpression();
            if (!this.generateCall(expression, calleeExpression)) {
                ArrayList<JetExpression> inputExpressions = new ArrayList<JetExpression>();
                for (ValueArgument valueArgument : expression.getValueArguments()) {
                    JetExpression argumentExpression = valueArgument.getArgumentExpression();
                    if (argumentExpression == null) continue;
                    this.generateInstructions(argumentExpression, CFPContext.NOT_IN_CONDITION);
                    inputExpressions.add(argumentExpression);
                }
                for (JetExpression jetExpression : expression.getFunctionLiteralArguments()) {
                    this.generateInstructions(jetExpression, CFPContext.NOT_IN_CONDITION);
                    inputExpressions.add(jetExpression);
                }
                this.generateInstructions(calleeExpression, CFPContext.NOT_IN_CONDITION);
                inputExpressions.add(calleeExpression);
                inputExpressions.add(this.generateAndGetReceiverIfAny(expression));
                this.createNonSyntheticValue((JetElement)expression, inputExpressions);
            }
        }

        @Nullable
        private JetExpression generateAndGetReceiverIfAny(JetExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof JetQualifiedExpression)) {
                return null;
            }
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)parent;
            if (qualifiedExpression.getSelectorExpression() != expression) {
                return null;
            }
            JetExpression receiverExpression = qualifiedExpression.getReceiverExpression();
            this.generateInstructions(receiverExpression, CFPContext.NOT_IN_CONDITION);
            return receiverExpression;
        }

        @Override
        public void visitPropertyVoid(@NotNull JetProperty property2, CFPContext context) {
            JetExpression delegate;
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitPropertyVoid"));
            }
            this.builder.declareVariable(property2);
            JetExpression initializer = property2.getInitializer();
            if (initializer != null) {
                this.visitAssignment(property2, this.getDeferredValue(initializer), property2);
            }
            if ((delegate = property2.getDelegateExpression()) != null) {
                this.generateInstructions(delegate, CFPContext.NOT_IN_CONDITION);
            }
            if (JetPsiUtil.isLocal(property2)) {
                for (JetPropertyAccessor accessor : property2.getAccessors()) {
                    this.generateInstructions(accessor, CFPContext.NOT_IN_CONDITION);
                }
            }
        }

        @Override
        public void visitMultiDeclarationVoid(@NotNull JetMultiDeclaration declaration, CFPContext context) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitMultiDeclarationVoid"));
            }
            this.visitMultiDeclaration(declaration, true);
        }

        @Override
        private void visitMultiDeclaration(@NotNull JetMultiDeclaration declaration, boolean generateWriteForEntries) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitMultiDeclaration"));
            }
            JetExpression initializer = declaration.getInitializer();
            this.generateInstructions(initializer, CFPContext.NOT_IN_CONDITION);
            for (JetMultiDeclarationEntry entry : declaration.getEntries()) {
                this.builder.declareVariable(entry);
                ResolvedCall<FunctionDescriptor> resolvedCall = JetControlFlowProcessor.this.trace.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                PseudoValue writtenValue = resolvedCall != null ? this.builder.call(entry, entry, resolvedCall, this.getReceiverValues(initializer, resolvedCall, false), Collections.<PseudoValue, ValueParameterDescriptor>emptyMap()).getOutputValue() : this.createSyntheticValue(entry, initializer);
                if (!generateWriteForEntries) continue;
                this.generateInitializer(entry, writtenValue != null ? writtenValue : this.createSyntheticValue(entry, new JetElement[0]));
            }
        }

        @Override
        public void visitPropertyAccessorVoid(@NotNull JetPropertyAccessor accessor, CFPContext context) {
            if (accessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitPropertyAccessorVoid"));
            }
            JetControlFlowProcessor.this.processLocalDeclaration(accessor);
        }

        @Override
        public void visitBinaryWithTypeRHSExpressionVoid(@NotNull JetBinaryExpressionWithTypeRHS expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitBinaryWithTypeRHSExpressionVoid"));
            }
            this.mark(expression);
            IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
            JetExpression left = expression.getLeft();
            if (operationType == JetTokens.COLON || operationType == JetTokens.AS_KEYWORD || operationType == JetTokens.AS_SAFE) {
                this.generateInstructions(left, CFPContext.NOT_IN_CONDITION);
                this.copyValue(left, expression);
            } else {
                this.visitJetElementVoid((JetElement)expression, context);
                this.createNonSyntheticValue((JetElement)expression, left);
            }
        }

        @Override
        public void visitThrowExpressionVoid(@NotNull JetThrowExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitThrowExpressionVoid"));
            }
            this.mark(expression);
            JetExpression thrownExpression = expression.getThrownExpression();
            if (thrownExpression == null) {
                return;
            }
            this.generateInstructions(thrownExpression, CFPContext.NOT_IN_CONDITION);
            PseudoValue thrownValue = this.builder.getBoundValue(thrownExpression);
            if (thrownValue == null) {
                return;
            }
            this.builder.throwException(expression, thrownValue);
        }

        @Override
        public void visitArrayAccessExpressionVoid(@NotNull JetArrayAccessExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitArrayAccessExpressionVoid"));
            }
            this.mark(expression);
            ResolvedCall<FunctionDescriptor> getMethodResolvedCall = JetControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_GET, expression);
            if (!this.checkAndGenerateCall(expression, expression, getMethodResolvedCall)) {
                this.generateArrayAccess(expression, getMethodResolvedCall);
            }
        }

        @Override
        public void visitIsExpressionVoid(@NotNull JetIsExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitIsExpressionVoid"));
            }
            this.mark(expression);
            JetExpression left = expression.getLeftHandSide();
            this.generateInstructions(left, context);
            this.createNonSyntheticValue((JetElement)expression, left);
        }

        @Override
        public void visitWhenExpressionVoid(@NotNull JetWhenExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitWhenExpressionVoid"));
            }
            this.mark(expression);
            JetExpression subjectExpression = expression.getSubjectExpression();
            if (subjectExpression != null) {
                this.generateInstructions(subjectExpression, context);
            }
            boolean hasElse = false;
            ArrayList<JetExpression> branches = new ArrayList<JetExpression>();
            Label doneLabel = this.builder.createUnboundLabel();
            Label nextLabel = null;
            Iterator<JetWhenEntry> iterator2 = expression.getEntries().iterator();
            while (iterator2.hasNext()) {
                JetWhenEntry whenEntry = iterator2.next();
                this.mark(whenEntry);
                boolean isElse = whenEntry.isElse();
                if (isElse) {
                    hasElse = true;
                    if (iterator2.hasNext()) {
                        JetControlFlowProcessor.this.trace.report(Errors.ELSE_MISPLACED_IN_WHEN.on(whenEntry));
                    }
                }
                Label bodyLabel = this.builder.createUnboundLabel();
                JetWhenCondition[] conditions = whenEntry.getConditions();
                for (int i = 0; i < conditions.length; ++i) {
                    JetWhenCondition condition = conditions[i];
                    condition.accept(this.conditionVisitor, context);
                    if (i + 1 >= conditions.length) continue;
                    PseudoValue conditionValue = this.createSyntheticValue(condition, subjectExpression, condition);
                    this.builder.nondeterministicJump(bodyLabel, expression, conditionValue);
                }
                if (!isElse) {
                    nextLabel = this.builder.createUnboundLabel();
                    PseudoValue conditionValue = null;
                    JetWhenCondition lastCondition = KotlinPackage.lastOrNull(conditions);
                    if (lastCondition != null) {
                        conditionValue = this.createSyntheticValue(lastCondition, subjectExpression, lastCondition);
                    }
                    this.builder.nondeterministicJump(nextLabel, expression, conditionValue);
                }
                this.builder.bindLabel(bodyLabel);
                JetExpression whenEntryExpression = whenEntry.getExpression();
                if (whenEntryExpression != null) {
                    this.generateInstructions(whenEntryExpression, context);
                    branches.add(whenEntryExpression);
                }
                this.builder.jump(doneLabel, expression);
                if (isElse) continue;
                this.builder.bindLabel(nextLabel);
            }
            this.builder.bindLabel(doneLabel);
            if (!hasElse && WhenChecker.mustHaveElse(expression, JetControlFlowProcessor.this.trace)) {
                JetControlFlowProcessor.this.trace.report(Errors.NO_ELSE_IN_WHEN.on(expression));
            }
            this.mergeValues(branches, expression);
        }

        @Override
        public void visitObjectLiteralExpressionVoid(@NotNull JetObjectLiteralExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitObjectLiteralExpressionVoid"));
            }
            this.mark(expression);
            JetObjectDeclaration declaration = expression.getObjectDeclaration();
            this.generateInstructions(declaration, context);
            this.builder.createAnonymousObject(expression);
        }

        @Override
        public void visitObjectDeclarationVoid(@NotNull JetObjectDeclaration objectDeclaration, CFPContext context) {
            if (objectDeclaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDeclaration", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitObjectDeclarationVoid"));
            }
            this.visitClassOrObject(objectDeclaration, context);
        }

        @Override
        public void visitStringTemplateExpressionVoid(@NotNull JetStringTemplateExpression expression, CFPContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitStringTemplateExpressionVoid"));
            }
            this.mark(expression);
            ArrayList<JetExpression> inputExpressions = new ArrayList<JetExpression>();
            for (JetStringTemplateEntry entry : expression.getEntries()) {
                if (!(entry instanceof JetStringTemplateEntryWithExpression)) continue;
                JetExpression entryExpression = entry.getExpression();
                this.generateInstructions(entryExpression, CFPContext.NOT_IN_CONDITION);
                inputExpressions.add(entryExpression);
            }
            this.builder.loadStringTemplate(expression, this.elementsToValues(inputExpressions));
        }

        @Override
        public void visitTypeProjectionVoid(@NotNull JetTypeProjection typeProjection, CFPContext context) {
            if (typeProjection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitTypeProjectionVoid"));
            }
        }

        @Override
        public void visitAnonymousInitializerVoid(@NotNull JetClassInitializer classInitializer, CFPContext context) {
            if (classInitializer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classInitializer", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitAnonymousInitializerVoid"));
            }
            this.generateInstructions(classInitializer.getBody(), context);
        }

        private void visitClassOrObject(JetClassOrObject classOrObject, CFPContext context) {
            for (JetDelegationSpecifier specifier : classOrObject.getDelegationSpecifiers()) {
                this.generateInstructions(specifier, context);
            }
            List<JetDeclaration> declarations = classOrObject.getDeclarations();
            if (classOrObject.isLocal()) {
                for (JetDeclaration declaration : declarations) {
                    this.generateInstructions(declaration, context);
                }
                return;
            }
            for (JetDeclaration declaration : declarations) {
                if (!(declaration instanceof JetProperty) && !(declaration instanceof JetClassInitializer)) continue;
                this.generateInstructions(declaration, context);
            }
        }

        @Override
        public void visitClassVoid(@NotNull JetClass klass, CFPContext context) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitClassVoid"));
            }
            List<JetParameter> parameters = klass.getPrimaryConstructorParameters();
            for (JetParameter parameter : parameters) {
                this.generateInstructions(parameter, context);
            }
            this.visitClassOrObject(klass, context);
        }

        @Override
        public void visitDelegationToSuperCallSpecifierVoid(@NotNull JetDelegatorToSuperCall call, CFPContext context) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationToSuperCallSpecifierVoid"));
            }
            List<? extends ValueArgument> valueArguments = call.getValueArguments();
            for (ValueArgument valueArgument : valueArguments) {
                this.generateInstructions(valueArgument.getArgumentExpression(), context);
            }
        }

        @Override
        public void visitDelegationByExpressionSpecifierVoid(@NotNull JetDelegatorByExpressionSpecifier specifier, CFPContext context) {
            if (specifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationByExpressionSpecifierVoid"));
            }
            this.generateInstructions(specifier.getDelegateExpression(), context);
        }

        @Override
        public void visitJetFileVoid(@NotNull JetFile file, CFPContext context) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitJetFileVoid"));
            }
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetProperty)) continue;
                this.generateInstructions(declaration, context);
            }
        }

        @Override
        public void visitJetElementVoid(@NotNull JetElement element, CFPContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "visitJetElementVoid"));
            }
            this.builder.unsupported(element);
        }

        @Nullable
        private ResolvedCall<?> getResolvedCall(@NotNull JetElement expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "getResolvedCall"));
            }
            return JetControlFlowProcessor.this.trace.get(BindingContext.RESOLVED_CALL, expression);
        }

        private boolean generateCall(JetExpression callExpression, @Nullable JetExpression calleeExpression) {
            if (calleeExpression == null) {
                return false;
            }
            return this.checkAndGenerateCall(callExpression, calleeExpression, this.getResolvedCall(calleeExpression));
        }

        private boolean checkAndGenerateCall(JetExpression callExpression, JetExpression calleeExpression, @Nullable ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                this.builder.compilationError(calleeExpression, "No resolved call");
                return false;
            }
            this.generateCall(callExpression, calleeExpression, resolvedCall);
            return true;
        }

        @NotNull
        private InstructionWithValue generateCall(JetExpression callExpression, JetExpression calleeExpression, ResolvedCall<?> resolvedCall) {
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)((Object)resolvedCall);
                InstructionWithValue instructionWithValue = this.generateCall(callExpression, calleeExpression, variableAsFunctionResolvedCall.getFunctionCall());
                if (instructionWithValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateCall"));
                }
                return instructionWithValue;
            }
            Object resultingDescriptor = resolvedCall.getResultingDescriptor();
            Map<PseudoValue, ReceiverValue> receivers = this.getReceiverValues(callExpression, resolvedCall, true);
            SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues = SmartFMap.emptyMap();
            for (ValueParameterDescriptor parameterDescriptor : resultingDescriptor.getValueParameters()) {
                ResolvedValueArgument argument = resolvedCall.getValueArguments().get(parameterDescriptor);
                if (argument == null) continue;
                parameterValues = this.generateValueArgument(argument, parameterDescriptor, parameterValues);
            }
            if (resultingDescriptor instanceof VariableDescriptor) {
                assert (parameterValues.isEmpty()) : "Variable-based call with non-empty argument list: " + resolvedCall.getCall().getCallElement().getText();
                ReadValueInstruction readValueInstruction = this.builder.readVariable(calleeExpression, callExpression, resolvedCall, receivers);
                if (readValueInstruction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateCall"));
                }
                return readValueInstruction;
            }
            CallInstruction callInstruction = this.builder.call(calleeExpression, callExpression, resolvedCall, receivers, parameterValues);
            if (callInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateCall"));
            }
            return callInstruction;
        }

        @NotNull
        private Map<PseudoValue, ReceiverValue> getReceiverValues(JetExpression callExpression, ResolvedCall<?> resolvedCall, boolean generateInstructions) {
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = SmartFMap.emptyMap();
            receiverValues = this.getReceiverValues(callExpression, resolvedCall.getThisObject(), generateInstructions, receiverValues);
            SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues = this.getReceiverValues(callExpression, resolvedCall.getReceiverArgument(), generateInstructions, receiverValues);
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "getReceiverValues"));
            }
            return smartFMap;
        }

        @NotNull
        private SmartFMap<PseudoValue, ReceiverValue> getReceiverValues(JetExpression callExpression, ReceiverValue receiver, boolean generateInstructions, SmartFMap<PseudoValue, ReceiverValue> receiverValues) {
            if (!receiver.exists()) {
                SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues;
                if (smartFMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "getReceiverValues"));
                }
                return smartFMap;
            }
            if (receiver instanceof ThisReceiver) {
                if (generateInstructions) {
                    receiverValues = receiverValues.plus(this.createSyntheticValue(callExpression, new JetElement[0]), receiver);
                }
            } else if (receiver instanceof ExpressionReceiver) {
                PseudoValue receiverPseudoValue;
                JetExpression expression = ((ExpressionReceiver)receiver).getExpression();
                if (generateInstructions) {
                    this.generateInstructions(expression, CFPContext.NOT_IN_CONDITION);
                }
                if ((receiverPseudoValue = this.builder.getBoundValue(expression)) != null) {
                    receiverValues = receiverValues.plus(receiverPseudoValue, receiver);
                }
            } else if (!(receiver instanceof TransientReceiver)) {
                throw new IllegalArgumentException("Unknown receiver kind: " + receiver);
            }
            SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues;
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "getReceiverValues"));
            }
            return smartFMap;
        }

        @NotNull
        private SmartFMap<PseudoValue, ValueParameterDescriptor> generateValueArgument(ResolvedValueArgument argument, ValueParameterDescriptor parameterDescriptor, SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues) {
            for (ValueArgument valueArgument : argument.getArguments()) {
                parameterValues = this.generateValueArgument(valueArgument, parameterDescriptor, parameterValues);
            }
            SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = parameterValues;
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateValueArgument"));
            }
            return smartFMap;
        }

        @NotNull
        private SmartFMap<PseudoValue, ValueParameterDescriptor> generateValueArgument(ValueArgument valueArgument, ValueParameterDescriptor parameterDescriptor, SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues) {
            JetExpression expression = valueArgument.getArgumentExpression();
            if (expression != null) {
                this.generateInstructions(expression, CFPContext.NOT_IN_CONDITION);
                PseudoValue argValue = this.builder.getBoundValue(expression);
                if (argValue != null) {
                    parameterValues = parameterValues.plus(argValue, parameterDescriptor);
                }
            }
            SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = parameterValues;
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowProcessor$CFPVisitor", "generateValueArgument"));
            }
            return smartFMap;
        }

        private class FinallyBlockGenerator {
            private final JetFinallySection finallyBlock;
            private final CFPContext context;
            private Label startFinally = null;
            private Label finishFinally = null;

            private FinallyBlockGenerator(JetFinallySection block, CFPContext context) {
                this.finallyBlock = block;
                this.context = context;
            }

            public void generate() {
                JetBlockExpression finalExpression = this.finallyBlock.getFinalExpression();
                if (finalExpression == null) {
                    return;
                }
                if (this.startFinally != null) {
                    assert (this.finishFinally != null);
                    CFPVisitor.this.builder.repeatPseudocode(this.startFinally, this.finishFinally);
                    return;
                }
                this.startFinally = CFPVisitor.this.builder.createUnboundLabel("start finally");
                CFPVisitor.this.builder.bindLabel(this.startFinally);
                CFPVisitor.this.generateInstructions(finalExpression, this.context);
                this.finishFinally = CFPVisitor.this.builder.createUnboundLabel("finish finally");
                CFPVisitor.this.builder.bindLabel(this.finishFinally);
            }
        }
    }

    static enum CFPContext {
        IN_CONDITION(true),
        NOT_IN_CONDITION(false);

        private final boolean inCondition;

        private CFPContext(boolean inCondition) {
            this.inCondition = inCondition;
        }

        public boolean inCondition() {
            return this.inCondition;
        }
    }
}

