/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import java.util.ListIterator;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class MaxCalcNode
extends MethodVisitor {
    private int maxLocal;
    private final MethodNode node;

    public MaxCalcNode(MethodNode node) {
        super(327680, node);
        Type[] types;
        this.node = node;
        int paramsSize = (node.access & 8) == 0 ? 1 : 0;
        for (Type type : types = Type.getArgumentTypes(node.desc)) {
            paramsSize += type.getSize();
        }
        this.maxLocal = paramsSize;
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        int size = opcode == 22 || opcode == 24 || opcode == 55 || opcode == 57 ? 2 : 1;
        this.updateMaxLocal(var, size);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.updateMaxLocal(var, 1);
    }

    private void updateMaxLocal(int index, int size) {
        this.maxLocal = Math.max(this.maxLocal, index + size);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        int size = 0;
        ListIterator<AbstractInsnNode> iterator2 = this.node.instructions.iterator();
        while (iterator2.hasNext()) {
            AbstractInsnNode next = iterator2.next();
            int type = next.getType();
            if (type == 15 || type == 8) continue;
            ++size;
        }
        super.visitMaxs(Math.max(size * 2, maxStack), Math.max(maxLocals, this.maxLocal));
    }
}

