/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaClassDescriptor;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.types.JetType;

public class SamType {
    private final JetType type;

    public static SamType create(@NotNull JetType originalType) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/jet/codegen/SamType", "create"));
        }
        if (!SingleAbstractMethodUtils.isSamType(originalType)) {
            return null;
        }
        return new SamType(originalType);
    }

    private SamType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/SamType", "<init>"));
        }
        this.type = type;
    }

    @NotNull
    public JetType getType() {
        JetType jetType = this.type;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/SamType", "getType"));
        }
        return jetType;
    }

    @NotNull
    public JavaClassDescriptor getJavaClassDescriptor() {
        ClassifierDescriptor classifier2 = this.type.getConstructor().getDeclarationDescriptor();
        assert (classifier2 instanceof JavaClassDescriptor) : "Sam interface not a Java class: " + classifier2;
        JavaClassDescriptor javaClassDescriptor = (JavaClassDescriptor)classifier2;
        if (javaClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/SamType", "getJavaClassDescriptor"));
        }
        return javaClassDescriptor;
    }

    @NotNull
    public JetType getKotlinFunctionType() {
        JetType jetType = this.getJavaClassDescriptor().getFunctionTypeForSamInterface();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/SamType", "getKotlinFunctionType"));
        }
        return jetType;
    }

    @NotNull
    public SimpleFunctionDescriptor getAbstractMethod() {
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)SingleAbstractMethodUtils.getAbstractMembers(this.type).get(0);
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/SamType", "getAbstractMethod"));
        }
        return simpleFunctionDescriptor;
    }

    public boolean equals(Object o) {
        return o instanceof SamType && ((Object)this.type).equals(((SamType)o).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "SamType(" + this.type + ")";
    }
}

