/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.JvmSerializationBindings;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.context.ClassContext;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.context.PackageContext;
import org.jetbrains.jet.codegen.context.PackageFacadeContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.java.diagnostics.DiagnosticsPackage;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodSignature;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class PropertyCodegen {
    private final GenerationState state;
    private final ClassBuilder v;
    private final FunctionCodegen functionCodegen;
    private final JetTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final FieldOwnerContext context;
    private final MemberCodegen<?> classBodyCodegen;
    private final OwnerKind kind;

    public PropertyCodegen(@NotNull FieldOwnerContext context, @NotNull ClassBuilder v, @NotNull FunctionCodegen functionCodegen, @Nullable MemberCodegen<?> classBodyCodegen) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/PropertyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/PropertyCodegen", "<init>"));
        }
        if (functionCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionCodegen", "org/jetbrains/jet/codegen/PropertyCodegen", "<init>"));
        }
        this.state = functionCodegen.state;
        this.v = v;
        this.functionCodegen = functionCodegen;
        this.typeMapper = this.state.getTypeMapper();
        this.bindingContext = this.state.getBindingContext();
        this.context = context;
        this.classBodyCodegen = classBodyCodegen;
        this.kind = context.getContextKind();
    }

    public void gen(@NotNull JetProperty property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/codegen/PropertyCodegen", "gen"));
        }
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, property2);
        assert (variableDescriptor instanceof PropertyDescriptor) : "Property " + property2.getText() + " should have a property descriptor: " + variableDescriptor;
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
        this.gen(property2, propertyDescriptor, property2.getGetter(), property2.getSetter());
    }

    public void generateInPackageFacade(@NotNull DeserializedPropertyDescriptor deserializedProperty) {
        if (deserializedProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deserializedProperty", "org/jetbrains/jet/codegen/PropertyCodegen", "generateInPackageFacade"));
        }
        assert (this.context instanceof PackageFacadeContext) : "should be called only for generating package facade: " + this.context;
        this.gen(null, deserializedProperty, null, null);
    }

    private void gen(@Nullable JetProperty declaration, @NotNull PropertyDescriptor descriptor, @Nullable JetPropertyAccessor getter, @Nullable JetPropertyAccessor setter) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/PropertyCodegen", "gen"));
        }
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.TRAIT_IMPL) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + descriptor;
        if (this.context instanceof PackageFacadeContext) {
            Type ownerType = ((PackageFacadeContext)this.context).getDelegateToClassType();
            this.v.getSerializationBindings().put(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, descriptor, AsmUtil.shortNameByAsmType(ownerType));
        } else {
            assert (declaration != null) : "Declaration is null for different context: " + this.context;
            if (!this.generateBackingField(declaration, descriptor)) {
                this.generateSyntheticMethodIfNeeded(descriptor);
            }
        }
        this.generateGetter(declaration, descriptor, getter);
        this.generateSetter(declaration, descriptor, setter);
        this.context.recordSyntheticAccessorIfNeeded(descriptor, this.bindingContext);
    }

    public void generatePrimaryConstructorProperty(JetParameter p, PropertyDescriptor descriptor) {
        this.generateBackingField(p, descriptor);
        this.generateGetter(p, descriptor, null);
        if (descriptor.isVar()) {
            this.generateSetter(p, descriptor, null);
        }
    }

    public void generateConstructorPropertyAsMethodForAnnotationClass(JetParameter p, PropertyDescriptor descriptor) {
        Type type = this.typeMapper.mapType(descriptor);
        String name = p.getName();
        assert (name != null) : "Annotation parameter has no name: " + p.getText();
        MethodVisitor visitor = this.v.newMethod(DiagnosticsPackage.OtherOrigin(p, descriptor), 1025, name, "()" + type.getDescriptor(), null, null);
        JetExpression defaultValue = p.getDefaultValue();
        if (defaultValue != null) {
            CompileTimeConstant constant = ExpressionCodegen.getCompileTimeConstant(defaultValue, this.bindingContext);
            assert (constant != null) : "Default value for annotation parameter should be compile time value: " + defaultValue.getText();
            AnnotationCodegen annotationCodegen = AnnotationCodegen.forAnnotationDefaultValue(visitor, this.typeMapper);
            annotationCodegen.generateAnnotationDefaultValue(constant, descriptor.getType());
        }
    }

    private boolean generateBackingField(@NotNull JetNamedDeclaration p, @NotNull PropertyDescriptor descriptor) {
        FieldVisitor fv;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/codegen/PropertyCodegen", "generateBackingField"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/PropertyCodegen", "generateBackingField"));
        }
        if (JvmCodegenUtil.isInterface(descriptor.getContainingDeclaration()) || this.kind == OwnerKind.TRAIT_IMPL) {
            return false;
        }
        if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor))) {
            fv = this.generateBackingFieldAccess(p, descriptor);
        } else if (p instanceof JetProperty && ((JetProperty)p).hasDelegate()) {
            fv = this.generatePropertyDelegateAccess((JetProperty)p, descriptor);
        } else {
            return false;
        }
        AnnotationCodegen.forField(fv, this.typeMapper).genAnnotations(descriptor);
        return true;
    }

    private void generateSyntheticMethodIfNeeded(@NotNull PropertyDescriptor descriptor) {
        String desc;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/PropertyCodegen", "generateSyntheticMethodIfNeeded"));
        }
        if (descriptor.getAnnotations().isEmpty()) {
            return;
        }
        ReceiverParameterDescriptor receiver = descriptor.getReceiverParameter();
        String name = JvmAbi.getSyntheticMethodNameForAnnotatedProperty(descriptor.getName());
        String string = desc = receiver == null ? "()V" : "(" + this.typeMapper.mapType(receiver.getType()) + ")V";
        if (!DescriptorUtils.isTrait(this.context.getContextDescriptor()) || this.kind == OwnerKind.TRAIT_IMPL) {
            int flags = 135194;
            MethodVisitor mv = this.v.newMethod(DiagnosticsPackage.OtherOrigin(descriptor), flags, name, desc, null, null);
            AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(descriptor);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitEnd();
        } else {
            Type tImplType = this.typeMapper.mapTraitImpl((ClassDescriptor)this.context.getContextDescriptor());
            this.v.getSerializationBindings().put(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, descriptor, AsmUtil.shortNameByAsmType(tImplType));
        }
        if (this.kind != OwnerKind.TRAIT_IMPL) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor, new Method(name, desc));
        }
    }

    private FieldVisitor generateBackingField(JetNamedDeclaration element, PropertyDescriptor propertyDescriptor, boolean isDelegate, JetType jetType, Object defaultValue) {
        int modifiers = AsmUtil.getDeprecatedAccessFlag(propertyDescriptor);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.FIELD_FLAGS) {
            if (!flagAnnotation.hasAnnotation(propertyDescriptor.getOriginal())) continue;
            modifiers |= flagAnnotation.getJvmFlag();
        }
        if (this.kind == OwnerKind.PACKAGE) {
            modifiers |= 8;
        }
        if (!propertyDescriptor.isVar() || isDelegate) {
            modifiers |= 0x10;
        }
        Type type = this.typeMapper.mapType(jetType);
        ClassBuilder builder = this.v;
        FieldOwnerContext backingFieldContext = this.context;
        if (AsmUtil.isPropertyWithBackingFieldInOuterClass(propertyDescriptor)) {
            modifiers |= 8 | AsmUtil.getVisibilityForSpecialPropertyBackingField(propertyDescriptor, isDelegate);
            ImplementationBodyCodegen codegen = JvmCodegenUtil.getParentBodyCodegen(this.classBodyCodegen);
            builder = codegen.v;
            backingFieldContext = codegen.context;
            this.v.getSerializationBindings().put(JvmSerializationBindings.STATIC_FIELD_IN_OUTER_CLASS, propertyDescriptor);
        } else if (this.kind != OwnerKind.PACKAGE || isDelegate) {
            modifiers |= 2;
        }
        if (AsmUtil.isPropertyWithBackingFieldCopyInOuterClass(propertyDescriptor)) {
            ImplementationBodyCodegen parentBodyCodegen = JvmCodegenUtil.getParentBodyCodegen(this.classBodyCodegen);
            parentBodyCodegen.addClassObjectPropertyToCopy(propertyDescriptor, defaultValue);
        }
        String name = backingFieldContext.getFieldName(propertyDescriptor, isDelegate);
        this.v.getSerializationBindings().put(JvmSerializationBindings.FIELD_FOR_PROPERTY, propertyDescriptor, Pair.create(type, name));
        return builder.newField(DiagnosticsPackage.OtherOrigin(element, propertyDescriptor), modifiers, name, type.getDescriptor(), this.typeMapper.mapFieldSignature(jetType), defaultValue);
    }

    private FieldVisitor generatePropertyDelegateAccess(JetProperty p, PropertyDescriptor propertyDescriptor) {
        JetType delegateType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, p.getDelegateExpression());
        if (delegateType == null) {
            delegateType = ErrorUtils.createErrorType("Delegate type");
        }
        return this.generateBackingField(p, propertyDescriptor, true, delegateType, null);
    }

    private FieldVisitor generateBackingFieldAccess(JetNamedDeclaration p, PropertyDescriptor propertyDescriptor) {
        CompileTimeConstant<?> initializer;
        Object value = null;
        if (this.shouldWriteFieldInitializer(propertyDescriptor) && (initializer = propertyDescriptor.getCompileTimeInitializer()) != null) {
            value = initializer.getValue();
        }
        return this.generateBackingField(p, propertyDescriptor, false, propertyDescriptor.getType(), value);
    }

    private boolean shouldWriteFieldInitializer(@NotNull PropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/PropertyCodegen", "shouldWriteFieldInitializer"));
        }
        if (!descriptor.isVar()) {
            Type type = this.typeMapper.mapType(descriptor);
            return AsmUtil.isPrimitive(type) || "java.lang.String".equals(type.getClassName());
        }
        return false;
    }

    private void generateGetter(@Nullable JetNamedDeclaration p, @NotNull PropertyDescriptor descriptor, @Nullable JetPropertyAccessor getter) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/PropertyCodegen", "generateGetter"));
        }
        this.generateAccessor(p, getter, descriptor.getGetter() != null ? descriptor.getGetter() : DescriptorFactory.createDefaultGetter(descriptor));
    }

    private void generateSetter(@Nullable JetNamedDeclaration p, @NotNull PropertyDescriptor descriptor, @Nullable JetPropertyAccessor setter) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/PropertyCodegen", "generateSetter"));
        }
        if (!descriptor.isVar()) {
            return;
        }
        this.generateAccessor(p, setter, descriptor.getSetter() != null ? descriptor.getSetter() : DescriptorFactory.createDefaultSetter(descriptor));
    }

    private void generateAccessor(@Nullable JetNamedDeclaration p, @Nullable JetPropertyAccessor accessor, @NotNull PropertyAccessorDescriptor accessorDescriptor) {
        boolean isDefaultAccessor;
        if (accessorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessorDescriptor", "org/jetbrains/jet/codegen/PropertyCodegen", "generateAccessor"));
        }
        boolean bl = isDefaultAccessor = accessor == null || accessor.getBodyExpression() == null;
        if (this.kind == OwnerKind.TRAIT_IMPL && isDefaultAccessor) {
            return;
        }
        FunctionGenerationStrategy.CodegenBased strategy = isDefaultAccessor ? (p instanceof JetProperty && ((JetProperty)p).hasDelegate() ? new DelegatedPropertyAccessorStrategy(this.state, accessorDescriptor, PropertyCodegen.indexOfDelegatedProperty((JetProperty)p)) : new DefaultPropertyAccessorStrategy(this.state, accessorDescriptor)) : new FunctionGenerationStrategy.FunctionDefault(this.state, accessorDescriptor, accessor);
        JvmMethodSignature signature = this.typeMapper.mapSignature(accessorDescriptor, this.kind);
        this.functionCodegen.generateMethod(DiagnosticsPackage.OtherOrigin(accessor != null ? accessor : p, accessorDescriptor), signature, accessorDescriptor, strategy);
    }

    private static int indexOfDelegatedProperty(@NotNull JetProperty property2) {
        JetElement container;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/codegen/PropertyCodegen", "indexOfDelegatedProperty"));
        }
        PsiElement parent = property2.getParent();
        if (parent instanceof JetClassBody) {
            container = (JetClassOrObject)parent.getParent();
        } else if (parent instanceof JetFile) {
            container = (JetFile)parent;
        } else {
            throw new UnsupportedOperationException("Unknown delegated property container: " + parent);
        }
        int index = 0;
        for (JetDeclaration declaration : container.getDeclarations()) {
            if (!(declaration instanceof JetProperty) || !((JetProperty)declaration).hasDelegate()) continue;
            if (declaration == property2) {
                return index;
            }
            ++index;
        }
        throw new IllegalStateException("Delegated property not found in its parent: " + JetPsiUtil.getElementTextWithContext(property2));
    }

    @NotNull
    public static String getterName(Name propertyName) {
        String string = "get" + StringUtil.capitalizeWithJavaBeanConvention(propertyName.asString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PropertyCodegen", "getterName"));
        }
        return string;
    }

    @NotNull
    public static String setterName(Name propertyName) {
        String string = "set" + StringUtil.capitalizeWithJavaBeanConvention(propertyName.asString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PropertyCodegen", "setterName"));
        }
        return string;
    }

    public void genDelegate(@NotNull PropertyDescriptor delegate, @NotNull PropertyDescriptor overridden, @NotNull StackValue field) {
        PropertySetterDescriptor setter;
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jet/codegen/PropertyCodegen", "genDelegate"));
        }
        if (overridden == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overridden", "org/jetbrains/jet/codegen/PropertyCodegen", "genDelegate"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/jet/codegen/PropertyCodegen", "genDelegate"));
        }
        ClassDescriptor toClass = (ClassDescriptor)overridden.getContainingDeclaration();
        PropertyGetterDescriptor getter = delegate.getGetter();
        if (getter != null) {
            this.functionCodegen.genDelegate(getter, toClass, field, this.typeMapper.mapSignature(getter), this.typeMapper.mapSignature(overridden.getGetter().getOriginal()));
        }
        if ((setter = delegate.getSetter()) != null) {
            this.functionCodegen.genDelegate(setter, toClass, field, this.typeMapper.mapSignature(setter), this.typeMapper.mapSignature(overridden.getSetter().getOriginal()));
        }
    }

    private static class DelegatedPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
        private final int index;

        public DelegatedPropertyAccessorStrategy(@NotNull GenerationState state, @NotNull PropertyAccessorDescriptor descriptor, int index) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy", "<init>"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy", "<init>"));
            }
            super(state, descriptor);
            this.index = index;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
            Type owner;
            CodegenContext<ClassOrPackageFragmentDescriptor> ownerContext;
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy", "doGenerateBody"));
            }
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/PropertyCodegen$DelegatedPropertyAccessorStrategy", "doGenerateBody"));
            }
            InstructionAdapter v = codegen.v;
            BindingContext bindingContext = this.state.getBindingContext();
            ResolvedCall<FunctionDescriptor> resolvedCall = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, this.callableDescriptor);
            Call call = bindingContext.get(BindingContext.DELEGATED_PROPERTY_CALL, this.callableDescriptor);
            assert (call != null) : "Call should be recorded for delegate call " + signature.toString();
            if (codegen.getContext().getContextKind() != OwnerKind.PACKAGE) {
                v.load(0, AsmTypeConstants.OBJECT_TYPE);
            }
            if ((ownerContext = codegen.getContext().getClassOrPackageParentContext()) instanceof ClassContext) {
                owner = this.state.getTypeMapper().mapClass((ClassifierDescriptor)((ClassContext)ownerContext).getContextDescriptor());
            } else if (ownerContext instanceof PackageContext) {
                owner = ((PackageContext)ownerContext).getPackagePartType();
            } else {
                throw new UnsupportedOperationException("Unknown context: " + ownerContext);
            }
            codegen.tempVariables.put(call.getValueArguments().get(1).asElement(), new StackValue(AsmTypeConstants.PROPERTY_METADATA_TYPE){

                @Override
                public void put(Type type, InstructionAdapter v) {
                    v.getstatic(owner.getInternalName(), "$propertyMetadata", "[" + AsmTypeConstants.PROPERTY_METADATA_TYPE);
                    v.iconst(DelegatedPropertyAccessorStrategy.this.index);
                    StackValue.arrayElement(AsmTypeConstants.PROPERTY_METADATA_TYPE).put(type, v);
                }
            });
            StackValue.Property delegatedProperty = codegen.intermediateValueForProperty(((PropertyAccessorDescriptor)this.callableDescriptor).getCorrespondingProperty(), true, null);
            StackValue lastValue = codegen.invokeFunction(call, delegatedProperty, resolvedCall);
            Type asmType = signature.getReturnType();
            lastValue.put(asmType, v);
            v.areturn(asmType);
        }
    }

    private static class DefaultPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
        public DefaultPropertyAccessorStrategy(@NotNull GenerationState state, @NotNull PropertyAccessorDescriptor descriptor) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "<init>"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "<init>"));
            }
            super(state, descriptor);
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "doGenerateBody"));
            }
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/PropertyCodegen$DefaultPropertyAccessorStrategy", "doGenerateBody"));
            }
            InstructionAdapter v = codegen.v;
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)this.callableDescriptor).getCorrespondingProperty();
            int paramCode = 0;
            if (codegen.getContext().getContextKind() != OwnerKind.PACKAGE) {
                v.load(0, AsmTypeConstants.OBJECT_TYPE);
                paramCode = 1;
            }
            StackValue.Property property2 = codegen.intermediateValueForProperty(propertyDescriptor, true, null);
            if (this.callableDescriptor instanceof PropertyGetterDescriptor) {
                Type type = signature.getReturnType();
                ((StackValue)property2).put(type, v);
                v.areturn(type);
            } else if (this.callableDescriptor instanceof PropertySetterDescriptor) {
                ReceiverParameterDescriptor receiverParameter = propertyDescriptor.getReceiverParameter();
                if (receiverParameter != null) {
                    paramCode += codegen.typeMapper.mapType(receiverParameter.getType()).getSize();
                }
                Type type = codegen.typeMapper.mapType(propertyDescriptor);
                v.load(paramCode, type);
                ((StackValue)property2).store(type, v);
                v.visitInsn(177);
            } else {
                throw new IllegalStateException("Unknown property accessor: " + this.callableDescriptor);
            }
        }
    }
}

