/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.Unit;
import kotlin.modules.AllModules;
import kotlin.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.asJava.FilteredJvmDiagnostics;
import org.jetbrains.jet.cli.common.CLIConfigurationKeys;
import org.jetbrains.jet.cli.common.CompilerPlugin;
import org.jetbrains.jet.cli.common.CompilerPluginContext;
import org.jetbrains.jet.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.jet.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.codegen.ClassBuilderFactories;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.GeneratedClassLoader;
import org.jetbrains.jet.codegen.KotlinCodegenFacade;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.Progress;
import org.jetbrains.jet.config.CommonConfigurationKeys;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.parsing.JetScriptDefinition;
import org.jetbrains.jet.lang.parsing.JetScriptDefinitionProvider;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.ScriptNameUtil;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacadeForJVM;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.kotlin.incremental.IncrementalCacheProvider;
import org.jetbrains.jet.lang.resolve.kotlin.incremental.IncrementalPackage;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.plugin.MainFunctionDetector;
import org.jetbrains.jet.utils.KotlinPaths;

public class KotlinToJVMBytecodeCompiler {
    private KotlinToJVMBytecodeCompiler() {
    }

    @NotNull
    private static List<String> getAbsolutePaths(@NotNull File directory, @NotNull Module module) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "getAbsolutePaths"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "getAbsolutePaths"));
        }
        ArrayList<String> result2 = Lists.newArrayList();
        for (String sourceFile : module.getSourceFiles()) {
            File source = new File(sourceFile);
            if (!source.isAbsolute()) {
                source = new File(directory, sourceFile);
            }
            if (!source.exists()) {
                throw new CompileEnvironmentException("'" + source + "' does not exist in module " + module.getModuleName());
            }
            result2.add(source.getAbsolutePath());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "getAbsolutePaths"));
        }
        return arrayList;
    }

    private static void writeOutput(CompilerConfiguration configuration, ClassFileFactory outputFiles, File outputDir, File jarPath, boolean jarRuntime, FqName mainClass) {
        MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
        CompileEnvironmentUtil.writeOutputToDirOrJar(jarPath, outputDir, jarRuntime, mainClass, outputFiles, messageCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compileModules(@NotNull CompilerConfiguration configuration, @NotNull List<Module> chunk, @NotNull File directory, @Nullable File jarPath, boolean jarRuntime) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        HashMap<Module, ClassFileFactory> outputFiles = Maps.newHashMap();
        CompilerConfiguration compilerConfiguration = KotlinToJVMBytecodeCompiler.createCompilerConfiguration(configuration, chunk, directory);
        Disposable parentDisposable = Disposer.newDisposable();
        JetCoreEnvironment environment = null;
        try {
            environment = JetCoreEnvironment.createForProduction(parentDisposable, compilerConfiguration);
            AnalyzeExhaust exhaust = KotlinToJVMBytecodeCompiler.analyze(environment);
            if (exhaust == null) {
                boolean bl = false;
                return bl;
            }
            exhaust.throwIfError();
            for (Module module : chunk) {
                List<JetFile> jetFiles = CompileEnvironmentUtil.getJetFiles(environment.getProject(), KotlinToJVMBytecodeCompiler.getAbsolutePaths(directory, module), new Function1<String, Unit>(){

                    @Override
                    public Unit invoke(String s) {
                        throw new IllegalStateException("Should have been checked before: " + s);
                    }
                });
                GenerationState generationState = KotlinToJVMBytecodeCompiler.generate(environment, exhaust, jetFiles, module.getModuleName());
                outputFiles.put(module, generationState.getFactory());
            }
        }
        finally {
            if (environment != null) {
                Disposer.dispose(parentDisposable);
            }
        }
        for (Module module : chunk) {
            KotlinToJVMBytecodeCompiler.writeOutput(configuration, (ClassFileFactory)outputFiles.get(module), new File(module.getOutputDirectory()), jarPath, jarRuntime, null);
        }
        return true;
    }

    @NotNull
    private static CompilerConfiguration createCompilerConfiguration(@NotNull CompilerConfiguration base, @NotNull List<Module> chunk, @NotNull File directory) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "createCompilerConfiguration"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "createCompilerConfiguration"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "createCompilerConfiguration"));
        }
        CompilerConfiguration configuration = base.copy();
        for (Module module : chunk) {
            configuration.addAll(CommonConfigurationKeys.SOURCE_ROOTS_KEY, KotlinToJVMBytecodeCompiler.getAbsolutePaths(directory, module));
            for (String classpathRoot : module.getClasspathRoots()) {
                configuration.add(JVMConfigurationKeys.CLASSPATH_KEY, new File(classpathRoot));
            }
            for (String annotationsRoot : module.getAnnotationsRoots()) {
                configuration.add(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, new File(annotationsRoot));
            }
            configuration.add(JVMConfigurationKeys.MODULE_IDS, module.getModuleName());
        }
        CompilerConfiguration compilerConfiguration = configuration;
        if (compilerConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "createCompilerConfiguration"));
        }
        return compilerConfiguration;
    }

    @Nullable
    private static FqName findMainClass(@NotNull GenerationState generationState, @NotNull List<JetFile> files) {
        if (generationState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generationState", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "findMainClass"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "findMainClass"));
        }
        MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(generationState.getBindingContext());
        FqName mainClass = null;
        for (JetFile file : files) {
            if (!mainFunctionDetector.hasMain(file.getDeclarations())) continue;
            if (mainClass != null) {
                return null;
            }
            FqName fqName = file.getPackageFqName();
            mainClass = PackageClassUtils.getPackageClassFqName(fqName);
        }
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compileBunchOfSources(JetCoreEnvironment environment, @Nullable File jar, @Nullable File outputDir, boolean includeRuntime) {
        GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment);
        if (generationState == null) {
            return false;
        }
        FqName mainClass = KotlinToJVMBytecodeCompiler.findMainClass(generationState, environment.getSourceFiles());
        try {
            KotlinToJVMBytecodeCompiler.writeOutput(environment.getConfiguration(), generationState.getFactory(), outputDir, jar, includeRuntime, mainClass);
            boolean bl = true;
            return bl;
        }
        finally {
            generationState.destroy();
        }
    }

    public static void compileAndExecuteScript(@NotNull KotlinPaths paths, @NotNull JetCoreEnvironment environment, @NotNull List<String> scriptArgs) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        if (scriptArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptArgs", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        Class<?> scriptClass = KotlinToJVMBytecodeCompiler.compileScript(paths, environment);
        if (scriptClass == null) {
            return;
        }
        try {
            scriptClass.getConstructor(String[].class).newInstance(new Object[]{scriptArgs.toArray(new String[scriptArgs.size()])});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to evaluate script: " + e, e);
        }
    }

    @Nullable
    public static Class<?> compileScript(@NotNull KotlinPaths paths, @NotNull JetCoreEnvironment environment) {
        GenerationState state;
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        List<AnalyzerScriptParameter> scriptParameters = environment.getConfiguration().getList(JVMConfigurationKeys.SCRIPT_PARAMETERS);
        if (!scriptParameters.isEmpty()) {
            JetScriptDefinitionProvider.getInstance(environment.getProject()).addScriptDefinition(new JetScriptDefinition(".kts", scriptParameters));
        }
        if ((state = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment)) == null) {
            return null;
        }
        try {
            GeneratedClassLoader classLoader = new GeneratedClassLoader(state.getFactory(), (ClassLoader)new URLClassLoader(new URL[]{paths.getRuntimePath().toURI().toURL()}, AllModules.class.getClassLoader()), new URL[0]);
            FqName nameForScript = ScriptNameUtil.classNameForScript(environment.getSourceFiles().get(0).getScript());
            return classLoader.loadClass(nameForScript.asString());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to evaluate script: " + e, e);
        }
    }

    @Nullable
    public static GenerationState analyzeAndGenerate(@NotNull JetCoreEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "analyzeAndGenerate"));
        }
        AnalyzeExhaust exhaust = KotlinToJVMBytecodeCompiler.analyze(environment);
        if (exhaust == null) {
            return null;
        }
        exhaust.throwIfError();
        return KotlinToJVMBytecodeCompiler.generate(environment, exhaust, environment.getSourceFiles(), null);
    }

    @Nullable
    private static AnalyzeExhaust analyze(final @NotNull JetCoreEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "analyze"));
        }
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(environment.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY));
        analyzerWithCompilerReport.analyzeAndReport(new Function0<AnalyzeExhaust>(){

            @Override
            @NotNull
            public AnalyzeExhaust invoke() {
                CliLightClassGenerationSupport support = CliLightClassGenerationSupport.getInstanceForCli(environment.getProject());
                BindingTrace sharedTrace = support.getTrace();
                ModuleDescriptorImpl sharedModule = support.getModule();
                AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(environment.getProject(), environment.getSourceFiles(), sharedTrace, Predicates.<PsiFile>alwaysTrue(), sharedModule, environment.getConfiguration().get(JVMConfigurationKeys.MODULE_IDS), environment.getConfiguration().get(JVMConfigurationKeys.INCREMENTAL_CACHE_BASE_DIR));
                if (analyzeExhaust == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler$2", "invoke"));
                }
                return analyzeExhaust;
            }
        }, environment.getSourceFiles());
        AnalyzeExhaust exhaust = analyzerWithCompilerReport.getAnalyzeExhaust();
        assert (exhaust != null) : "AnalyzeExhaust should be non-null, compiling: " + environment.getSourceFiles();
        CompilerPluginContext context = new CompilerPluginContext(environment.getProject(), exhaust.getBindingContext(), environment.getSourceFiles());
        for (CompilerPlugin plugin : environment.getConfiguration().getList(CLIConfigurationKeys.COMPILER_PLUGINS)) {
            plugin.processFiles(context);
        }
        return analyzerWithCompilerReport.hasErrors() ? null : exhaust;
    }

    @NotNull
    private static GenerationState generate(@NotNull JetCoreEnvironment environment, @NotNull AnalyzeExhaust exhaust, @NotNull List<JetFile> sourceFiles, @Nullable String moduleId) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        if (exhaust == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exhaust", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        CompilerConfiguration configuration = environment.getConfiguration();
        File incrementalCacheDir = configuration.get(JVMConfigurationKeys.INCREMENTAL_CACHE_BASE_DIR);
        IncrementalCacheProvider incrementalCacheProvider = IncrementalCacheProvider.object$.getInstance();
        Collection<FqName> packagesWithRemovedFiles = incrementalCacheDir == null || moduleId == null || incrementalCacheProvider == null ? null : IncrementalPackage.getPackagesWithRemovedFiles(incrementalCacheProvider.getIncrementalCache(incrementalCacheDir), moduleId, environment.getSourceFiles());
        BindingTraceContext diagnosticHolder = new BindingTraceContext();
        GenerationState generationState = new GenerationState(environment.getProject(), ClassBuilderFactories.BINARIES, Progress.DEAF, exhaust.getModuleDescriptor(), exhaust.getBindingContext(), sourceFiles, configuration.get(JVMConfigurationKeys.GENERATE_NOT_NULL_ASSERTIONS, false), configuration.get(JVMConfigurationKeys.GENERATE_NOT_NULL_PARAMETER_ASSERTIONS, false), GenerationState.GenerateClassFilter.GENERATE_ALL, configuration.get(JVMConfigurationKeys.ENABLE_INLINE, true), packagesWithRemovedFiles, moduleId, diagnosticHolder);
        KotlinCodegenFacade.compileCorrectFiles(generationState, CompilationErrorHandler.THROW_EXCEPTION);
        AnalyzerWithCompilerReport.reportDiagnostics(new FilteredJvmDiagnostics(diagnosticHolder.getBindingContext().getDiagnostics(), exhaust.getBindingContext().getDiagnostics()), environment.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY));
        GenerationState generationState2 = generationState;
        if (generationState2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        return generationState2;
    }
}

