/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartFMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.lang.reflect.Method;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class MessageBusConnectionImpl
implements MessageBusConnection {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusConnectionImpl");
    private final MessageBusImpl myBus;
    private final ThreadLocal<Queue<Message>> myPendingMessages;
    private MessageHandler myDefaultHandler;
    private volatile SmartFMap<Topic, Object> mySubscriptions;

    public MessageBusConnectionImpl(@NotNull MessageBusImpl bus) {
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/messages/impl/MessageBusConnectionImpl", "<init>"));
        }
        this.myPendingMessages = MessageBusImpl.createThreadLocalQueue();
        this.mySubscriptions = SmartFMap.emptyMap();
        this.myBus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> void subscribe(@NotNull Topic<L> topic, @NotNull L handler) throws IllegalStateException {
        if (topic == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/messages/impl/MessageBusConnectionImpl", "subscribe"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/messages/impl/MessageBusConnectionImpl", "subscribe"));
        }
        ThreadLocal<Queue<Message>> threadLocal = this.myPendingMessages;
        synchronized (threadLocal) {
            if (this.mySubscriptions.get(topic) != null) {
                throw new IllegalStateException("Subscription to " + topic + " already exists");
            }
            this.mySubscriptions = this.mySubscriptions.plus(topic, handler);
        }
        this.myBus.notifyOnSubscription(this, topic);
    }

    @Override
    public void disconnect() {
        Queue<Message> jobs = this.myPendingMessages.get();
        this.myPendingMessages.remove();
        this.myBus.notifyConnectionTerminated(this);
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
    }

    @Override
    public void dispose() {
        this.disconnect();
    }

    @Override
    public void deliverImmediately() {
        Queue<Message> messages = this.myPendingMessages.get();
        while (!messages.isEmpty()) {
            this.myBus.deliverSingleMessage();
        }
    }

    void deliverMessage(@NotNull Message message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/messages/impl/MessageBusConnectionImpl", "deliverMessage"));
        }
        Message messageOnLocalQueue = this.myPendingMessages.get().poll();
        assert (messageOnLocalQueue == message);
        Topic topic = message.getTopic();
        Object handler = this.mySubscriptions.get(topic);
        try {
            Method listenerMethod = message.getListenerMethod();
            if (handler == this.myDefaultHandler) {
                this.myDefaultHandler.handle(listenerMethod, message.getArgs());
            } else {
                listenerMethod.invoke(handler, message.getArgs());
            }
        }
        catch (AbstractMethodError listenerMethod) {
        }
        catch (Throwable e) {
            LOG.error(e.getCause() == null ? e : e.getCause());
        }
    }

    void scheduleMessageDelivery(Message message) {
        this.myPendingMessages.get().offer(message);
    }

    public String toString() {
        return this.mySubscriptions.toString();
    }
}

