/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;

public class PsiMethodReferenceCompatibilityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance("#" + PsiMethodReferenceCompatibilityConstraint.class.getName());
    private final PsiMethodReferenceExpression myExpression;
    private PsiType myT;

    public PsiMethodReferenceCompatibilityConstraint(PsiMethodReferenceExpression expression, PsiType t) {
        this.myExpression = expression;
        this.myT = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        JavaResolveResult resolve2;
        if (!LambdaUtil.isFunctionalType(this.myT)) {
            return false;
        }
        PsiType groundTargetType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT);
        PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(classResolveResult);
        if (interfaceMethod == null) {
            return false;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, classResolveResult);
        PsiParameter[] targetParameters = interfaceMethod.getParameterList().getParameters();
        PsiType interfaceMethodReturnType = interfaceMethod.getReturnType();
        PsiType returnType = substitutor.substitute(interfaceMethodReturnType);
        PsiType[] typeParameters = this.myExpression.getTypeParameters();
        if (!this.myExpression.isExact()) {
            for (PsiParameter parameter : targetParameters) {
                if (session.isProperType(substitutor.substitute(parameter.getType()))) continue;
                return false;
            }
        } else {
            int i;
            PsiParameter[] parameters;
            PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this.myExpression);
            PsiSubstitutor psiSubstitutor = qualifierResolveResult.getSubstitutor();
            PsiMember applicableMember = this.myExpression.getPotentiallyApplicableMember();
            LOG.assertTrue(applicableMember != null);
            PsiType applicableMethodReturnType = applicableMember instanceof PsiMethod ? ((PsiMethod)applicableMember).getReturnType() : null;
            int idx = 0;
            for (PsiTypeParameter param : ((PsiTypeParameterListOwner)applicableMember).getTypeParameters()) {
                if (idx >= typeParameters.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters[idx++]);
            }
            PsiParameter[] psiParameterArray = parameters = applicableMember instanceof PsiMethod ? ((PsiMethod)applicableMember).getParameterList().getParameters() : PsiParameter.EMPTY_ARRAY;
            if (targetParameters.length == parameters.length + 1) {
                this.specialCase(session, constraints, substitutor, targetParameters);
                for (i = 1; i < targetParameters.length; ++i) {
                    constraints.add(new TypeCompatibilityConstraint(psiSubstitutor.substitute(parameters[i - 1].getType()), substitutor.substitute(targetParameters[i].getType())));
                }
            } else if (targetParameters.length == parameters.length) {
                for (i = 0; i < targetParameters.length; ++i) {
                    constraints.add(new TypeCompatibilityConstraint(psiSubstitutor.substitute(parameters[i].getType()), substitutor.substitute(targetParameters[i].getType())));
                }
            } else {
                return false;
            }
            if (returnType != PsiType.VOID && returnType != null) {
                if (applicableMethodReturnType == PsiType.VOID) {
                    return false;
                }
                if (applicableMethodReturnType != null) {
                    constraints.add(new TypeCompatibilityConstraint(returnType, psiSubstitutor.substitute(applicableMethodReturnType)));
                } else if (applicableMember instanceof PsiClass || applicableMember instanceof PsiMethod && ((PsiMethod)applicableMember).isConstructor()) {
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(applicableMember.getProject());
                    PsiClass containingClass = qualifierResolveResult.getContainingClass();
                    if (containingClass != null) {
                        PsiClassType classType = elementFactory.createType(containingClass, psiSubstitutor);
                        constraints.add(new TypeCompatibilityConstraint(returnType, classType));
                    }
                }
            }
            return true;
        }
        Map<PsiMethodReferenceExpression, PsiType> map2 = PsiMethodReferenceUtil.getFunctionalTypeMap();
        PsiType added = map2.put(this.myExpression, groundTargetType);
        try {
            resolve2 = this.myExpression.advancedResolve(true);
        }
        finally {
            if (added == null) {
                map2.remove(this.myExpression);
            }
        }
        PsiElement element = resolve2.getElement();
        if (element == null) {
            return false;
        }
        if (PsiType.VOID.equals(returnType) || returnType == null) {
            return true;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiClass containingClass = method.getContainingClass();
            LOG.assertTrue(containingClass != null, method);
            PsiType referencedMethodReturnType = method.isConstructor() ? JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass, PsiSubstitutor.EMPTY) : method.getReturnType();
            LOG.assertTrue(referencedMethodReturnType != null, method);
            session.initBounds(method.getTypeParameters());
            if (!PsiTreeUtil.isContextAncestor(containingClass, this.myExpression, false) || PsiUtil.getEnclosingStaticElement(this.myExpression, containingClass) != null) {
                session.initBounds(containingClass.getTypeParameters());
            }
            if (typeParameters.length == 0 && method.getTypeParameters().length > 0) {
                PsiClass interfaceClass = classResolveResult.getElement();
                LOG.assertTrue(interfaceClass != null);
                if (PsiPolyExpressionUtil.mentionsTypeParameters(referencedMethodReturnType, ContainerUtil.newHashSet(method.getTypeParameters())).booleanValue()) {
                    session.collectApplicabilityConstraints(this.myExpression, (MethodCandidateInfo)resolve2, groundTargetType);
                    session.registerReturnTypeConstraints(referencedMethodReturnType, returnType);
                    return true;
                }
            }
            if (PsiType.VOID.equals(referencedMethodReturnType)) {
                return false;
            }
            int idx = 0;
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            for (PsiTypeParameter param : method.getTypeParameters()) {
                if (idx >= typeParameters.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters[idx++]);
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (targetParameters.length == parameters.length + 1 && !method.isVarArgs() && PsiPolyExpressionUtil.mentionsTypeParameters(referencedMethodReturnType, ContainerUtil.newHashSet(containingClass.getTypeParameters())).booleanValue()) {
                this.specialCase(session, constraints, substitutor, targetParameters);
            }
            constraints.add(new TypeCompatibilityConstraint(returnType, psiSubstitutor.substitute(referencedMethodReturnType)));
        }
        return true;
    }

    private void specialCase(InferenceSession session, List<ConstraintFormula> constraints, PsiSubstitutor substitutor, PsiParameter[] targetParameters) {
        PsiClass qualifierClass;
        PsiType qualifierType;
        PsiTypeElement qualifierTypeElement = this.myExpression.getQualifierType();
        PsiExpression qualifierExpression = this.myExpression.getQualifierExpression();
        if (qualifierTypeElement != null) {
            qualifierType = qualifierTypeElement.getType();
            qualifierClass = PsiUtil.resolveClassInType(qualifierType);
            if (qualifierClass != null) {
                qualifierType = JavaPsiFacade.getElementFactory(this.myExpression.getProject()).createType(qualifierClass, PsiSubstitutor.EMPTY);
            }
        } else {
            JavaResolveResult resolveResult;
            PsiElement res;
            LOG.assertTrue(qualifierExpression != null);
            qualifierType = qualifierExpression.getType();
            if (qualifierType == null && qualifierExpression instanceof PsiReferenceExpression && (res = (resolveResult = ((PsiReferenceExpression)qualifierExpression).advancedResolve(false)).getElement()) instanceof PsiClass) {
                PsiClass containingClass = (PsiClass)res;
                boolean isRawSubst = !this.myExpression.isConstructor() && PsiUtil.isRawSubstitutor(containingClass, resolveResult.getSubstitutor());
                qualifierType = JavaPsiFacade.getElementFactory(res.getProject()).createType(containingClass, isRawSubst ? PsiSubstitutor.EMPTY : resolveResult.getSubstitutor());
            }
        }
        qualifierClass = PsiUtil.resolveClassInType(qualifierType);
        if (qualifierClass != null) {
            session.initBounds(qualifierClass.getTypeParameters());
            constraints.add(new StrictSubtypingConstraint(qualifierType, substitutor.substitute(targetParameters[0].getType())));
        }
    }

    @Override
    public void apply(PsiSubstitutor substitutor) {
        this.myT = substitutor.substitute(this.myT);
    }
}

