/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.psi.CommonClassNames;
import com.intellij.util.CharTable;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceHashingStrategy;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.StringFactory;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharTableImpl
implements CharTable {
    private static final CharSequenceHashingStrategy HASHER = CharSequenceHashingStrategy.CASE_SENSITIVE;
    private static final OpenTHashSet<CharSequence> STATIC_ENTRIES = CharTableImpl.newStaticSet();
    private final OpenTHashSet<CharSequence> entries = new OpenTHashSet<CharSequence>(10, 0.9f, HASHER);

    @Override
    @NotNull
    public CharSequence intern(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/CharTableImpl", "intern"));
        }
        if (text.length() > 40) {
            String string = CharTableImpl.createSequence(text);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "intern"));
            }
            return string;
        }
        CharSequence charSequence = this.doIntern(text);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "intern"));
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CharSequence doIntern(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
        }
        CharSequence interned = CharTableImpl.getStaticInterned(text);
        if (interned != null) {
            CharSequence charSequence = interned;
            if (charSequence != null) return charSequence;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
        }
        OpenTHashSet<CharSequence> openTHashSet = this.entries;
        // MONITORENTER : openTHashSet
        interned = this.entries.get(text);
        if (interned != null) {
            CharSequence charSequence = interned;
            // MONITOREXIT : openTHashSet
            if (charSequence != null) return charSequence;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
        }
        String entry = CharTableImpl.createSequence(text);
        boolean added = this.entries.add(entry);
        assert (added);
        String string = entry;
        // MONITOREXIT : openTHashSet
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "doIntern"));
    }

    @Override
    @NotNull
    public CharSequence intern(@NotNull CharSequence baseText, int startOffset, int endOffset) {
        if (baseText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/CharTableImpl", "intern"));
        }
        if (endOffset - startOffset == baseText.length()) {
            CharSequence charSequence = this.intern(baseText);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "intern"));
            }
            return charSequence;
        }
        CharSequence charSequence = this.intern(new CharSequenceSubSequence(baseText, startOffset, endOffset));
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "intern"));
        }
        return charSequence;
    }

    @NotNull
    private static String createSequence(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
        }
        if (text instanceof String) {
            String string = (String)text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
            }
            return string;
        }
        char[] buf = new char[text.length()];
        CharArrayUtil.getChars(text, buf, 0);
        String string = StringFactory.createShared(buf);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/CharTableImpl", "createSequence"));
        }
        return string;
    }

    @Nullable
    public static CharSequence getStaticInterned(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/CharTableImpl", "getStaticInterned"));
        }
        return STATIC_ENTRIES.get(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void staticIntern(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/CharTableImpl", "staticIntern"));
        }
        OpenTHashSet<CharSequence> openTHashSet = STATIC_ENTRIES;
        synchronized (openTHashSet) {
            STATIC_ENTRIES.add(text);
        }
    }

    private static OpenTHashSet<CharSequence> newStaticSet() {
        OpenTHashSet<CharSequence> r = new OpenTHashSet<CharSequence>(10, 0.9f, HASHER);
        r.add("==");
        r.add("!=");
        r.add("||");
        r.add("++");
        r.add("--");
        r.add("<");
        r.add("<=");
        r.add("<<=");
        r.add("<<");
        r.add(">");
        r.add("&");
        r.add("&&");
        r.add("+=");
        r.add("-=");
        r.add("*=");
        r.add("/=");
        r.add("&=");
        r.add("|=");
        r.add("^=");
        r.add("%=");
        r.add("(");
        r.add(")");
        r.add("{");
        r.add("}");
        r.add("[");
        r.add("]");
        r.add(";");
        r.add(",");
        r.add("...");
        r.add(".");
        r.add("=");
        r.add("!");
        r.add("~");
        r.add("?");
        r.add(":");
        r.add("+");
        r.add("-");
        r.add("*");
        r.add("/");
        r.add("|");
        r.add("^");
        r.add("%");
        r.add("@");
        r.add(" ");
        r.add("  ");
        r.add("   ");
        r.add("    ");
        r.add("     ");
        r.add("      ");
        r.add("       ");
        r.add("        ");
        r.add("         ");
        r.add("          ");
        r.add("           ");
        r.add("            ");
        r.add("             ");
        r.add("              ");
        r.add("               ");
        r.add("\n");
        r.add("\n  ");
        r.add("\n    ");
        r.add("\n      ");
        r.add("\n        ");
        r.add("\n          ");
        r.add("\n            ");
        r.add("\n              ");
        r.add("\n                ");
        r.add("<");
        r.add(">");
        r.add("</");
        r.add("/>");
        r.add("\"");
        r.add("'");
        r.add("<![CDATA[");
        r.add("]]>");
        r.add("<!--");
        r.add("-->");
        r.add("<!DOCTYPE");
        r.add("SYSTEM");
        r.add("PUBLIC");
        r.add("<?");
        r.add("?>");
        r.add("<%");
        r.add("%>");
        r.add("<%=");
        r.add("<%@");
        r.add("${");
        r.add("");
        return r;
    }

    public static void addStringsFromClassToStatics(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/CharTableImpl", "addStringsFromClassToStatics"));
        }
        for (Field field : aClass.getDeclaredFields()) {
            String typeName;
            if ((field.getModifiers() & 8) == 0 || (field.getModifiers() & 1) == 0) continue;
            try {
                typeName = (String)field.get(null);
            }
            catch (Exception e) {
                continue;
            }
            CharTableImpl.staticIntern(typeName);
        }
    }

    static {
        CharTableImpl.addStringsFromClassToStatics(CommonClassNames.class);
    }
}

