/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.intellij.psi.PsiElement;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetValueArgument;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VarargValueArgument;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.InlineUtil;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class InlineCallResolverExtension
implements CallResolverExtension {
    private final SimpleFunctionDescriptor descriptor;
    private final Set<CallableDescriptor> inlinableParameters;
    private final boolean isEffectivelyPublicApiFunction;

    public InlineCallResolverExtension(@NotNull SimpleFunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "<init>"));
        }
        this.inlinableParameters = new HashSet<CallableDescriptor>();
        assert (descriptor.getInlineStrategy().isInline()) : "This extension should be created only for inline functions but not " + descriptor;
        this.descriptor = descriptor;
        this.isEffectivelyPublicApiFunction = InlineCallResolverExtension.isEffectivelyPublicApi(descriptor);
        for (ValueParameterDescriptor param : descriptor.getValueParameters()) {
            if (!InlineCallResolverExtension.isInlinableParameter(param)) continue;
            this.inlinableParameters.add(param);
        }
        ReceiverParameterDescriptor receiverParameter = descriptor.getReceiverParameter();
        if (receiverParameter != null && InlineCallResolverExtension.isInlinableParameter(receiverParameter)) {
            this.inlinableParameters.add(receiverParameter);
        }
    }

    @Override
    public <F extends CallableDescriptor> void run(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "run"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "run"));
        }
        JetExpression expression = context.call.getCalleeExpression();
        if (expression == null) {
            return;
        }
        F targetDescriptor = resolvedCall.getResultingDescriptor();
        this.checkCallWithReceiver(context, (CallableDescriptor)targetDescriptor, resolvedCall.getThisObject(), expression);
        this.checkCallWithReceiver(context, (CallableDescriptor)targetDescriptor, resolvedCall.getReceiverArgument(), expression);
        if (this.inlinableParameters.contains(targetDescriptor) && !InlineCallResolverExtension.couldAccessVariable(expression)) {
            context.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(expression, expression, this.descriptor));
        }
        for (ResolvedValueArgument value : resolvedCall.getValueArguments().values()) {
            if (value instanceof DefaultValueArgument) continue;
            for (ValueArgument argument : value.getArguments()) {
                this.checkValueParameter(context, (CallableDescriptor)targetDescriptor, argument, value instanceof VarargValueArgument);
            }
        }
        this.checkVisibility((CallableDescriptor)targetDescriptor, expression, context);
        this.checkRecursion((CallableDescriptor)targetDescriptor, expression, context);
    }

    private static boolean couldAccessVariable(JetExpression expression) {
        PsiElement parent = expression.getParent();
        while (parent != null) {
            if (parent instanceof JetValueArgument || parent instanceof JetBinaryExpression || parent instanceof JetUnaryExpression || parent instanceof JetDotQualifiedExpression || parent instanceof JetCallExpression || parent instanceof JetArrayAccessExpression || parent instanceof JetMultiDeclaration) {
                JetToken token;
                if (parent instanceof JetPrefixExpression) {
                    if (JetPsiUtil.isLabeledExpression((JetPrefixExpression)parent)) {
                        parent = parent.getParent();
                        continue;
                    }
                } else if (parent instanceof JetBinaryExpression && ((token = JetPsiUtil.getOperationToken((JetOperationExpression)((Object)parent))) == JetTokens.EQ || token == JetTokens.ANDAND || token == JetTokens.OROR)) {
                    return false;
                }
                return true;
            }
            if (parent instanceof JetParenthesizedExpression || parent instanceof JetBinaryExpressionWithTypeRHS) {
                parent = parent.getParent();
                continue;
            }
            return false;
        }
        return false;
    }

    private void checkValueParameter(BasicCallResolutionContext context, CallableDescriptor targetDescriptor, ValueArgument argument, boolean isVararg) {
        JetExpression jetExpression = argument.getArgumentExpression();
        if (jetExpression == null) {
            return;
        }
        CallableDescriptor varDescriptor = InlineCallResolverExtension.getDescriptor(context, jetExpression);
        if (varDescriptor != null && this.inlinableParameters.contains(varDescriptor)) {
            this.checkFunctionCall(context, targetDescriptor, jetExpression, isVararg);
        }
    }

    private void checkCallWithReceiver(@NotNull BasicCallResolutionContext context, @NotNull CallableDescriptor targetDescriptor, @NotNull ReceiverValue receiver, @Nullable JetExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkCallWithReceiver"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkCallWithReceiver"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkCallWithReceiver"));
        }
        if (!receiver.exists()) {
            return;
        }
        CallableDescriptor varDescriptor = null;
        JetExpression receiverExpression = null;
        if (receiver instanceof ExpressionReceiver) {
            receiverExpression = ((ExpressionReceiver)receiver).getExpression();
            varDescriptor = InlineCallResolverExtension.getDescriptor(context, receiverExpression);
        } else if (receiver instanceof ExtensionReceiver) {
            ExtensionReceiver extensionReceiver = (ExtensionReceiver)receiver;
            CallableDescriptor extension = extensionReceiver.getDeclarationDescriptor();
            varDescriptor = extension.getReceiverParameter();
            assert (varDescriptor != null) : "Extension should have receiverParameterDescriptor: " + extension;
            receiverExpression = expression;
        }
        if (this.inlinableParameters.contains(varDescriptor)) {
            this.checkFunctionCall(context, targetDescriptor, receiverExpression, false);
        }
    }

    @Nullable
    private static CallableDescriptor getDescriptor(@NotNull BasicCallResolutionContext context, @NotNull JetExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "getDescriptor"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "getDescriptor"));
        }
        ResolvedCall<? extends CallableDescriptor> thisCall = context.trace.get(BindingContext.RESOLVED_CALL, expression);
        return thisCall != null ? thisCall.getResultingDescriptor() : null;
    }

    private void checkFunctionCall(BasicCallResolutionContext context, CallableDescriptor targetDescriptor, JetExpression receiverExpresssion, boolean isVararg) {
        boolean inlinableCall = InlineCallResolverExtension.isInvokeOrInlineExtension(targetDescriptor);
        if (!inlinableCall || isVararg) {
            context.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(receiverExpresssion, receiverExpresssion, this.descriptor));
        }
    }

    public void checkRecursion(@NotNull CallableDescriptor targetDescriptor, @NotNull JetElement expression, @NotNull BasicCallResolutionContext context) {
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkRecursion"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkRecursion"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkRecursion"));
        }
        if (targetDescriptor.getOriginal() == this.descriptor) {
            context.trace.report(Errors.RECURSION_IN_INLINE.on(expression, expression, this.descriptor));
        }
    }

    private static boolean isInlinableParameter(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "isInlinableParameter"));
        }
        JetType type = descriptor.getReturnType();
        return type != null && KotlinBuiltIns.getInstance().isExactFunctionOrExtensionFunctionType(type) && !type.isNullable() && !InlineUtil.hasNoinlineAnnotation(descriptor);
    }

    private static boolean isInvokeOrInlineExtension(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "isInvokeOrInlineExtension"));
        }
        if (!(descriptor instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        boolean isInvoke = descriptor.getName().asString().equals("invoke") && containingDeclaration instanceof ClassDescriptor && KotlinBuiltIns.getInstance().isExactFunctionOrExtensionFunctionType(((ClassDescriptor)containingDeclaration).getDefaultType());
        return isInvoke || ((SimpleFunctionDescriptor)descriptor).getInlineStrategy().isInline();
    }

    private void checkVisibility(@NotNull CallableDescriptor declarationDescriptor, @NotNull JetElement expression, @NotNull BasicCallResolutionContext context) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkVisibility"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkVisibility"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/InlineCallResolverExtension", "checkVisibility"));
        }
        if (this.isEffectivelyPublicApiFunction && !InlineCallResolverExtension.isEffectivelyPublicApi(declarationDescriptor) && declarationDescriptor.getVisibility() != Visibilities.LOCAL) {
            context.trace.report(Errors.INVISIBLE_MEMBER_FROM_INLINE.on(expression, declarationDescriptor, this.descriptor));
        }
    }

    private static boolean isEffectivelyPublicApi(DeclarationDescriptorWithVisibility descriptor) {
        DeclarationDescriptorWithVisibility parent = descriptor;
        while (parent != null) {
            if (!parent.getVisibility().isPublicAPI()) {
                return false;
            }
            parent = DescriptorUtils.getParentOfType(parent, DeclarationDescriptorWithVisibility.class);
        }
        return true;
    }
}

