/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.stubs.PsiJetFileStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;

public class PsiJetFileStubImpl
extends PsiFileStubImpl<JetFile>
implements PsiClassHolderFileStub<JetFile>,
PsiJetFileStub {
    private final StringRef packageName;
    private final boolean isScript;

    public PsiJetFileStubImpl(JetFile jetFile, StringRef packageName, boolean isScript) {
        super(jetFile);
        this.packageName = packageName;
        this.isScript = isScript;
    }

    public PsiJetFileStubImpl(JetFile jetFile, String packageName, boolean isScript) {
        this(jetFile, StringRef.fromString(packageName), isScript);
    }

    @Override
    public String getPackageName() {
        return StringRef.toString(this.packageName);
    }

    @Override
    public boolean isScript() {
        return this.isScript;
    }

    @Override
    public IStubFileElementType getType() {
        return JetStubElementTypes.FILE;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiJetFileStubImpl[");
        builder.append("package=").append(this.getPackageName());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public PsiClass[] getClasses() {
        ArrayList<PsiClass> result2 = Lists.newArrayList();
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiClassStub)) continue;
            result2.add((PsiClass)child.getPsi());
        }
        return result2.toArray(new PsiClass[result2.size()]);
    }
}

