/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.stubs.PsiJetClassStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetClassElementType;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class PsiJetClassStubImpl
extends StubBase<JetClass>
implements PsiJetClassStub {
    private final StringRef qualifiedName;
    private final StringRef name;
    private final StringRef[] superNames;
    private final boolean isTrait;
    private final boolean isEnumClass;
    private final boolean isEnumEntry;
    private final boolean isAnnotation;
    private final boolean isInner;
    private final boolean isLocal;

    public PsiJetClassStubImpl(JetClassElementType type, StubElement parent, @Nullable String qualifiedName, String name, List<String> superNames, boolean isTrait, boolean isEnumClass, boolean isEnumEntry, boolean isAnnotation, boolean isInner, boolean isLocal) {
        this(type, parent, StringRef.fromString(qualifiedName), StringRef.fromString(name), PsiJetClassStubImpl.wrapStrings(superNames), isTrait, isEnumClass, isEnumEntry, isAnnotation, isInner, isLocal);
    }

    public PsiJetClassStubImpl(JetClassElementType type, StubElement parent, StringRef qualifiedName, StringRef name, StringRef[] superNames, boolean isTrait, boolean isEnumClass, boolean isEnumEntry, boolean isAnnotation, boolean isInner, boolean isLocal) {
        super(parent, type);
        this.qualifiedName = qualifiedName;
        this.name = name;
        this.superNames = superNames;
        this.isTrait = isTrait;
        this.isEnumClass = isEnumClass;
        this.isEnumEntry = isEnumEntry;
        this.isAnnotation = isAnnotation;
        this.isInner = isInner;
        this.isLocal = isLocal;
    }

    private static StringRef[] wrapStrings(List<String> names) {
        StringRef[] refs = new StringRef[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            refs[i] = StringRef.fromString(names.get(i));
        }
        return refs;
    }

    @Override
    public FqName getFqName() {
        String stringRef = StringRef.toString(this.qualifiedName);
        if (stringRef == null) {
            return null;
        }
        return new FqName(stringRef);
    }

    @Override
    public boolean isTrait() {
        return this.isTrait;
    }

    @Override
    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    @Override
    public boolean isEnumClass() {
        return this.isEnumClass;
    }

    @Override
    public boolean isEnumEntry() {
        return this.isEnumEntry;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public String getName() {
        return StringRef.toString(this.name);
    }

    @Override
    @NotNull
    public List<String> getSuperNames() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (StringRef ref : this.superNames) {
            result2.add(ref.toString());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetClassStubImpl", "getSuperNames"));
        }
        return arrayList;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiJetClassStubImpl[");
        if (this.isEnumClass()) {
            builder.append("enumClass ");
        }
        if (this.isEnumEntry()) {
            builder.append("enumEntry ");
        }
        if (this.isTrait()) {
            builder.append("trait ");
        }
        if (this.isAnnotation()) {
            builder.append("isAnnotation ");
        }
        if (this.isInner()) {
            builder.append("inner ");
        }
        if (this.isLocal()) {
            builder.append("local ");
        }
        builder.append("name=").append(this.getName());
        builder.append(" fqn=").append(this.getFqName());
        builder.append(" superNames=").append("[").append(StringUtil.join(ArrayUtil.toStringArray(this.getSuperNames()))).append("]");
        builder.append("]");
        return builder.toString();
    }
}

