/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import com.google.common.collect.Lists;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Label;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.asm4.commons.RemappingMethodAdapter;
import org.jetbrains.asm4.tree.AbstractInsnNode;
import org.jetbrains.asm4.tree.FieldInsnNode;
import org.jetbrains.asm4.tree.LabelNode;
import org.jetbrains.asm4.tree.MethodInsnNode;
import org.jetbrains.asm4.tree.MethodNode;
import org.jetbrains.asm4.tree.TryCatchBlockNode;
import org.jetbrains.asm4.tree.VarInsnNode;
import org.jetbrains.asm4.tree.analysis.Analyzer;
import org.jetbrains.asm4.tree.analysis.AnalyzerException;
import org.jetbrains.asm4.tree.analysis.Frame;
import org.jetbrains.asm4.tree.analysis.SourceInterpreter;
import org.jetbrains.asm4.tree.analysis.SourceValue;
import org.jetbrains.jet.codegen.ClosureCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.ConstructorInvocation;
import org.jetbrains.jet.codegen.inline.InlineAdapter;
import org.jetbrains.jet.codegen.inline.InlineCodegenUtil;
import org.jetbrains.jet.codegen.inline.InlineResult;
import org.jetbrains.jet.codegen.inline.InliningContext;
import org.jetbrains.jet.codegen.inline.InvokeCall;
import org.jetbrains.jet.codegen.inline.LambdaFieldRemapper;
import org.jetbrains.jet.codegen.inline.LambdaInfo;
import org.jetbrains.jet.codegen.inline.LambdaTransformer;
import org.jetbrains.jet.codegen.inline.Parameters;
import org.jetbrains.jet.codegen.inline.RemapVisitor;
import org.jetbrains.jet.codegen.inline.TypeRemapper;
import org.jetbrains.jet.codegen.inline.VarRemapper;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.utils.UtilsPackage;

public class MethodInliner {
    private final MethodNode node;
    private final Parameters parameters;
    private final InliningContext inliningContext;
    @Nullable
    private final Type lambdaType;
    private final LambdaFieldRemapper lambdaFieldRemapper;
    private final boolean isSameModule;
    private final JetTypeMapper typeMapper;
    private final List<InvokeCall> invokeCalls;
    private final List<ConstructorInvocation> constructorInvocations;
    private final Map<String, String> currentTypeMapping;
    private final InlineResult result;

    public MethodInliner(@NotNull MethodNode node, @NotNull Parameters parameters, @NotNull InliningContext parent, @Nullable Type lambdaType, LambdaFieldRemapper lambdaFieldRemapper, boolean isSameModule) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/MethodInliner", "<init>"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/codegen/inline/MethodInliner", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/jet/codegen/inline/MethodInliner", "<init>"));
        }
        this.invokeCalls = new ArrayList<InvokeCall>();
        this.constructorInvocations = new ArrayList<ConstructorInvocation>();
        this.currentTypeMapping = new HashMap<String, String>();
        this.node = node;
        this.parameters = parameters;
        this.inliningContext = parent;
        this.lambdaType = lambdaType;
        this.lambdaFieldRemapper = lambdaFieldRemapper;
        this.isSameModule = isSameModule;
        this.typeMapper = parent.state.getTypeMapper();
        this.result = InlineResult.create();
    }

    public InlineResult doInline(MethodVisitor adapter, VarRemapper.ParamRemapper remapper) {
        return this.doInline(adapter, remapper, this.lambdaFieldRemapper, true);
    }

    public InlineResult doInline(MethodVisitor adapter, VarRemapper.ParamRemapper remapper, LambdaFieldRemapper capturedRemapper, boolean remapReturn) {
        MethodNode transformedNode = this.node;
        try {
            transformedNode = this.markPlacesForInlineAndRemoveInlinable(transformedNode);
        }
        catch (AnalyzerException e) {
            throw UtilsPackage.rethrow(e);
        }
        transformedNode = this.doInline(transformedNode, capturedRemapper);
        MethodInliner.removeClosureAssertions(transformedNode);
        transformedNode.instructions.resetLabels();
        Label end = new Label();
        RemapVisitor visitor = new RemapVisitor(adapter, end, remapper, remapReturn);
        transformedNode.accept(visitor);
        visitor.visitLabel(end);
        return this.result;
    }

    private MethodNode doInline(MethodNode node, final LambdaFieldRemapper capturedRemapper) {
        final LinkedList<InvokeCall> currentInvokes = new LinkedList<InvokeCall>(this.invokeCalls);
        MethodNode resultNode = new MethodNode(node.access, node.name, node.desc, node.signature, null);
        final Iterator<ConstructorInvocation> iterator2 = this.constructorInvocations.iterator();
        RemappingMethodAdapter remappingMethodAdapter = new RemappingMethodAdapter(resultNode.access, resultNode.desc, resultNode, new TypeRemapper(this.currentTypeMapping));
        InlineAdapter inliner = new InlineAdapter(remappingMethodAdapter, this.parameters.totalSize()){
            private ConstructorInvocation invocation;

            @Override
            public void anew(Type type) {
                if (InlineCodegenUtil.isLambdaConstructorCall(type.getInternalName(), "<init>")) {
                    this.invocation = (ConstructorInvocation)iterator2.next();
                    if (this.invocation.shouldRegenerate()) {
                        Type newLambdaType = Type.getObjectType(((MethodInliner)MethodInliner.this).inliningContext.nameGenerator.genLambdaClassName());
                        MethodInliner.this.currentTypeMapping.put(this.invocation.getOwnerInternalName(), newLambdaType.getInternalName());
                        LambdaTransformer transformer = new LambdaTransformer(this.invocation.getOwnerInternalName(), MethodInliner.this.inliningContext.subInline(((MethodInliner)MethodInliner.this).inliningContext.nameGenerator, MethodInliner.this.currentTypeMapping).classRegeneration(), MethodInliner.this.isSameModule, newLambdaType);
                        InlineResult transformResult = transformer.doTransform(this.invocation, capturedRemapper);
                        MethodInliner.this.result.addAllClassesToRemove(transformResult);
                        if (((MethodInliner)MethodInliner.this).inliningContext.isInliningLambda) {
                            MethodInliner.this.result.addClassToRemove(this.invocation.getOwnerInternalName());
                        }
                    }
                }
                super.anew(type);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (InlineCodegenUtil.isInvokeOnLambda(owner, name)) {
                    assert (!currentInvokes.isEmpty());
                    InvokeCall invokeCall = (InvokeCall)currentInvokes.remove();
                    LambdaInfo info = invokeCall.lambdaInfo;
                    if (info == null) {
                        super.visitMethodInsn(opcode, owner, name, desc);
                        return;
                    }
                    int valueParamShift = this.getNextLocalIndex();
                    MethodInliner.putStackValuesIntoLocals(info.getParamsWithoutCapturedValOrVar(), valueParamShift, this, desc);
                    Parameters lambdaParameters = info.addAllParameters(capturedRemapper);
                    this.setInlining(true);
                    MethodInliner inliner = new MethodInliner(info.getNode(), lambdaParameters, MethodInliner.this.inliningContext.subInlineLambda(info), info.getLambdaClassType(), capturedRemapper, true);
                    VarRemapper.ParamRemapper remapper = new VarRemapper.ParamRemapper(lambdaParameters, valueParamShift);
                    InlineResult lambdaResult = inliner.doInline(this.mv, remapper);
                    MethodInliner.this.result.addAllClassesToRemove(lambdaResult);
                    Method bridge = MethodInliner.this.typeMapper.mapSignature(ClosureCodegen.getInvokeFunction(info.getFunctionDescriptor())).getAsmMethod();
                    Method delegate = MethodInliner.this.typeMapper.mapSignature(info.getFunctionDescriptor()).getAsmMethod();
                    StackValue.onStack(delegate.getReturnType()).put(bridge.getReturnType(), this);
                    this.setInlining(false);
                } else if (InlineCodegenUtil.isLambdaConstructorCall(owner, name)) {
                    assert (this.invocation != null) : "<init> call not corresponds to new call" + owner + " " + name;
                    if (this.invocation.shouldRegenerate()) {
                        List<CapturedParamInfo> recaptured = this.invocation.getAllRecapturedParameters();
                        List<CapturedParamInfo> contextCaptured = MethodInliner.this.parameters.getCaptured();
                        for (CapturedParamInfo capturedParamInfo : recaptured) {
                            CapturedParamInfo result2 = null;
                            for (CapturedParamInfo info : contextCaptured) {
                                if (!info.getFieldName().equals(capturedParamInfo.getFieldName())) continue;
                                result2 = info;
                            }
                            if (result2 == null) {
                                throw new UnsupportedOperationException("Unsupported operation: could not transform non-inline lambda inside inlined one: " + owner + "." + name);
                            }
                            super.visitVarInsn(capturedParamInfo.getType().getOpcode(21), result2.getIndex());
                        }
                        super.visitMethodInsn(opcode, this.invocation.getNewLambdaType().getInternalName(), name, this.invocation.getNewConstructorDescriptor());
                        this.invocation = null;
                    } else {
                        super.visitMethodInsn(opcode, MethodInliner.this.changeOwnerForExternalPackage(owner, opcode), name, desc);
                    }
                } else {
                    super.visitMethodInsn(opcode, MethodInliner.this.changeOwnerForExternalPackage(owner, opcode), name, desc);
                }
            }
        };
        node.accept(inliner);
        return resultNode;
    }

    public void merge() {
    }

    @NotNull
    public MethodNode prepareNode(@NotNull MethodNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/MethodInliner", "prepareNode"));
        }
        final int capturedParamsSize = this.parameters.getCaptured().size();
        final int realParametersSize = this.parameters.getReal().size();
        Type[] types = Type.getArgumentTypes(node.desc);
        Type returnType = Type.getReturnType(node.desc);
        ArrayList<Type> capturedTypes = this.parameters.getCapturedTypes();
        Type[] allTypes = ArrayUtil.mergeArrays(types, capturedTypes.toArray(new Type[capturedTypes.size()]));
        node.instructions.resetLabels();
        MethodNode transformedNode = new MethodNode(node.access, node.name, Type.getMethodDescriptor(returnType, allTypes), node.signature, null){

            @Override
            public void visitVarInsn(int opcode, int var) {
                int newIndex = var < realParametersSize ? var : var + capturedParamsSize;
                super.visitVarInsn(opcode, newIndex);
            }

            @Override
            public void visitIincInsn(int var, int increment) {
                int newIndex = var < realParametersSize ? var : var + capturedParamsSize;
                super.visitIincInsn(newIndex, increment);
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                super.visitMaxs(maxStack, maxLocals + capturedParamsSize);
            }
        };
        node.accept(transformedNode);
        this.transformCaptured(transformedNode);
        MethodNode methodNode = transformedNode;
        if (methodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/MethodInliner", "prepareNode"));
        }
        return methodNode;
    }

    @NotNull
    protected MethodNode markPlacesForInlineAndRemoveInlinable(@NotNull MethodNode node) throws AnalyzerException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/MethodInliner", "markPlacesForInlineAndRemoveInlinable"));
        }
        node = this.prepareNode(node);
        Analyzer<SourceValue> analyzer = new Analyzer<SourceValue>(new SourceInterpreter());
        Frame<SourceValue>[] sources = analyzer.analyze("fake", node);
        AbstractInsnNode cur = node.instructions.getFirst();
        int index = 0;
        HashSet<LabelNode> deadLabels = new HashSet<LabelNode>();
        while (cur != null) {
            Frame<SourceValue> frame = sources[index];
            if (frame != null && cur.getType() == 5) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)cur;
                String owner = methodInsnNode.owner;
                String desc = methodInsnNode.desc;
                String name = methodInsnNode.name;
                int paramLength = Type.getArgumentTypes(desc).length + 1;
                if (InlineCodegenUtil.isInvokeOnLambda(owner, name)) {
                    AbstractInsnNode insnNode;
                    SourceValue sourceValue = frame.getStack(frame.getStackSize() - paramLength);
                    LambdaInfo lambdaInfo = null;
                    int varIndex = -1;
                    if (sourceValue.insns.size() == 1 && (insnNode = sourceValue.insns.iterator().next()).getType() == 2) {
                        assert (insnNode.getOpcode() == 25) : insnNode.toString();
                        varIndex = ((VarInsnNode)insnNode).var;
                        lambdaInfo = this.getLambda(varIndex);
                        if (lambdaInfo != null) {
                            node.instructions.remove(insnNode);
                        }
                    }
                    this.invokeCalls.add(new InvokeCall(varIndex, lambdaInfo));
                } else if (InlineCodegenUtil.isLambdaConstructorCall(owner, name)) {
                    HashMap<Integer, LambdaInfo> lambdaMapping = new HashMap<Integer, LambdaInfo>();
                    int paramStart = frame.getStackSize() - paramLength;
                    for (int i = 0; i < paramLength; ++i) {
                        int varIndex;
                        LambdaInfo lambdaInfo;
                        AbstractInsnNode insnNode;
                        SourceValue sourceValue = frame.getStack(paramStart + i);
                        if (sourceValue.insns.size() != 1 || (insnNode = sourceValue.insns.iterator().next()).getOpcode() != 25 || (lambdaInfo = this.getLambda(varIndex = ((VarInsnNode)insnNode).var)) == null) continue;
                        lambdaMapping.put(i, lambdaInfo);
                        node.instructions.remove(insnNode);
                    }
                    this.constructorInvocations.add(new ConstructorInvocation(owner, lambdaMapping, this.isSameModule, this.inliningContext.classRegeneration));
                }
            }
            AbstractInsnNode prevNode = cur;
            cur = cur.getNext();
            ++index;
            if (frame != null) continue;
            if (prevNode.getType() == 8) {
                deadLabels.add((LabelNode)prevNode);
                continue;
            }
            node.instructions.remove(prevNode);
        }
        List<TryCatchBlockNode> blocks = node.tryCatchBlocks;
        Iterator<TryCatchBlockNode> iterator2 = blocks.iterator();
        while (iterator2.hasNext()) {
            TryCatchBlockNode block = iterator2.next();
            if (!deadLabels.contains(block.start) || !deadLabels.contains(block.end)) continue;
            iterator2.remove();
        }
        MethodNode methodNode = node;
        if (methodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/MethodInliner", "markPlacesForInlineAndRemoveInlinable"));
        }
        return methodNode;
    }

    @Nullable
    public LambdaInfo getLambda(int index) {
        if (index < this.parameters.totalSize()) {
            return this.parameters.get(index).getLambda();
        }
        return null;
    }

    private static void removeClosureAssertions(MethodNode node) {
        AbstractInsnNode cur = node.instructions.getFirst();
        while (cur != null && cur.getNext() != null) {
            AbstractInsnNode next = cur.getNext();
            if (next.getType() == 5) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)next;
                if (methodInsnNode.name.equals("checkParameterIsNotNull") && methodInsnNode.owner.equals("kotlin/jvm/internal/Intrinsics")) {
                    AbstractInsnNode prev = cur.getPrevious();
                    assert (cur.getOpcode() == 18) : "checkParameterIsNotNull should go after LDC but " + cur;
                    assert (prev.getOpcode() == 25) : "checkParameterIsNotNull should be invoked on local var but " + prev;
                    node.instructions.remove(prev);
                    node.instructions.remove(cur);
                    cur = next.getNext();
                    node.instructions.remove(next);
                    next = cur;
                }
            }
            cur = next;
        }
    }

    private void transformCaptured(@NotNull MethodNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/codegen/inline/MethodInliner", "transformCaptured"));
        }
        if (this.lambdaType == null) {
            return;
        }
        for (AbstractInsnNode cur = node.instructions.getFirst(); cur != null; cur = cur.getNext()) {
            if (cur.getType() != 4) continue;
            FieldInsnNode fieldInsnNode = (FieldInsnNode)cur;
            if (this.lambdaFieldRemapper.canProcess(fieldInsnNode.owner, this.lambdaType.getInternalName())) {
                CapturedParamInfo result2 = this.lambdaFieldRemapper.findField(fieldInsnNode, this.parameters.getCaptured());
                if (result2 == null) {
                    throw new UnsupportedOperationException("Coudn't find field " + fieldInsnNode.owner + "." + fieldInsnNode.name + " (" + fieldInsnNode.desc + ") in captured vars of " + this.lambdaType);
                }
                if (result2.isSkipped()) continue;
                cur = this.lambdaFieldRemapper.doTransform(node, fieldInsnNode, result2);
                continue;
            }
            if (!this.lambdaFieldRemapper.shouldPatch(fieldInsnNode)) continue;
            cur = this.lambdaFieldRemapper.patch(fieldInsnNode, node);
        }
    }

    public static AbstractInsnNode getPreviousNoLabelNoLine(AbstractInsnNode cur) {
        AbstractInsnNode prev = cur.getPrevious();
        while (prev.getType() == 8 || prev.getType() == 15) {
            prev = prev.getPrevious();
        }
        return prev;
    }

    public static void putStackValuesIntoLocals(List<Type> directOrder, int shift, InstructionAdapter iv, String descriptor) {
        Type[] actualParams = Type.getArgumentTypes(descriptor);
        assert (actualParams.length == directOrder.size()) : "Number of expected and actual params should be equals!";
        int size = 0;
        for (Type next : directOrder) {
            size += next.getSize();
        }
        shift += size;
        int index = directOrder.size();
        for (Type next : Lists.reverse(directOrder)) {
            Type typeOnStack;
            shift -= next.getSize();
            if (!(typeOnStack = actualParams[--index]).equals(next)) {
                StackValue.onStack(typeOnStack).put(next, iv);
            }
            iv.store(shift, next);
        }
    }

    public String changeOwnerForExternalPackage(String type, int opcode) {
        if (this.isSameModule || (opcode & 0xB8) == 0) {
            return type;
        }
        int i = type.indexOf(45);
        if (i >= 0) {
            return type.substring(0, i);
        }
        return type;
    }
}

