/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.ClassReader;
import org.jetbrains.asm4.ClassVisitor;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.asm4.tree.AbstractInsnNode;
import org.jetbrains.asm4.tree.FieldInsnNode;
import org.jetbrains.asm4.tree.MethodNode;
import org.jetbrains.asm4.tree.VarInsnNode;
import org.jetbrains.jet.OutputFile;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClosureCodegen;
import org.jetbrains.jet.codegen.FieldInfo;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.ConstructorInvocation;
import org.jetbrains.jet.codegen.inline.InlineCodegenUtil;
import org.jetbrains.jet.codegen.inline.InlineResult;
import org.jetbrains.jet.codegen.inline.InliningContext;
import org.jetbrains.jet.codegen.inline.LambdaFieldRemapper;
import org.jetbrains.jet.codegen.inline.LambdaInfo;
import org.jetbrains.jet.codegen.inline.MethodInliner;
import org.jetbrains.jet.codegen.inline.Parameters;
import org.jetbrains.jet.codegen.inline.ParametersBuilder;
import org.jetbrains.jet.codegen.inline.RegeneratedLambdaFieldRemapper;
import org.jetbrains.jet.codegen.inline.RemappingClassBuilder;
import org.jetbrains.jet.codegen.inline.TypeRemapper;
import org.jetbrains.jet.codegen.inline.VarRemapper;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;

public class LambdaTransformer {
    protected final GenerationState state;
    protected final JetTypeMapper typeMapper;
    private final MethodNode constructor;
    private final MethodNode invoke;
    private final MethodNode bridge;
    private final InliningContext inliningContext;
    private final Type oldLambdaType;
    private final Type newLambdaType;
    private int classAccess;
    private String signature;
    private String superName;
    private String[] interfaces;
    private final boolean isSameModule;

    public LambdaTransformer(String lambdaInternalName, InliningContext inliningContext, boolean isSameModule, Type newLambdaType) {
        ClassReader reader;
        this.isSameModule = isSameModule;
        this.state = inliningContext.state;
        this.typeMapper = this.state.getTypeMapper();
        this.inliningContext = inliningContext;
        this.oldLambdaType = Type.getObjectType(lambdaInternalName);
        this.newLambdaType = newLambdaType;
        try {
            OutputFile outputFile = this.state.getFactory().get(lambdaInternalName + ".class");
            if (outputFile != null) {
                reader = new ClassReader(outputFile.asByteArray());
            } else {
                VirtualFile file = InlineCodegenUtil.findVirtualFile(this.state.getProject(), lambdaInternalName);
                if (file == null) {
                    throw new RuntimeException("Couldn't find virtual file for " + lambdaInternalName);
                }
                reader = new ClassReader(file.getInputStream());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.constructor = this.getMethodNode(reader, true, false);
        this.invoke = this.getMethodNode(reader, false, false);
        this.bridge = this.getMethodNode(reader, false, true);
    }

    private void buildInvokeParams(ParametersBuilder builder) {
        Type[] types;
        builder.addThis(this.oldLambdaType, false);
        for (Type type : types = Type.getArgumentTypes(this.invoke.desc)) {
            builder.addNextParameter(type, false, null);
        }
    }

    public InlineResult doTransform(ConstructorInvocation invocation, LambdaFieldRemapper parentRemapper) {
        ClassBuilder classBuilder = this.createClassBuilder();
        classBuilder.defineClass(null, 50, this.classAccess, this.newLambdaType.getInternalName(), this.signature, this.superName, this.interfaces);
        ParametersBuilder builder = ParametersBuilder.newBuilder();
        Parameters parameters = this.getLambdaParameters(builder, invocation);
        MethodVisitor invokeVisitor = LambdaTransformer.newMethod(classBuilder, this.invoke);
        RegeneratedLambdaFieldRemapper remapper = new RegeneratedLambdaFieldRemapper(this.oldLambdaType.getInternalName(), this.newLambdaType.getInternalName(), parameters, invocation.getCapturedLambdasToInline(), parentRemapper);
        MethodInliner inliner = new MethodInliner(this.invoke, parameters, this.inliningContext.subInline(this.inliningContext.nameGenerator.subGenerator("lambda")), this.oldLambdaType, remapper, this.isSameModule);
        InlineResult result2 = inliner.doInline(invokeVisitor, new VarRemapper.ParamRemapper(parameters, 0), remapper, false);
        invokeVisitor.visitMaxs(-1, -1);
        this.generateConstructorAndFields(classBuilder, builder, invocation);
        if (this.bridge != null) {
            MethodVisitor invokeBridge = LambdaTransformer.newMethod(classBuilder, this.bridge);
            this.bridge.accept(new MethodVisitor(262144, invokeBridge){

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    if (owner.equals(LambdaTransformer.this.oldLambdaType.getInternalName())) {
                        super.visitMethodInsn(opcode, LambdaTransformer.this.newLambdaType.getInternalName(), name, desc);
                    } else {
                        super.visitMethodInsn(opcode, owner, name, desc);
                    }
                }
            });
        }
        classBuilder.done();
        invocation.setNewLambdaType(this.newLambdaType);
        return result2;
    }

    private void generateConstructorAndFields(@NotNull ClassBuilder classBuilder, @NotNull ParametersBuilder builder, @NotNull ConstructorInvocation invocation) {
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilder", "org/jetbrains/jet/codegen/inline/LambdaTransformer", "generateConstructorAndFields"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/jet/codegen/inline/LambdaTransformer", "generateConstructorAndFields"));
        }
        if (invocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocation", "org/jetbrains/jet/codegen/inline/LambdaTransformer", "generateConstructorAndFields"));
        }
        List<CapturedParamInfo> infos = builder.buildCaptured();
        ArrayList<Pair<String, Type>> newConstructorSignature = new ArrayList<Pair<String, Type>>();
        for (CapturedParamInfo capturedParamInfo : infos) {
            if (capturedParamInfo.getLambda() != null) continue;
            newConstructorSignature.add(new Pair<String, Type>(capturedParamInfo.getFieldName(), capturedParamInfo.getType()));
        }
        List<FieldInfo> fields2 = AsmUtil.transformCapturedParams(newConstructorSignature, this.newLambdaType);
        AsmUtil.genClosureFields(newConstructorSignature, classBuilder);
        Method newConstructor = ClosureCodegen.generateConstructor(classBuilder, fields2, null, Type.getObjectType(this.superName), this.state, 0);
        invocation.setNewConstructorDescriptor(newConstructor.getDescriptor());
    }

    private Parameters getLambdaParameters(ParametersBuilder builder, ConstructorInvocation invocation) {
        this.buildInvokeParams(builder);
        LambdaTransformer.extractParametersMapping(this.constructor, builder, invocation);
        return builder.buildParameters();
    }

    private ClassBuilder createClassBuilder() {
        return new RemappingClassBuilder(this.state.getFactory().forLambdaInlining(this.newLambdaType, this.inliningContext.call.getCallElement().getContainingFile()), new TypeRemapper(this.inliningContext.typeMapping));
    }

    private static MethodVisitor newMethod(ClassBuilder builder, MethodNode original) {
        return builder.newMethod(null, original.access, original.name, original.desc, original.signature, null);
    }

    private static void extractParametersMapping(MethodNode constructor, ParametersBuilder builder, ConstructorInvocation invocation) {
        Map<Integer, LambdaInfo> indexToLambda = invocation.getLambdasToInline();
        AbstractInsnNode cur = constructor.instructions.getFirst();
        ArrayList<LambdaInfo> capturedLambdas = new ArrayList<LambdaInfo>();
        for (cur = cur.getNext(); cur != null; cur = cur.getNext()) {
            if (cur.getType() != 4) continue;
            FieldInsnNode fieldNode = (FieldInsnNode)cur;
            CapturedParamInfo info = builder.addCapturedParam(fieldNode.name, Type.getType(fieldNode.desc), false, null);
            assert (fieldNode.getPrevious() instanceof VarInsnNode) : "Previous instruction should be VarInsnNode but was " + fieldNode.getPrevious();
            VarInsnNode previous = (VarInsnNode)fieldNode.getPrevious();
            int varIndex = previous.var;
            LambdaInfo lambdaInfo = indexToLambda.get(varIndex);
            if (lambdaInfo == null) continue;
            info.setLambda(lambdaInfo);
            capturedLambdas.add(lambdaInfo);
        }
        HashMap<String, LambdaInfo> capturedLambdasToInline = new HashMap<String, LambdaInfo>();
        ArrayList<CapturedParamInfo> allRecapturedParameters = new ArrayList<CapturedParamInfo>();
        for (LambdaInfo info : capturedLambdas) {
            for (CapturedParamInfo var : info.getCapturedVars()) {
                CapturedParamInfo recapturedParamInfo = builder.addCapturedParam(LambdaTransformer.getNewFieldName(var.getFieldName()), var.getType(), true, var);
                recapturedParamInfo.setRecapturedFrom(info);
                allRecapturedParameters.add(var);
            }
            capturedLambdasToInline.put(info.getLambdaClassType().getInternalName(), info);
        }
        invocation.setAllRecapturedParameters(allRecapturedParameters);
        invocation.setCapturedLambdasToInline(capturedLambdasToInline);
    }

    @Nullable
    public MethodNode getMethodNode(@NotNull ClassReader reader, final boolean findConstructor, final boolean findBridge) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "org/jetbrains/jet/codegen/inline/LambdaTransformer", "getMethodNode"));
        }
        final MethodNode[] methodNode = new MethodNode[1];
        reader.accept(new ClassVisitor(262144){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                LambdaTransformer.this.classAccess = access;
                LambdaTransformer.this.signature = signature;
                LambdaTransformer.this.superName = superName;
                LambdaTransformer.access$502(LambdaTransformer.this, interfaces);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                boolean isBridge;
                boolean isConstructorMethod = "<init>".equals(name);
                boolean bl = isBridge = (access & 0x40) != 0;
                if (findConstructor && isConstructorMethod || !findConstructor && !isConstructorMethod && isBridge == findBridge) {
                    assert (methodNode[0] == null) : "Wrong lambda/sam structure: " + methodNode[0].name + " conflicts with " + name;
                    methodNode[0] = new MethodNode(access, name, desc, signature, exceptions);
                    return methodNode[0];
                }
                return null;
            }
        }, 6);
        if (methodNode[0] == null && !findBridge) {
            throw new RuntimeException("Couldn't find operation method of lambda/sam class " + this.oldLambdaType.getInternalName() + ": findConstructor = " + findConstructor);
        }
        return methodNode[0];
    }

    public static String getNewFieldName(String oldName) {
        if (oldName.equals("this$0")) {
            return oldName;
        }
        return oldName + "$inlined";
    }

    static /* synthetic */ String[] access$502(LambdaTransformer x0, String[] x1) {
        x0.interfaces = x1;
        return x1;
    }
}

