/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.TagBindingWrapper;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

abstract class AbstractCollectionBinding
implements Binding {
    private Map<Class, Binding> myElementBindings;
    private final Class myElementType;
    private final String myTagName;
    @Nullable
    protected final Accessor myAccessor;
    private final AbstractCollection myAnnotation;

    public AbstractCollectionBinding(Class elementType, String tagName, @Nullable Accessor accessor) {
        this.myElementType = elementType;
        this.myTagName = tagName;
        this.myAccessor = accessor;
        this.myAnnotation = accessor == null ? null : XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), AbstractCollection.class);
    }

    @Override
    public void init() {
        if (this.myAnnotation != null && !this.myAnnotation.surroundWithTag()) {
            if (this.myAnnotation.elementTag() == null) {
                throw new XmlSerializationException("If surround with tag is turned off, element tag must be specified for: " + this.myAccessor);
            }
            if (this.myAnnotation.elementTag().equals("option")) {
                for (Binding binding : this.getElementBindings().values()) {
                    if (!(binding instanceof TagBindingWrapper)) continue;
                    throw new XmlSerializationException("If surround with tag is turned off, element tag must be specified for: " + this.myAccessor);
                }
            }
        }
    }

    private synchronized Map<Class, Binding> getElementBindings() {
        if (this.myElementBindings == null) {
            this.myElementBindings = new HashMap<Class, Binding>();
            this.myElementBindings.put(this.myElementType, this.getBinding(this.myElementType));
            if (this.myAnnotation != null) {
                for (Class aClass : this.myAnnotation.elementTypes()) {
                    this.myElementBindings.put(aClass, this.getBinding(aClass));
                }
            }
        }
        return this.myElementBindings;
    }

    protected Binding getElementBinding(Object node) {
        for (Binding binding : this.getElementBindings().values()) {
            if (!binding.isBoundTo(node)) continue;
            return binding;
        }
        throw new XmlSerializationException("Node " + node + " is not bound");
    }

    private Binding getBinding(Class type) {
        Binding binding = XmlSerializerImpl.getBinding(type);
        return binding.getBoundNodeType().isAssignableFrom(Element.class) ? binding : this.createElementTagWrapper(binding);
    }

    private Binding createElementTagWrapper(Binding elementBinding) {
        if (this.myAnnotation == null) {
            return new TagBindingWrapper(elementBinding, "option", "value");
        }
        return new TagBindingWrapper(elementBinding, this.myAnnotation.elementTag() != null ? this.myAnnotation.elementTag() : "option", this.myAnnotation.elementValueAttribute() != null ? this.myAnnotation.elementValueAttribute() : "value");
    }

    abstract Object processResult(Collection var1, Object var2);

    @Override
    public Object deserialize(Object o, Object ... nodes) {
        Collection<Object> result2;
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserialize"));
        }
        if (this.getTagName(o) != null) {
            Content[] childElements;
            assert (nodes.length == 1);
            Element e = (Element)nodes[0];
            result2 = this.createCollection(e.getName());
            for (Content n : childElements = JDOMUtil.getContent(e)) {
                if (XmlSerializerImpl.isIgnoredNode(n)) continue;
                Binding elementBinding = this.getElementBinding(n);
                Object v = elementBinding.deserialize(o, n);
                result2.add(v);
            }
        } else {
            result2 = new ArrayList();
            for (Object node : nodes) {
                if (XmlSerializerImpl.isIgnoredNode(node)) continue;
                Binding elementBinding = this.getElementBinding(node);
                Object v = elementBinding.deserialize(o, node);
                result2.add(v);
            }
        }
        return this.processResult(result2, o);
    }

    protected Collection createCollection(String tagName) {
        return new ArrayList();
    }

    @Override
    public boolean isBoundTo(Object node) {
        if (!(node instanceof Element)) {
            return false;
        }
        String tagName = this.getTagName(node);
        if (tagName == null) {
            for (Binding binding : this.getElementBindings().values()) {
                if (!binding.isBoundTo(node)) continue;
                return true;
            }
        }
        return ((Element)node).getName().equals(tagName);
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }

    public Class getElementType() {
        return this.myElementType;
    }

    @Nullable
    private String getTagName(Object target) {
        if (this.myAnnotation == null || this.myAnnotation.surroundWithTag()) {
            return this.getCollectionTagName(target);
        }
        return null;
    }

    protected String getCollectionTagName(Object target) {
        return this.myTagName;
    }
}

