/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionBase;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceExpressionImpl
extends PsiReferenceExpressionBase
implements PsiMethodReferenceExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiMethodReferenceExpressionImpl");

    public PsiMethodReferenceExpressionImpl() {
        super(JavaElementType.METHOD_REF_EXPRESSION);
    }

    private static boolean arrayCreationSignature(MethodSignature signature) {
        return PsiMethodReferenceExpressionImpl.arrayCompatibleSignature(signature.getParameterTypes(), (Function<T[], PsiType>)new Function<PsiType[], PsiType>(){

            @Override
            public PsiType fun(PsiType[] types) {
                return types[0];
            }
        });
    }

    public static <T> boolean arrayCompatibleSignature(T[] paramTypes, Function<T[], PsiType> fun) {
        PsiType paramType;
        return paramTypes.length == 1 && (paramType = fun.fun(paramTypes)) != null && TypeConversionUtil.isAssignable(PsiType.INT, paramType);
    }

    @Override
    public PsiTypeElement getQualifierType() {
        PsiElement qualifier = this.getQualifier();
        return qualifier instanceof PsiTypeElement ? (PsiTypeElement)qualifier : null;
    }

    @Override
    @Nullable
    public PsiType getFunctionalInterfaceType() {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(LambdaUtil.getFunctionalInterfaceType(this, true));
    }

    @Override
    public boolean isExact() {
        return this.getPotentiallyApplicableMember() != null;
    }

    @Override
    public boolean isPotentiallyCompatible(final PsiType functionalInterfaceType) {
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        if (interfaceMethod == null) {
            return false;
        }
        MethodReferenceResolver resolver = new MethodReferenceResolver(){

            @Override
            protected PsiConflictResolver createResolver(PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMethod interfaceMethod, MethodSignature signature) {
                return DuplicateConflictResolver.INSTANCE;
            }

            @Override
            protected PsiType getInterfaceType(PsiMethodReferenceExpression reference) {
                return functionalInterfaceType;
            }
        };
        ResolveResult[] result2 = resolver.resolve(this, false);
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this);
        int interfaceArity = interfaceMethod.getParameterList().getParametersCount();
        for (ResolveResult resolveResult : result2) {
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiMethod) {
                boolean isStatic = ((PsiMethod)element).hasModifierProperty("static");
                if (qualifierResolveResult.isReferenceTypeQualified() && this.getReferenceNameElement() instanceof PsiIdentifier) {
                    int parametersCount = ((PsiMethod)element).getParameterList().getParametersCount();
                    if (parametersCount == interfaceArity && isStatic) {
                        return true;
                    }
                    if (parametersCount == interfaceArity - 1 && !isStatic) {
                        return true;
                    }
                    if (!((PsiMethod)element).isVarArgs()) continue;
                    return true;
                }
                if (isStatic) continue;
                return true;
            }
            if (!(element instanceof PsiClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PsiMember getPotentiallyApplicableMember() {
        return CachedValuesManager.getCachedValue(this, new CachedValueProvider<PsiMember>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<PsiMember> compute() {
                return CachedValueProvider.Result.createSingleDependency(PsiMethodReferenceExpressionImpl.this.getPotentiallyApplicableMemberInternal(), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
            }
        });
    }

    private PsiMember getPotentiallyApplicableMemberInternal() {
        PsiElement element = this.getReferenceNameElement();
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this);
        PsiClass containingClass = qualifierResolveResult.getContainingClass();
        if (containingClass != null) {
            PsiMethod[] methods = null;
            if (element instanceof PsiIdentifier) {
                methods = containingClass.findMethodsByName(element.getText(), false);
            } else if (this.isConstructor()) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory(this.getProject());
                PsiClass arrayClass = factory.getArrayClass(PsiUtil.getLanguageLevel(this));
                if (arrayClass == containingClass) {
                    PsiType componentType = qualifierResolveResult.getSubstitutor().substitute(arrayClass.getTypeParameters()[0]);
                    LOG.assertTrue(componentType != null, qualifierResolveResult.getSubstitutor());
                    methods = new PsiMethod[]{factory.createMethodFromText("public " + componentType.createArrayType().getCanonicalText() + " __array__(int i) {return null;}", this)};
                } else {
                    methods = containingClass.getConstructors();
                }
            }
            if (methods != null) {
                PsiMethod psiMethod = null;
                if (methods.length > 0) {
                    for (PsiMethod method : methods) {
                        if (!PsiUtil.isAccessible(method, this, null)) continue;
                        if (psiMethod != null) {
                            return null;
                        }
                        psiMethod = method;
                    }
                    if (psiMethod == null) {
                        return null;
                    }
                    if (psiMethod.isVarArgs()) {
                        return null;
                    }
                    if (psiMethod.getTypeParameters().length > 0) {
                        PsiReferenceParameterList parameterList = this.getParameterList();
                        return parameterList != null && parameterList.getTypeParameterElements().length > 0 ? psiMethod : null;
                    }
                }
                if (containingClass.isPhysical() && containingClass.hasTypeParameters()) {
                    PsiElement qualifier = this.getQualifier();
                    if (qualifier instanceof PsiTypeElement) {
                        PsiReferenceParameterList parameterList;
                        PsiJavaCodeReferenceElement referenceElement = ((PsiTypeElement)qualifier).getInnermostComponentReferenceElement();
                        if (referenceElement != null && ((parameterList = referenceElement.getParameterList()) == null || parameterList.getTypeParameterElements().length == 0)) {
                            return null;
                        }
                    } else if (qualifier instanceof PsiReferenceExpression) {
                        PsiReferenceParameterList parameterList;
                        PsiReferenceExpression expression = (PsiReferenceExpression)qualifier;
                        if (qualifierResolveResult.isReferenceTypeQualified() && ((parameterList = expression.getParameterList()) == null || parameterList.getTypeParameterElements().length == 0)) {
                            return null;
                        }
                    }
                }
                return psiMethod == null ? containingClass : psiMethod;
            }
        }
        return null;
    }

    @Override
    public PsiExpression getQualifierExpression() {
        PsiElement qualifier = this.getQualifier();
        return qualifier instanceof PsiExpression ? (PsiExpression)qualifier : null;
    }

    @Override
    public PsiType getType() {
        return new PsiMethodReferenceType(this);
    }

    @Override
    public PsiElement getReferenceNameElement() {
        PsiElement element = this.getLastChild();
        return element instanceof PsiIdentifier || PsiUtil.isJavaToken(element, JavaTokenType.NEW_KEYWORD) ? element : null;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "processVariants"));
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)ElementClassFilter.METHOD, processor);
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    @Override
    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        if (newQualifier == null) {
            super.setQualifierExpression(newQualifier);
            return;
        }
        PsiExpression expression = this.getQualifierExpression();
        if (expression != null) {
            expression.replace(newQualifier);
        } else {
            PsiElement qualifier = this.getQualifier();
            if (qualifier != null) {
                qualifier.replace(newQualifier);
            }
        }
    }

    @Override
    public int getChildRole(ASTNode child) {
        IElementType elType = child.getElementType();
        if (elType == JavaTokenType.DOUBLE_COLON) {
            return 253;
        }
        if (elType == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        if (elType == JavaElementType.REFERENCE_EXPRESSION) {
            return 119;
        }
        return 64;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        boolean valid;
        FileElement fileElement = SharedImplUtil.findFileElement(this);
        if (fileElement == null) {
            LOG.error("fileElement == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "multiResolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiManagerEx manager = fileElement.getManager();
        if (manager == null) {
            LOG.error("getManager() == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "multiResolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiFile file = SharedImplUtil.getContainingFile(fileElement);
        boolean bl = valid = file != null && file.isValid();
        if (!valid) {
            LOG.error("invalid!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "multiResolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        MethodReferenceResolver resolver = new MethodReferenceResolver();
        Map<PsiMethodReferenceExpression, PsiType> map = PsiMethodReferenceUtil.ourRefs.get();
        if (map != null && map.containsKey(this)) {
            JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])resolver.resolve(this, incompleteCode);
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "multiResolve"));
            }
            return javaResolveResultArray;
        }
        ResolveResult[] results = ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, resolver, true, incompleteCode, file);
        JavaResolveResult[] javaResolveResultArray = results.length == 0 ? JavaResolveResult.EMPTY_ARRAY : (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "multiResolve"));
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiElement getQualifier() {
        PsiElement element = this.getFirstChild();
        return element instanceof PsiExpression || element instanceof PsiTypeElement ? element : null;
    }

    @Override
    public TextRange getRangeInElement() {
        PsiElement element = this.getReferenceNameElement();
        if (element != null) {
            int offsetInParent = element.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + element.getTextLength());
        }
        PsiElement colons = this.findPsiChildByType(JavaTokenType.DOUBLE_COLON);
        if (colons != null) {
            int offsetInParent = colons.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + colons.getTextLength());
        }
        LOG.error(this.getText());
        return null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement instanceof PsiIdentifier ? !nameElement.getText().equals(method.getName()) : PsiUtil.isJavaToken(nameElement, JavaTokenType.NEW_KEYWORD) && !method.isConstructor()) {
            return false;
        }
        return element.getManager().areElementsEquivalent(element, this.resolve());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethodReferenceExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "bindToElement"));
        }
        return this;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            oldIdentifier = this.findChildByRoleAsPsiElement(119);
        }
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        String oldRefName = oldIdentifier.getText();
        if ("this".equals(oldRefName) || "super".equals(oldRefName) || "new".equals(oldRefName) || Comparing.strEqual(oldRefName, newElementName)) {
            return this;
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public boolean isConstructor() {
        PsiElement element = this.getReferenceNameElement();
        return element instanceof PsiKeyword && "new".equals(element.getText());
    }

    @Override
    public String toString() {
        return "PsiMethodReferenceExpression:" + this.getText();
    }

    private boolean isLocatedInStaticContext(PsiClass containingClass) {
        PsiClass gContainingClass = containingClass.getContainingClass();
        if (gContainingClass == null || !containingClass.hasModifierProperty("static")) {
            PsiClass aClass = null;
            if (PsiTreeUtil.isAncestor(gContainingClass != null ? gContainingClass : containingClass, this, false)) {
                PsiClass psiClass = aClass = gContainingClass != null ? gContainingClass : containingClass;
            }
            if (PsiUtil.getEnclosingStaticElement(this, aClass) != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAcceptable(PsiType left) {
        JavaResolveResult result2;
        if (left instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)left).getConjuncts()) {
                if (!this.isAcceptable(conjunct)) continue;
                return true;
            }
            return false;
        }
        if (!this.isPotentiallyCompatible(left = FunctionalInterfaceParameterizationUtil.getGroundTargetType(left))) {
            return false;
        }
        PsiExpressionList argsList = PsiTreeUtil.getParentOfType((PsiElement)this, PsiExpressionList.class);
        if (MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argsList) && !this.isExact()) {
            return true;
        }
        Map<PsiMethodReferenceExpression, PsiType> map = PsiMethodReferenceUtil.ourRefs.get();
        if (map == null) {
            map = new HashMap<PsiMethodReferenceExpression, PsiType>();
            PsiMethodReferenceUtil.ourRefs.set(map);
        }
        try {
            if (map.put(this, left) != null) {
                boolean conjunct = false;
                return conjunct;
            }
            result2 = this.advancedResolve(false);
        }
        finally {
            map.remove(this);
        }
        PsiElement resolve2 = result2.getElement();
        if (resolve2 == null) {
            return false;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(left);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (interfaceMethod != null) {
            PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(left);
            LOG.assertTrue(interfaceReturnType != null);
            if (interfaceReturnType == PsiType.VOID) {
                return true;
            }
            PsiSubstitutor subst = result2.getSubstitutor();
            PsiType methodReturnType = null;
            PsiClass containingClass = null;
            if (resolve2 instanceof PsiMethod) {
                containingClass = ((PsiMethod)resolve2).getContainingClass();
                PsiType returnType = PsiTypesUtil.patchMethodGetClassReturnType(this, this, (PsiMethod)resolve2, null, PsiUtil.getLanguageLevel(this));
                if (returnType == null) {
                    returnType = ((PsiMethod)resolve2).getReturnType();
                }
                if (returnType == PsiType.VOID) {
                    return false;
                }
                methodReturnType = subst.substitute(returnType);
            } else if (resolve2 instanceof PsiClass) {
                PsiTypeParameter[] typeParameters;
                if (resolve2 == JavaPsiFacade.getElementFactory(resolve2.getProject()).getArrayClass(PsiUtil.getLanguageLevel(resolve2)) && (typeParameters = ((PsiClass)resolve2).getTypeParameters()).length == 1) {
                    PsiType arrayComponentType = subst.substitute(typeParameters[0]);
                    if (arrayComponentType == null) {
                        return false;
                    }
                    methodReturnType = arrayComponentType.createArrayType();
                }
                containingClass = (PsiClass)resolve2;
            }
            if (methodReturnType == null) {
                if (containingClass == null) {
                    return false;
                }
                methodReturnType = JavaPsiFacade.getElementFactory(this.getProject()).createType(containingClass, subst);
            }
            return TypeConversionUtil.isAssignable(interfaceReturnType, methodReturnType, false);
        }
        return false;
    }

    private class MethodReferenceResolver
    implements ResolveCache.PolyVariantResolver<PsiMethodReferenceExpression> {
        private MethodReferenceResolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(final @NotNull PsiMethodReferenceExpression reference, boolean incompleteCode) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver", "resolve"));
            }
            final PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(reference);
            final PsiClass containingClass = qualifierResolveResult.getContainingClass();
            PsiSubstitutor substitutor = qualifierResolveResult.getSubstitutor();
            if (containingClass != null) {
                PsiElement element = PsiMethodReferenceExpressionImpl.this.getReferenceNameElement();
                boolean isConstructor = PsiMethodReferenceExpressionImpl.this.isConstructor();
                if (element instanceof PsiIdentifier || isConstructor) {
                    if (isConstructor && (containingClass.isEnum() || containingClass.hasModifierProperty("abstract"))) {
                        if (JavaResolveResult.EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver", "resolve"));
                        }
                        return JavaResolveResult.EMPTY_ARRAY;
                    }
                    PsiType functionalInterfaceType = this.getInterfaceType(reference);
                    PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
                    final PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
                    PsiSubstitutor functionalInterfaceSubstitutor = interfaceMethod != null ? LambdaUtil.getSubstitutor(interfaceMethod, resolveResult) : null;
                    final MethodSignature signature = interfaceMethod != null ? interfaceMethod.getSignature(functionalInterfaceSubstitutor) : null;
                    final PsiType interfaceMethodReturnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
                    if (isConstructor && interfaceMethod != null && containingClass.getConstructors().length == 0) {
                        ResolveResult[] resolveResultArray;
                        boolean isArray;
                        PsiClassType returnType = this.composeReturnType(containingClass, substitutor);
                        InferenceSession session = new InferenceSession(containingClass.getTypeParameters(), substitutor, PsiMethodReferenceExpressionImpl.this.getManager(), null);
                        if (!session.isProperType(returnType) || !session.isProperType(interfaceMethodReturnType)) {
                            session.registerConstraints(returnType, interfaceMethodReturnType);
                            substitutor = session.infer();
                        }
                        ClassCandidateInfo candidateInfo = null;
                        boolean bl = isArray = containingClass == JavaPsiFacade.getElementFactory(PsiMethodReferenceExpressionImpl.this.getProject()).getArrayClass(PsiUtil.getLanguageLevel(containingClass));
                        if (!isArray && (containingClass.getContainingClass() == null || !PsiMethodReferenceExpressionImpl.this.isLocatedInStaticContext(containingClass)) && signature.getParameterTypes().length == 0 || isArray && PsiMethodReferenceExpressionImpl.arrayCreationSignature(signature)) {
                            candidateInfo = new ClassCandidateInfo(containingClass, substitutor);
                        }
                        if (candidateInfo == null) {
                            resolveResultArray = JavaResolveResult.EMPTY_ARRAY;
                        } else {
                            JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[1];
                            resolveResultArray = javaResolveResultArray;
                            javaResolveResultArray[0] = candidateInfo;
                        }
                        if (resolveResultArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver", "resolve"));
                        }
                        return resolveResultArray;
                    }
                    PsiConflictResolver conflictResolver = this.createResolver(qualifierResolveResult, interfaceMethod, signature);
                    MethodCandidatesProcessor processor = new MethodCandidatesProcessor(reference, PsiMethodReferenceExpressionImpl.this.getContainingFile(), new PsiConflictResolver[]{conflictResolver}, new SmartList()){

                        @Override
                        protected MethodCandidateInfo createCandidateInfo(final PsiMethod method, final PsiSubstitutor substitutor, boolean staticProblem, boolean accessible) {
                            PsiExpressionList argumentList = this.getArgumentList();
                            PsiType[] typeParameters = reference.getTypeParameters();
                            return new MethodCandidateInfo(method, substitutor, !accessible, staticProblem, argumentList, this.myCurrentFileContext, argumentList != null ? argumentList.getExpressionTypes() : null, (PsiType[])(typeParameters.length > 0 ? typeParameters : null), this.getLanguageLevel()){

                                @Override
                                @NotNull
                                public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
                                    if (policy == null) {
                                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver$1$1", "inferTypeArguments"));
                                    }
                                    PsiSubstitutor psiSubstitutor = this.inferTypeArguments(false);
                                    if (psiSubstitutor == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver$1$1", "inferTypeArguments"));
                                    }
                                    return psiSubstitutor;
                                }

                                public PsiSubstitutor inferTypeArguments(boolean varargs) {
                                    if (interfaceMethod == null) {
                                        return substitutor;
                                    }
                                    PsiSubstitutor qualifierResultSubstitutor = qualifierResolveResult.getSubstitutor();
                                    InferenceSession session = new InferenceSession(method.getTypeParameters(), substitutor, PsiMethodReferenceExpressionImpl.this.getManager(), reference);
                                    Pair<PsiMethod, PsiSubstitutor> methodSubstitutorPair = MethodCandidateInfo.getCurrentMethod(reference.getParent());
                                    if (methodSubstitutorPair != null) {
                                        session.initBounds(((PsiMethod)methodSubstitutorPair.first).getTypeParameters());
                                    }
                                    PsiParameter[] functionalMethodParameters = interfaceMethod.getParameterList().getParameters();
                                    PsiParameter[] parameters = method.getParameterList().getParameters();
                                    boolean isStatic = method.hasModifierProperty("static");
                                    if (parameters.length == functionalMethodParameters.length && !varargs || isStatic && varargs) {
                                        if (method.isConstructor() && PsiUtil.isRawSubstitutor(containingClass, qualifierResultSubstitutor)) {
                                            session.initBounds(containingClass.getTypeParameters());
                                        }
                                        for (int i = 0; i < functionalMethodParameters.length; ++i) {
                                            PsiType pType = signature.getParameterTypes()[i];
                                            session.addConstraint(new TypeCompatibilityConstraint(this.getParameterType(parameters, i, varargs), pType));
                                        }
                                    } else if (parameters.length + 1 == functionalMethodParameters.length && !varargs || !isStatic && varargs && functionalMethodParameters.length > 0) {
                                        PsiClass aClass = qualifierResolveResult.getContainingClass();
                                        session.initBounds(aClass.getTypeParameters());
                                        PsiType pType = signature.getParameterTypes()[0];
                                        PsiSubstitutor psiSubstitutor = qualifierResultSubstitutor;
                                        if (PsiUtil.isRawSubstitutor(containingClass, qualifierResultSubstitutor)) {
                                            PsiSubstitutor receiverSubstitutor;
                                            PsiClassType.ClassResolveResult pResult = PsiUtil.resolveGenericsClassInType(pType);
                                            PsiClass pClass = pResult.getElement();
                                            PsiSubstitutor psiSubstitutor2 = receiverSubstitutor = pClass != null ? TypeConversionUtil.getClassSubstitutor(containingClass, pClass, pResult.getSubstitutor()) : null;
                                            if (receiverSubstitutor != null) {
                                                if (!method.hasTypeParameters() && signature.getParameterTypes().length == 1) {
                                                    return receiverSubstitutor;
                                                }
                                                psiSubstitutor = receiverSubstitutor;
                                            }
                                        }
                                        PsiClassType qType = JavaPsiFacade.getElementFactory(PsiMethodReferenceExpressionImpl.this.getProject()).createType(containingClass, psiSubstitutor);
                                        session.addConstraint(new TypeCompatibilityConstraint(qType, pType));
                                        for (int i = 0; i < signature.getParameterTypes().length - 1; ++i) {
                                            PsiType interfaceParamType = signature.getParameterTypes()[i + 1];
                                            session.addConstraint(new TypeCompatibilityConstraint(this.getParameterType(parameters, i, varargs), interfaceParamType));
                                        }
                                    }
                                    if (!session.repeatInferencePhases(false)) {
                                        if (method.isVarArgs() && !varargs) {
                                            return this.inferTypeArguments(true);
                                        }
                                        return substitutor;
                                    }
                                    if (interfaceMethodReturnType != PsiType.VOID) {
                                        PsiType returnType;
                                        PsiType psiType = returnType = method.isConstructor() ? MethodReferenceResolver.this.composeReturnType(containingClass, substitutor) : method.getReturnType();
                                        if (returnType != null) {
                                            session.registerConstraints(returnType, interfaceMethodReturnType);
                                        }
                                    }
                                    return session.infer(parameters, null, null);
                                }

                                private PsiType getParameterType(PsiParameter[] parameters, int i, boolean varargs) {
                                    if (varargs && i >= parameters.length - 1) {
                                        PsiType type = parameters[parameters.length - 1].getType();
                                        LOG.assertTrue(type instanceof PsiEllipsisType);
                                        return ((PsiEllipsisType)type).getComponentType();
                                    }
                                    return parameters[i].getType();
                                }
                            };
                        }
                    };
                    processor.setIsConstructor(isConstructor);
                    processor.setName(isConstructor ? containingClass.getName() : element.getText());
                    PsiExpression expression = PsiMethodReferenceExpressionImpl.this.getQualifierExpression();
                    if (expression == null || !(expression.getType() instanceof PsiArrayType)) {
                        processor.setAccessClass(containingClass);
                    }
                    if (qualifierResolveResult.isReferenceTypeQualified() && PsiMethodReferenceExpressionImpl.this.isLocatedInStaticContext(containingClass)) {
                        processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                    }
                    ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor);
                    containingClass.processDeclarations(processor, state, reference, reference);
                    ResolveResult[] resolveResultArray = processor.getResult();
                    if (resolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver", "resolve"));
                    }
                    return resolveResultArray;
                }
            }
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver", "resolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }

        protected PsiType getInterfaceType(PsiMethodReferenceExpression reference) {
            PsiType functionalInterfaceType = null;
            Map<PsiMethodReferenceExpression, PsiType> map = PsiMethodReferenceUtil.ourRefs.get();
            if (map != null) {
                functionalInterfaceType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(map.get(reference));
            }
            if (functionalInterfaceType == null) {
                functionalInterfaceType = reference.getFunctionalInterfaceType();
            }
            return functionalInterfaceType;
        }

        protected PsiConflictResolver createResolver(PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMethod interfaceMethod, MethodSignature signature) {
            return new MethodReferenceConflictResolver(qualifierResolveResult, signature, interfaceMethod != null && interfaceMethod.isVarArgs());
        }

        private PsiClassType composeReturnType(PsiClass containingClass, PsiSubstitutor substitutor) {
            boolean isRawSubst = PsiUtil.isRawSubstitutor(containingClass, substitutor);
            return JavaPsiFacade.getElementFactory(containingClass.getProject()).createType(containingClass, isRawSubst ? PsiSubstitutor.EMPTY : substitutor);
        }

        private class MethodReferenceConflictResolver
        extends JavaMethodsConflictResolver {
            private final MethodSignature mySignature;
            private final PsiMethodReferenceUtil.QualifierResolveResult myQualifierResolveResult;
            private final boolean myFunctionalMethodVarArgs;

            private MethodReferenceConflictResolver(PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, @Nullable MethodSignature signature, boolean varArgs) {
                super(PsiMethodReferenceExpressionImpl.this, signature != null ? signature.getParameterTypes() : PsiType.EMPTY_ARRAY, PsiUtil.getLanguageLevel(PsiMethodReferenceExpressionImpl.this));
                this.myQualifierResolveResult = qualifierResolveResult;
                this.myFunctionalMethodVarArgs = varArgs;
                this.mySignature = signature;
            }

            @Override
            @Nullable
            public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
                if (conflicts == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver$MethodReferenceConflictResolver", "resolveConflict"));
                }
                return this.resolveConflict(conflicts, false);
            }

            public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts, boolean varargs) {
                if (conflicts == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver$MethodReferenceConflictResolver", "resolveConflict"));
                }
                if (this.mySignature == null) {
                    return null;
                }
                this.checkSameSignatures(conflicts);
                MethodReferenceConflictResolver.checkAccessStaticLevels(conflicts, true);
                PsiType[] parameterTypes = this.mySignature.getParameterTypes();
                boolean hasReceiver = PsiMethodReferenceUtil.hasReceiver(parameterTypes, this.myQualifierResolveResult, PsiMethodReferenceExpressionImpl.this);
                ArrayList<CandidateInfo> firstCandidates = new ArrayList<CandidateInfo>();
                ArrayList<CandidateInfo> secondCandidates = new ArrayList<CandidateInfo>();
                for (CandidateInfo conflict : conflicts) {
                    PsiMethod psiMethod;
                    if (!(conflict instanceof MethodCandidateInfo) || (psiMethod = ((MethodCandidateInfo)conflict).getElement()) == null) continue;
                    PsiSubstitutor substitutor = conflict.getSubstitutor();
                    PsiType[] signatureParameterTypes2 = psiMethod.getSignature(substitutor).getParameterTypes();
                    if (varargs && (!psiMethod.isVarArgs() || this.myFunctionalMethodVarArgs)) continue;
                    if ((varargs || parameterTypes.length == signatureParameterTypes2.length) && this.isCorrectAssignment(signatureParameterTypes2, parameterTypes, substitutor, varargs, 0)) {
                        firstCandidates.add(conflict);
                    }
                    if (!hasReceiver || !varargs && parameterTypes.length != signatureParameterTypes2.length + 1 || !this.isCorrectAssignment(signatureParameterTypes2, parameterTypes, substitutor, varargs, 1)) continue;
                    secondCandidates.add(conflict);
                }
                if (this.myQualifierResolveResult.isReferenceTypeQualified() && PsiMethodReferenceExpressionImpl.this.getReferenceNameElement() instanceof PsiIdentifier) {
                    CandidateInfo candidateInfo = this.filterStaticCorrectCandidates(firstCandidates, secondCandidates, true);
                    if (candidateInfo != null) {
                        return candidateInfo;
                    }
                    candidateInfo = this.filterStaticCorrectCandidates(secondCandidates, firstCandidates, false);
                    if (candidateInfo != null) {
                        return candidateInfo;
                    }
                }
                this.checkSpecifics(firstCandidates, varargs ? 2 : 3, this.myLanguageLevel);
                this.checkSpecifics(secondCandidates, varargs ? 2 : 3, this.myLanguageLevel);
                int acceptedCount = firstCandidates.size() + secondCandidates.size();
                if (acceptedCount == 1) {
                    return !firstCandidates.isEmpty() ? (CandidateInfo)firstCandidates.get(0) : (CandidateInfo)secondCandidates.get(0);
                }
                if (!varargs) {
                    return this.resolveConflict(conflicts, true);
                }
                conflicts.clear();
                firstCandidates.addAll(secondCandidates);
                conflicts.addAll(firstCandidates);
                return null;
            }

            @Override
            protected boolean nonComparable(CandidateInfo method, CandidateInfo conflict) {
                if (method == conflict) {
                    return true;
                }
                PsiElement psiElement = method.getElement();
                PsiElement conflictElement = conflict.getElement();
                return psiElement instanceof PsiMethod && conflictElement instanceof PsiMethod && ((PsiMethod)psiElement).getParameterList().getParametersCount() != ((PsiMethod)conflictElement).getParameterList().getParametersCount();
            }

            private CandidateInfo filterStaticCorrectCandidates(List<CandidateInfo> firstCandidates, List<CandidateInfo> secondCandidates, boolean shouldBeStatic) {
                CandidateInfo candidateInfo;
                PsiElement element;
                if (firstCandidates.size() == 1 && (element = (candidateInfo = firstCandidates.get(0)).getElement()) instanceof PsiMethod) {
                    boolean isStatic = ((PsiMethod)element).hasModifierProperty("static");
                    if (shouldBeStatic && isStatic || !shouldBeStatic && !isStatic) {
                        for (CandidateInfo secondCandidate : secondCandidates) {
                            PsiElement psiElement = secondCandidate.getElement();
                            if (!(psiElement instanceof PsiMethod)) continue;
                            boolean oppositeStatic = ((PsiMethod)psiElement).hasModifierProperty("static");
                            if ((!shouldBeStatic || oppositeStatic) && (shouldBeStatic || !oppositeStatic)) continue;
                            return null;
                        }
                        return candidateInfo;
                    }
                }
                return null;
            }

            private boolean isCorrectAssignment(PsiType[] signatureParameterTypes2, PsiType[] parameterTypes, PsiSubstitutor substitutor, boolean varargs, int offset) {
                int min = Math.min(signatureParameterTypes2.length, parameterTypes.length - offset);
                for (int i = 0; i < min; ++i) {
                    PsiType type1 = substitutor.substitute(parameterTypes[i + offset]);
                    PsiType type2 = signatureParameterTypes2[i];
                    if (!(varargs && i == signatureParameterTypes2.length - 1 ? !TypeConversionUtil.isAssignable(type2, type1) && !TypeConversionUtil.isAssignable(((PsiArrayType)type2).getComponentType(), type1) : !TypeConversionUtil.isAssignable(type2, type1))) continue;
                    return false;
                }
                return true;
            }
        }
    }
}

