/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;

public abstract class AbstractClassTypeConstructor
implements TypeConstructor {
    public final int hashCode() {
        return AbstractClassTypeConstructor.hashCode(this);
    }

    public boolean equals(Object obj) {
        return AbstractClassTypeConstructor.equals(this, obj);
    }

    public static boolean equals(@NotNull TypeConstructor me, Object other) {
        if (me == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me", "org/jetbrains/jet/lang/types/AbstractClassTypeConstructor", "equals"));
        }
        if (!(other instanceof TypeConstructor)) {
            return false;
        }
        ClassifierDescriptor myDescriptor = me.getDeclarationDescriptor();
        ClassifierDescriptor otherDescriptor = ((TypeConstructor)other).getDeclarationDescriptor();
        if (myDescriptor != null && !AbstractClassTypeConstructor.hasMeaningfulFqName(myDescriptor) || otherDescriptor != null && !AbstractClassTypeConstructor.hasMeaningfulFqName(otherDescriptor)) {
            return me == other;
        }
        if (myDescriptor == otherDescriptor) {
            return true;
        }
        if (myDescriptor instanceof ClassDescriptor && otherDescriptor instanceof ClassDescriptor) {
            FqNameUnsafe otherFqName = DescriptorUtils.getFqName(otherDescriptor);
            FqNameUnsafe myFqName = DescriptorUtils.getFqName(myDescriptor);
            return myFqName.equals(otherFqName);
        }
        return false;
    }

    public static int hashCode(@NotNull TypeConstructor me) {
        if (me == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me", "org/jetbrains/jet/lang/types/AbstractClassTypeConstructor", "hashCode"));
        }
        ClassifierDescriptor descriptor = me.getDeclarationDescriptor();
        if (descriptor instanceof ClassDescriptor && !ErrorUtils.isError(descriptor)) {
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
            return DescriptorUtils.getFqName(classDescriptor).hashCode();
        }
        return System.identityHashCode(me);
    }

    private static boolean hasMeaningfulFqName(@NotNull ClassifierDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/AbstractClassTypeConstructor", "hasMeaningfulFqName"));
        }
        return !ErrorUtils.isError(descriptor) && !DescriptorUtils.isLocal(descriptor);
    }
}

