/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeWithImports;
import org.jetbrains.jet.utils.Printer;

public class WriteThroughScope
extends WritableScopeWithImports {
    private final WritableScope writableWorker;
    private Collection<DeclarationDescriptor> allDescriptors;

    public WriteThroughScope(@NotNull JetScope outerScope, @NotNull WritableScope scope, @NotNull RedeclarationHandler redeclarationHandler, @NotNull String debugName) {
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "<init>"));
        }
        if (redeclarationHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "redeclarationHandler", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "<init>"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "<init>"));
        }
        super(outerScope, redeclarationHandler, debugName);
        this.writableWorker = scope;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull Name labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "getDeclarationsByLabel"));
        }
        this.checkMayRead();
        Collection<DeclarationDescriptor> collection = this.writableWorker.getDeclarationsByLabel(labelName);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "getDeclarationsByLabel"));
        }
        return collection;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.writableWorker.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "getFunctions"));
        }
        this.checkMayRead();
        LinkedHashSet<FunctionDescriptor> result2 = Sets.newLinkedHashSet();
        result2.addAll(this.getWorkerScope().getFunctions(name));
        result2.addAll(super.getFunctions(name));
        LinkedHashSet<FunctionDescriptor> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "getFunctions"));
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "getProperties"));
        }
        this.checkMayRead();
        LinkedHashSet<VariableDescriptor> properties = Sets.newLinkedHashSet();
        properties.addAll(this.getWorkerScope().getProperties(name));
        properties.addAll(super.getProperties(name));
        LinkedHashSet<VariableDescriptor> linkedHashSet = properties;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "getProperties"));
        }
        return linkedHashSet;
    }

    @Override
    @Nullable
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "getLocalVariable"));
        }
        this.checkMayRead();
        VariableDescriptor variable = this.getWorkerScope().getLocalVariable(name);
        if (variable != null) {
            return variable;
        }
        return super.getLocalVariable(name);
    }

    @Override
    @Nullable
    public PackageViewDescriptor getPackage(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "getPackage"));
        }
        this.checkMayRead();
        PackageViewDescriptor aPackage = this.getWorkerScope().getPackage(name);
        if (aPackage != null) {
            return aPackage;
        }
        return super.getPackage(name);
    }

    @Override
    @Nullable
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "getClassifier"));
        }
        this.checkMayRead();
        ClassifierDescriptor classifier2 = this.getWorkerScope().getClassifier(name);
        if (classifier2 != null) {
            return classifier2;
        }
        return super.getClassifier(name);
    }

    @Override
    public void addLabeledDeclaration(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addLabeledDeclaration"));
        }
        this.checkMayWrite();
        this.writableWorker.addLabeledDeclaration(descriptor);
    }

    @Override
    public void addVariableDescriptor(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addVariableDescriptor"));
        }
        this.checkMayWrite();
        this.writableWorker.addVariableDescriptor(variableDescriptor);
    }

    @Override
    public void addPropertyDescriptor(@NotNull VariableDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addPropertyDescriptor"));
        }
        this.checkMayWrite();
        this.writableWorker.addPropertyDescriptor(propertyDescriptor);
    }

    @Override
    public void addFunctionDescriptor(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addFunctionDescriptor"));
        }
        this.checkMayWrite();
        this.writableWorker.addFunctionDescriptor(functionDescriptor);
    }

    @Override
    public void addTypeParameterDescriptor(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addTypeParameterDescriptor"));
        }
        this.checkMayWrite();
        this.writableWorker.addTypeParameterDescriptor(typeParameterDescriptor);
    }

    @Override
    public void addClassifierDescriptor(@NotNull ClassifierDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addClassifierDescriptor"));
        }
        this.checkMayWrite();
        this.writableWorker.addClassifierDescriptor(classDescriptor);
    }

    @Override
    public void addClassifierAlias(@NotNull Name name, @NotNull ClassifierDescriptor classifierDescriptor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addClassifierAlias"));
        }
        if (classifierDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifierDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addClassifierAlias"));
        }
        this.checkMayWrite();
        this.writableWorker.addClassifierAlias(name, classifierDescriptor);
    }

    @Override
    public void addPackageAlias(@NotNull Name name, @NotNull PackageViewDescriptor packageView) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addPackageAlias"));
        }
        if (packageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageView", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addPackageAlias"));
        }
        this.checkMayWrite();
        this.writableWorker.addPackageAlias(name, packageView);
    }

    @Override
    public void addVariableAlias(@NotNull Name name, @NotNull VariableDescriptor variableDescriptor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addVariableAlias"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addVariableAlias"));
        }
        this.checkMayWrite();
        this.writableWorker.addVariableAlias(name, variableDescriptor);
    }

    @Override
    public void addFunctionAlias(@NotNull Name name, @NotNull FunctionDescriptor functionDescriptor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addFunctionAlias"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "addFunctionAlias"));
        }
        this.checkMayWrite();
        this.writableWorker.addFunctionAlias(name, functionDescriptor);
    }

    @Override
    @NotNull
    public Multimap<Name, DeclarationDescriptor> getDeclaredDescriptorsAccessibleBySimpleName() {
        Multimap<Name, DeclarationDescriptor> multimap = this.writableWorker.getDeclaredDescriptorsAccessibleBySimpleName();
        if (multimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "getDeclaredDescriptorsAccessibleBySimpleName"));
        }
        return multimap;
    }

    @Override
    public void importScope(@NotNull JetScope imported) {
        if (imported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imported", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "importScope"));
        }
        this.checkMayWrite();
        super.importScope(imported);
    }

    @Override
    public void setImplicitReceiver(@NotNull ReceiverParameterDescriptor implicitReceiver) {
        if (implicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implicitReceiver", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "setImplicitReceiver"));
        }
        this.checkMayWrite();
        this.writableWorker.setImplicitReceiver(implicitReceiver);
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        this.checkMayRead();
        if (this.allDescriptors == null) {
            this.allDescriptors = Lists.newArrayList();
            this.allDescriptors.addAll(this.getWorkerScope().getAllDescriptors());
            for (JetScope imported : this.getImports()) {
                this.allDescriptors.addAll(imported.getAllDescriptors());
            }
        }
        Collection<DeclarationDescriptor> collection = this.allDescriptors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "getAllDescriptors"));
        }
        return collection;
    }

    @Override
    protected void printAdditionalScopeStructure(@NotNull Printer p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/resolve/scopes/WriteThroughScope", "printAdditionalScopeStructure"));
        }
        p.print("writableWorker = ");
        this.writableWorker.printScopeStructure(p.withholdIndentOnce());
    }
}

