/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.parsing.JetScriptDefinition;
import org.jetbrains.jet.lang.parsing.JetScriptDefinitionProvider;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.DependencyClassByQualifiedNameResolver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.ref.JetTypeName;

public class ScriptParameterResolver {
    @NotNull
    private DependencyClassByQualifiedNameResolver dependencyClassByQualifiedNameResolver;

    public void setDependencyClassByQualifiedNameResolver(@NotNull DependencyClassByQualifiedNameResolver dependencyClassByQualifiedNameResolver) {
        if (dependencyClassByQualifiedNameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyClassByQualifiedNameResolver", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "setDependencyClassByQualifiedNameResolver"));
        }
        this.dependencyClassByQualifiedNameResolver = dependencyClassByQualifiedNameResolver;
    }

    @NotNull
    public List<ValueParameterDescriptor> resolveScriptParameters(@NotNull JetScript declaration, @NotNull ScriptDescriptor scriptDescriptor) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveScriptParameters"));
        }
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveScriptParameters"));
        }
        ArrayList<ValueParameterDescriptor> valueParameters = Lists.newArrayList();
        JetFile file = declaration.getContainingJetFile();
        JetScriptDefinition scriptDefinition = JetScriptDefinitionProvider.getInstance(file.getProject()).findScriptDefinition(file);
        int index = 0;
        for (AnalyzerScriptParameter scriptParameter : scriptDefinition.getScriptParameters()) {
            ValueParameterDescriptor parameter = this.resolveScriptParameter(scriptParameter, index, scriptDescriptor);
            valueParameters.add(parameter);
            ++index;
        }
        ArrayList<ValueParameterDescriptor> arrayList = valueParameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveScriptParameters"));
        }
        return arrayList;
    }

    @NotNull
    private ClassDescriptor resolveClass(@NotNull FqName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveClass"));
        }
        ClassDescriptor classDescriptor = this.dependencyClassByQualifiedNameResolver.resolveClass(className);
        if (classDescriptor == null) {
            throw new IllegalStateException("dependency class not found by name: " + className);
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveClass"));
        }
        return classDescriptor2;
    }

    @NotNull
    public JetType resolveTypeName(@NotNull JetTypeName typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveTypeName"));
        }
        ArrayList<JetType> typeArguments = new ArrayList<JetType>();
        for (JetTypeName typeArgumentName : typeName.getArguments()) {
            typeArguments.add(this.resolveTypeName(typeArgumentName));
        }
        ClassDescriptor classDescriptor = this.resolveClass(typeName.getClassName());
        JetType jetType = TypeUtils.substituteParameters(classDescriptor, typeArguments);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveTypeName"));
        }
        return jetType;
    }

    @NotNull
    private ValueParameterDescriptor resolveScriptParameter(@NotNull AnalyzerScriptParameter scriptParameter, int index, @NotNull ScriptDescriptor script) {
        if (scriptParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptParameter", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveScriptParameter"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveScriptParameter"));
        }
        JetType type = this.resolveTypeName(scriptParameter.getType());
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(script, null, index, Annotations.EMPTY, scriptParameter.getName(), type, false, null);
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ScriptParameterResolver", "resolveScriptParameter"));
        }
        return valueParameterDescriptorImpl;
    }
}

