/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElementImplStub;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetPropertyDelegate;
import org.jetbrains.jet.lang.psi.JetWithExpressionInitializer;
import org.jetbrains.jet.plugin.JetLanguage;

public abstract class JetStubElementType<StubT extends StubElement, PsiT extends JetElementImplStub<?>>
extends IStubElementType<StubT, PsiT> {
    private static final Class<? extends PsiElement>[] ALWAYS_CREATE_STUB_FOR = new Class[]{JetClass.class, JetObjectDeclaration.class};
    @NotNull
    private final Constructor<PsiT> byNodeConstructor;
    @NotNull
    private final Constructor<PsiT> byStubConstructor;
    @NotNull
    private final PsiT[] emptyArray;
    @NotNull
    private final ArrayFactory<PsiT> arrayFactory;

    public JetStubElementType(@NotNull @NonNls String debugName, final @NotNull Class<PsiT> psiClass, @NotNull Class<?> stubClass) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "<init>"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "<init>"));
        }
        if (stubClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubClass", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "<init>"));
        }
        super(debugName, JetLanguage.INSTANCE);
        try {
            this.byNodeConstructor = psiClass.getConstructor(ASTNode.class);
            this.byStubConstructor = psiClass.getConstructor(stubClass);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Stub element type declaration for " + psiClass.getSimpleName() + " is missing required constructors", e);
        }
        this.emptyArray = (JetElementImplStub[])Array.newInstance(psiClass, 0);
        this.arrayFactory = new ArrayFactory<PsiT>(){

            @Override
            @NotNull
            public PsiT[] create(int count) {
                if (count == 0) {
                    JetElementImplStub[] jetElementImplStubArray = JetStubElementType.this.emptyArray;
                    if (jetElementImplStubArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType$1", "create"));
                    }
                    return jetElementImplStubArray;
                }
                JetElementImplStub[] jetElementImplStubArray = (JetElementImplStub[])Array.newInstance(psiClass, count);
                if (jetElementImplStubArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType$1", "create"));
                }
                return jetElementImplStubArray;
            }
        };
    }

    @NotNull
    public PsiT createPsiFromAst(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "createPsiFromAst"));
        }
        JetElementImplStub jetElementImplStub = (JetElementImplStub)ReflectionUtil.createInstance(this.byNodeConstructor, node);
        if (jetElementImplStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "createPsiFromAst"));
        }
        return (PsiT)jetElementImplStub;
    }

    @Override
    @NotNull
    public PsiT createPsi(@NotNull StubT stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "createPsi"));
        }
        JetElementImplStub jetElementImplStub = (JetElementImplStub)ReflectionUtil.createInstance(this.byStubConstructor, stub);
        if (jetElementImplStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "createPsi"));
        }
        return (PsiT)jetElementImplStub;
    }

    @Override
    @NotNull
    public String getExternalId() {
        String string = "jet." + this.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "getExternalId"));
        }
        return string;
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        PsiElement psi = node.getPsi();
        if (ArrayUtil.contains(psi.getClass(), ALWAYS_CREATE_STUB_FOR)) {
            return true;
        }
        if (psi instanceof JetDeclaration) {
            return JetStubElementType.shouldCreateStubForDeclaration((JetDeclaration)psi);
        }
        return JetStubElementType.createStubDependingOnParent(node);
    }

    private static boolean createStubDependingOnParent(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        IElementType parentType = parent.getElementType();
        if (parentType instanceof IStubElementType) {
            return ((IStubElementType)parentType).shouldCreateStub(parent);
        }
        return parentType instanceof IStubFileElementType;
    }

    private static boolean shouldCreateStubForDeclaration(@NotNull JetDeclaration declaration) {
        JetExpression delegateExpression;
        JetExpression initializer;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "shouldCreateStubForDeclaration"));
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)declaration, JetFunctionLiteral.class, false, ALWAYS_CREATE_STUB_FOR) != null) {
            return false;
        }
        JetBlockExpression blockExpression = PsiTreeUtil.getParentOfType((PsiElement)declaration, JetBlockExpression.class, false, ALWAYS_CREATE_STUB_FOR);
        if (blockExpression != null) {
            return false;
        }
        Class<JetBlockExpression>[] stopAt = ArrayUtil.append(ALWAYS_CREATE_STUB_FOR, JetBlockExpression.class);
        JetWithExpressionInitializer withInitializer = PsiTreeUtil.getParentOfType((PsiElement)declaration, JetWithExpressionInitializer.class, true, stopAt);
        if (withInitializer != null && PsiTreeUtil.isAncestor(initializer = withInitializer.getInitializer(), declaration, true)) {
            return false;
        }
        JetPropertyDelegate delegate = PsiTreeUtil.getParentOfType((PsiElement)declaration, JetPropertyDelegate.class, true, stopAt);
        return delegate == null || !PsiTreeUtil.isAncestor(delegateExpression = delegate.getExpression(), declaration, true);
    }

    @Override
    public void indexStub(@NotNull StubT stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "indexStub"));
        }
    }

    @NotNull
    public ArrayFactory<PsiT> getArrayFactory() {
        ArrayFactory<PsiT> arrayFactory = this.arrayFactory;
        if (arrayFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetStubElementType", "getArrayFactory"));
        }
        return arrayFactory;
    }
}

