/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitorWithResult;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionWithReceiver;
import org.jetbrains.jet.lang.cfg.pseudocode.LexicalScope;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudoValue;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;

public class WriteValueInstruction
extends InstructionWithReceiver {
    @NotNull
    private final JetElement lValue;
    @NotNull
    private final PseudoValue rValue;

    public WriteValueInstruction(@NotNull JetElement assignment, @NotNull JetElement lValue, @NotNull PseudoValue rValue, @Nullable PseudoValue receiverValue, @NotNull LexicalScope lexicalScope) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "org/jetbrains/jet/lang/cfg/pseudocode/WriteValueInstruction", "<init>"));
        }
        if (lValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lValue", "org/jetbrains/jet/lang/cfg/pseudocode/WriteValueInstruction", "<init>"));
        }
        if (rValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rValue", "org/jetbrains/jet/lang/cfg/pseudocode/WriteValueInstruction", "<init>"));
        }
        if (lexicalScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexicalScope", "org/jetbrains/jet/lang/cfg/pseudocode/WriteValueInstruction", "<init>"));
        }
        super(assignment, lexicalScope, receiverValue);
        this.lValue = lValue;
        this.rValue = rValue;
    }

    @NotNull
    public JetElement getlValue() {
        JetElement jetElement = this.lValue;
        if (jetElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/WriteValueInstruction", "getlValue"));
        }
        return jetElement;
    }

    @Override
    @NotNull
    public List<PseudoValue> getInputValues() {
        List<PseudoValue> list = this.receiverValue != null ? Arrays.asList(this.rValue, this.receiverValue) : Collections.singletonList(this.rValue);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/WriteValueInstruction", "getInputValues"));
        }
        return list;
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/WriteValueInstruction", "accept"));
        }
        visitor.visitWriteValue(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<R> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/WriteValueInstruction", "accept"));
        }
        return visitor.visitWriteValue(this);
    }

    public String toString() {
        String lhs = this.lValue instanceof JetNamedDeclaration ? this.lValue.getName() : this.render(this.lValue);
        return "w(" + lhs + "|" + (this.receiverValue != null ? this.receiverValue + ", " : "") + this.rValue.toString() + ")";
    }

    @Override
    @NotNull
    protected Instruction createCopy() {
        WriteValueInstruction writeValueInstruction = new WriteValueInstruction(this.element, this.lValue, this.rValue, this.receiverValue, this.lexicalScope);
        if (writeValueInstruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/WriteValueInstruction", "createCopy"));
        }
        return writeValueInstruction;
    }
}

