/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.binding;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.SamType;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.binding.CodegenAnnotatingVisitor;
import org.jetbrains.jet.codegen.binding.MutableClosure;
import org.jetbrains.jet.codegen.binding.PsiCodegenPredictor;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.util.slicedmap.BasicWritableSlice;
import org.jetbrains.jet.util.slicedmap.Slices;
import org.jetbrains.jet.util.slicedmap.WritableSlice;
import org.jetbrains.org.objectweb.asm.Type;

public class CodegenBinding {
    public static final WritableSlice<ClassDescriptor, MutableClosure> CLOSURE = Slices.createSimpleSlice();
    public static final WritableSlice<FunctionDescriptor, ClassDescriptor> CLASS_FOR_FUNCTION = Slices.createSimpleSlice();
    public static final WritableSlice<ScriptDescriptor, ClassDescriptor> CLASS_FOR_SCRIPT = Slices.createSimpleSlice();
    public static final WritableSlice<ClassDescriptor, Type> ASM_TYPE = Slices.createCollectiveSlice();
    public static final WritableSlice<ClassDescriptor, Boolean> ENUM_ENTRY_CLASS_NEED_SUBCLASS = Slices.createSimpleSetSlice();
    public static final WritableSlice<ClassDescriptor, Collection<ClassDescriptor>> INNER_CLASSES = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, SamType> SAM_VALUE = Slices.createSimpleSlice();

    private CodegenBinding() {
    }

    public static void initTrace(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/binding/CodegenBinding", "initTrace"));
        }
        CodegenAnnotatingVisitor visitor = new CodegenAnnotatingVisitor(state);
        for (JetFile file : CodegenBinding.allFilesInPackages(state.getBindingContext(), state.getFiles())) {
            file.accept(visitor);
        }
    }

    public static boolean enumEntryNeedSubclass(BindingContext bindingContext, JetEnumEntry enumEntry) {
        return CodegenBinding.enumEntryNeedSubclass(bindingContext, bindingContext.get(BindingContext.CLASS, enumEntry));
    }

    public static boolean enumEntryNeedSubclass(BindingContext bindingContext, ClassDescriptor classDescriptor) {
        return Boolean.TRUE.equals(bindingContext.get(ENUM_ENTRY_CLASS_NEED_SUBCLASS, classDescriptor));
    }

    @NotNull
    public static Type asmTypeForScriptDescriptor(BindingContext bindingContext, @NotNull ScriptDescriptor scriptDescriptor) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/jet/codegen/binding/CodegenBinding", "asmTypeForScriptDescriptor"));
        }
        ClassDescriptor classDescriptor = bindingContext.get(CLASS_FOR_SCRIPT, scriptDescriptor);
        Type type = CodegenBinding.getAsmType(bindingContext, classDescriptor);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "asmTypeForScriptDescriptor"));
        }
        return type;
    }

    @NotNull
    public static Type asmTypeForScriptPsi(BindingContext bindingContext, @NotNull JetScript script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/jet/codegen/binding/CodegenBinding", "asmTypeForScriptPsi"));
        }
        ScriptDescriptor scriptDescriptor = bindingContext.get(BindingContext.SCRIPT, script);
        if (scriptDescriptor == null) {
            throw new IllegalStateException("Script descriptor not found by PSI " + script);
        }
        Type type = CodegenBinding.asmTypeForScriptDescriptor(bindingContext, scriptDescriptor);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "asmTypeForScriptPsi"));
        }
        return type;
    }

    public static ClassDescriptor enclosingClassDescriptor(BindingContext bindingContext, ClassDescriptor descriptor) {
        CalculatedClosure closure = bindingContext.get(CLOSURE, descriptor);
        return closure == null ? null : closure.getEnclosingClass();
    }

    @NotNull
    public static ClassDescriptor anonymousClassForFunction(@NotNull BindingContext bindingContext, @NotNull FunctionDescriptor descriptor) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/codegen/binding/CodegenBinding", "anonymousClassForFunction"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/binding/CodegenBinding", "anonymousClassForFunction"));
        }
        ClassDescriptor classDescriptor = bindingContext.get(CLASS_FOR_FUNCTION, descriptor);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "anonymousClassForFunction"));
        }
        return classDescriptor;
    }

    @NotNull
    public static Type asmTypeForAnonymousClass(@NotNull BindingContext bindingContext, @NotNull JetElement expression) {
        ClassDescriptor descriptor;
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        if (expression instanceof JetObjectLiteralExpression) {
            JetObjectLiteralExpression jetObjectLiteralExpression = (JetObjectLiteralExpression)expression;
            expression = jetObjectLiteralExpression.getObjectDeclaration();
        }
        if ((descriptor = bindingContext.get(BindingContext.CLASS, expression)) == null) {
            SimpleFunctionDescriptor functionDescriptor = bindingContext.get(BindingContext.FUNCTION, expression);
            assert (functionDescriptor != null);
            Type type = CodegenBinding.asmTypeForAnonymousClass(bindingContext, functionDescriptor);
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
            }
            return type;
        }
        Type type = CodegenBinding.getAsmType(bindingContext, descriptor);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        return type;
    }

    @NotNull
    public static Type asmTypeForAnonymousClass(@NotNull BindingContext bindingContext, @NotNull FunctionDescriptor descriptor) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        Type type = CodegenBinding.getAsmType(bindingContext, CodegenBinding.anonymousClassForFunction(bindingContext, descriptor));
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "asmTypeForAnonymousClass"));
        }
        return type;
    }

    public static void registerClassNameForScript(BindingTrace bindingTrace, @NotNull ScriptDescriptor scriptDescriptor, @NotNull Type asmType) {
        if (scriptDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDescriptor", "org/jetbrains/jet/codegen/binding/CodegenBinding", "registerClassNameForScript"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/jet/codegen/binding/CodegenBinding", "registerClassNameForScript"));
        }
        ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(scriptDescriptor, Name.special("<script-" + asmType.getInternalName() + ">"), Modality.FINAL, Collections.singleton(KotlinBuiltIns.getInstance().getAnyType()));
        classDescriptor.initialize(JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null);
        CodegenBinding.recordClosure(bindingTrace, null, classDescriptor, null, asmType);
        bindingTrace.record(CLASS_FOR_SCRIPT, scriptDescriptor, classDescriptor);
    }

    public static boolean canHaveOuter(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor classDescriptor) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/codegen/binding/CodegenBinding", "canHaveOuter"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/binding/CodegenBinding", "canHaveOuter"));
        }
        if (classDescriptor.getKind() != ClassKind.CLASS) {
            return false;
        }
        ClassDescriptor enclosing = CodegenBinding.enclosingClassDescriptor(bindingContext, classDescriptor);
        if (enclosing == null) {
            return false;
        }
        return classDescriptor.isInner() || !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor);
    }

    static void recordClosure(@NotNull BindingTrace bindingTrace, @Nullable JetElement element, @NotNull ClassDescriptor classDescriptor, @Nullable ClassDescriptor enclosing, @NotNull Type asmType) {
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/codegen/binding/CodegenBinding", "recordClosure"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/binding/CodegenBinding", "recordClosure"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/jet/codegen/binding/CodegenBinding", "recordClosure"));
        }
        JetDelegatorToSuperCall superCall = CodegenBinding.findSuperCall(bindingTrace.getBindingContext(), element);
        CallableDescriptor enclosingReceiver = null;
        if (classDescriptor.getContainingDeclaration() instanceof CallableDescriptor) {
            enclosingReceiver = (CallableDescriptor)classDescriptor.getContainingDeclaration();
            CallableDescriptor callableDescriptor = enclosingReceiver = enclosingReceiver instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)enclosingReceiver).getCorrespondingProperty() : enclosingReceiver;
            if (enclosingReceiver.getReceiverParameter() == null) {
                enclosingReceiver = null;
            }
        }
        MutableClosure closure = new MutableClosure(superCall, enclosing, enclosingReceiver);
        assert (PsiCodegenPredictor.checkPredictedNameFromPsi(bindingTrace.getBindingContext(), classDescriptor, asmType));
        bindingTrace.record(ASM_TYPE, classDescriptor, asmType);
        bindingTrace.record(CLOSURE, classDescriptor, closure);
        if (classDescriptor.isInner()) {
            closure.setCaptureThis();
        }
        if (enclosing != null && !(element instanceof JetFunctionLiteral)) {
            CodegenBinding.recordInnerClass(bindingTrace, enclosing, classDescriptor);
        }
    }

    private static void recordInnerClass(@NotNull BindingTrace bindingTrace, @NotNull ClassDescriptor outer, @NotNull ClassDescriptor inner) {
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/codegen/binding/CodegenBinding", "recordInnerClass"));
        }
        if (outer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outer", "org/jetbrains/jet/codegen/binding/CodegenBinding", "recordInnerClass"));
        }
        if (inner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inner", "org/jetbrains/jet/codegen/binding/CodegenBinding", "recordInnerClass"));
        }
        Collection<ClassDescriptor> innerClasses = bindingTrace.get(INNER_CLASSES, outer);
        if (innerClasses == null) {
            innerClasses = new ArrayList<ClassDescriptor>();
            bindingTrace.record(INNER_CLASSES, outer, innerClasses);
        }
        innerClasses.add(inner);
    }

    public static void registerClassNameForScript(BindingTrace bindingTrace, @NotNull JetScript jetScript, @NotNull Type asmType) {
        if (jetScript == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetScript", "org/jetbrains/jet/codegen/binding/CodegenBinding", "registerClassNameForScript"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/jet/codegen/binding/CodegenBinding", "registerClassNameForScript"));
        }
        ScriptDescriptor descriptor = bindingTrace.getBindingContext().get(BindingContext.SCRIPT, jetScript);
        if (descriptor == null) {
            throw new IllegalStateException("Descriptor is not found for PSI " + jetScript);
        }
        CodegenBinding.registerClassNameForScript(bindingTrace, descriptor, asmType);
    }

    @NotNull
    private static Collection<JetFile> allFilesInPackages(BindingContext bindingContext, Collection<JetFile> files) {
        HashSet<FqName> names = new HashSet<FqName>();
        for (JetFile file : files) {
            if (file.isScript()) continue;
            names.add(file.getPackageFqName());
        }
        HashSet<JetFile> answer = new HashSet<JetFile>();
        answer.addAll(files);
        for (FqName name : names) {
            Collection<JetFile> jetFiles = bindingContext.get(BindingContext.PACKAGE_TO_FILES, name);
            if (jetFiles == null) continue;
            answer.addAll(jetFiles);
        }
        ArrayList<JetFile> sortedAnswer = new ArrayList<JetFile>(answer);
        Collections.sort(sortedAnswer, new Comparator<JetFile>(){

            @NotNull
            private String path(JetFile file) {
                VirtualFile virtualFile = file.getVirtualFile();
                assert (virtualFile != null) : "VirtualFile is null for JetFile: " + file.getName();
                String string = virtualFile.getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding$1", "path"));
                }
                return string;
            }

            @Override
            public int compare(@NotNull JetFile first, @NotNull JetFile second) {
                if (first == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/jet/codegen/binding/CodegenBinding$1", "compare"));
                }
                if (second == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "org/jetbrains/jet/codegen/binding/CodegenBinding$1", "compare"));
                }
                return this.path(first).compareTo(this.path(second));
            }
        });
        ArrayList<JetFile> arrayList = sortedAnswer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "allFilesInPackages"));
        }
        return arrayList;
    }

    public static boolean isLocalNamedFun(@Nullable DeclarationDescriptor fd) {
        return CodegenBinding.isLocalFunOrLambda(fd) && !fd.getName().isSpecial();
    }

    public static boolean isLocalFunOrLambda(@Nullable DeclarationDescriptor fd) {
        if (fd instanceof FunctionDescriptor) {
            FunctionDescriptor descriptor = (FunctionDescriptor)fd;
            return descriptor.getVisibility() == Visibilities.LOCAL;
        }
        return false;
    }

    @NotNull
    public static Type getAsmType(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor klass) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAsmType"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAsmType"));
        }
        Type alreadyComputedType = bindingContext.get(ASM_TYPE, klass = (ClassDescriptor)klass.getOriginal());
        if (alreadyComputedType != null) {
            Type type = alreadyComputedType;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAsmType"));
            }
            return type;
        }
        Type asmType = Type.getObjectType(CodegenBinding.getAsmTypeImpl(bindingContext, klass));
        assert (PsiCodegenPredictor.checkPredictedNameFromPsi(bindingContext, klass, asmType));
        Type type = asmType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAsmType"));
        }
        return type;
    }

    @NotNull
    private static String getAsmTypeImpl(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor klass) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAsmTypeImpl"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAsmTypeImpl"));
        }
        DeclarationDescriptor container = klass.getContainingDeclaration();
        if (container instanceof PackageFragmentDescriptor) {
            String shortName = klass.getName().getIdentifier();
            FqName fqName = ((PackageFragmentDescriptor)container).getFqName();
            String string = fqName.isRoot() ? shortName : fqName.asString().replace('.', '/') + '/' + shortName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAsmTypeImpl"));
            }
            return string;
        }
        assert (container instanceof ClassDescriptor) : "Unexpected container: " + container + " for " + klass;
        String containerInternalName = CodegenBinding.getAsmType(bindingContext, (ClassDescriptor)container).getInternalName();
        switch (klass.getKind()) {
            case ENUM_ENTRY: {
                String string = containerInternalName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAsmTypeImpl"));
                }
                return string;
            }
            case CLASS_OBJECT: {
                String string = containerInternalName + "$object";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAsmTypeImpl"));
                }
                return string;
            }
        }
        String string = containerInternalName + "$" + klass.getName().getIdentifier();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAsmTypeImpl"));
        }
        return string;
    }

    public static boolean hasThis0(BindingContext bindingContext, ClassDescriptor classDescriptor) {
        CalculatedClosure closure = bindingContext.get(CLOSURE, classDescriptor);
        return closure != null && closure.getCaptureThis() != null;
    }

    private static JetDelegatorToSuperCall findSuperCall(BindingContext bindingContext, JetElement classOrObject) {
        if (!(classOrObject instanceof JetClassOrObject)) {
            return null;
        }
        if (classOrObject instanceof JetClass && ((JetClass)classOrObject).isTrait()) {
            return null;
        }
        for (JetDelegationSpecifier specifier : ((JetClassOrObject)classOrObject).getDelegationSpecifiers()) {
            if (!(specifier instanceof JetDelegatorToSuperCall)) continue;
            JetTypeReference typeReference = specifier.getTypeReference();
            JetType superType = bindingContext.get(BindingContext.TYPE, typeReference);
            assert (superType != null) : String.format("No type in binding context for  \n---\n%s\n---\n", JetPsiUtil.getElementTextWithContext(specifier));
            ClassDescriptor superClassDescriptor = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
            assert (superClassDescriptor != null);
            if (JvmCodegenUtil.isInterface(superClassDescriptor)) continue;
            return (JetDelegatorToSuperCall)specifier;
        }
        return null;
    }

    @NotNull
    public static Collection<ClassDescriptor> getAllInnerClasses(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor outermostClass) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAllInnerClasses"));
        }
        if (outermostClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outermostClass", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAllInnerClasses"));
        }
        Collection<ClassDescriptor> innerClasses = bindingContext.get(INNER_CLASSES, outermostClass);
        if (innerClasses == null || innerClasses.isEmpty()) {
            Set<ClassDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAllInnerClasses"));
            }
            return set;
        }
        HashSet<ClassDescriptor> allInnerClasses = new HashSet<ClassDescriptor>();
        ArrayDeque<ClassDescriptor> stack = new ArrayDeque<ClassDescriptor>(innerClasses);
        do {
            Collection<ClassDescriptor> nextClasses;
            ClassDescriptor currentClass;
            if (!allInnerClasses.add(currentClass = (ClassDescriptor)stack.pop()) || (nextClasses = bindingContext.get(INNER_CLASSES, currentClass)) == null) continue;
            for (ClassDescriptor nextClass : nextClasses) {
                stack.push(nextClass);
            }
        } while (!stack.isEmpty());
        HashSet<ClassDescriptor> hashSet = allInnerClasses;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getAllInnerClasses"));
        }
        return hashSet;
    }

    @NotNull
    public static String getJvmInternalName(@NotNull BindingContext bindingContext, @NotNull ClassDescriptor classDescriptor) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getJvmInternalName"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getJvmInternalName"));
        }
        String string = CodegenBinding.getAsmType(bindingContext, classDescriptor).getClassName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenBinding", "getJvmInternalName"));
        }
        return string;
    }

    static {
        BasicWritableSlice.initSliceDebugNames(CodegenBinding.class);
    }
}

