/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInferenceHelper;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.PsiOldInferenceHelper;
import com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import com.intellij.psi.impl.source.resolve.ResolveVariableUtil;
import com.intellij.psi.impl.source.resolve.graphInference.PsiGraphInferenceHelper;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiResolveHelperImpl
implements PsiResolveHelper {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl");
    private final PsiManager myManager;
    private PsiInferenceHelper myTestHelper;

    public PsiResolveHelperImpl(PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public JavaResolveResult resolveConstructor(PsiClassType classType, PsiExpressionList argumentList, PsiElement place) {
        JavaResolveResult[] result2 = this.multiResolveConstructor(classType, argumentList, place);
        JavaResolveResult javaResolveResult = result2.length == 1 ? result2[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveConstructor"));
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolveConstructor(@NotNull PsiClassType type, @NotNull PsiExpressionList argumentList, @NotNull PsiElement place) {
        MethodResolverProcessor processor;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        PsiClassType.ClassResolveResult classResolveResult = type.resolveGenerics();
        PsiClass aClass = classResolveResult.getElement();
        if (aClass == null) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
        if (argumentList.getParent() instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymous = (PsiAnonymousClass)argumentList.getParent();
            processor = new MethodResolverProcessor(anonymous, argumentList, place, place.getContainingFile());
            aClass = anonymous.getBaseClassType().resolve();
            if (aClass == null) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            substitutor = substitutor.putAll(TypeConversionUtil.getSuperClassSubstitutor(aClass, anonymous, substitutor));
        } else {
            processor = new MethodResolverProcessor(aClass, argumentList, place, place.getContainingFile());
        }
        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor);
        for (PsiMethod constructor : aClass.getConstructors()) {
            if (!processor.execute(constructor, state)) break;
        }
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "multiResolveConstructor"));
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiClass resolveReferencedClass(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveReferencedClass"));
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            LOG.assertTrue(ref.isValid(), referenceText);
            return ResolveClassUtil.resolveClass(ref);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public PsiVariable resolveReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveReferencedVariable"));
        }
        return this.resolveVar(referenceText, context, null);
    }

    @Override
    public PsiVariable resolveAccessibleReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "resolveAccessibleReferencedVariable"));
        }
        boolean[] problemWithAccess = new boolean[1];
        PsiVariable variable = this.resolveVar(referenceText, context, problemWithAccess);
        return problemWithAccess[0] ? null : variable;
    }

    @Nullable
    private PsiVariable resolveVar(String referenceText, PsiElement context, boolean[] problemWithAccess) {
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            return ResolveVariableUtil.resolveVariable(ref, problemWithAccess, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        return this.isAccessible(member, member.getModifierList(), place, accessObjectClass, null);
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member, @Nullable PsiModifierList modifierList, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement currentFileResolveScope) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "isAccessible"));
        }
        PsiClass containingClass = member.getContainingClass();
        return JavaResolveUtil.isAccessible(member, containingClass, modifierList, place, accessObjectClass, currentFileResolveScope);
    }

    @Override
    @NotNull
    public CandidateInfo[] getReferencedMethodCandidates(@NotNull PsiCallExpression expr, boolean dummyImplicitConstructor, final boolean checkVarargs) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        PsiFile containingFile = expr.getContainingFile();
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(expr, containingFile){

            @Override
            protected boolean acceptVarargs() {
                return checkVarargs;
            }
        };
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, expr, dummyImplicitConstructor);
        }
        catch (MethodProcessorSetupFailedException e) {
            if (CandidateInfo.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
            }
            return CandidateInfo.EMPTY_ARRAY;
        }
        CandidateInfo[] candidateInfoArray = processor.getCandidates();
        if (candidateInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        return candidateInfoArray;
    }

    @Override
    @NotNull
    public CandidateInfo[] getReferencedMethodCandidates(@NotNull PsiCallExpression call, boolean dummyImplicitConstructor) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        CandidateInfo[] candidateInfoArray = this.getReferencedMethodCandidates(call, dummyImplicitConstructor, false);
        if (candidateInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "getReferencedMethodCandidates"));
        }
        return candidateInfoArray;
    }

    @Override
    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeForMethodTypeParameter"));
        }
        return this.getInferenceHelper(PsiUtil.getLanguageLevel(parent != null ? parent : typeParameter)).inferTypeForMethodTypeParameter(typeParameter, parameters, arguments, partialSubstitutor, parent, policy);
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(PsiUtil.getLanguageLevel(parent)).inferTypeArguments(typeParameters, parameters, arguments, partialSubstitutor, parent, policy, PsiUtil.getLanguageLevel(parent));
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters, parameters, arguments, partialSubstitutor, parent, policy, languageLevel);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (leftTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (rightTypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters, leftTypes, rightTypes, languageLevel);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        return this.getInferenceHelper(languageLevel).getSubstitutionForTypeParameter(typeParam, param, arg, isContraVariantPosition, languageLevel);
    }

    public void setTestHelper(PsiInferenceHelper testHelper) {
        this.myTestHelper = testHelper;
    }

    public PsiInferenceHelper getInferenceHelper(LanguageLevel languageLevel) {
        if (ApplicationManager.getApplication().isUnitTestMode() && this.myTestHelper != null) {
            return this.myTestHelper;
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return new PsiGraphInferenceHelper(this.myManager);
        }
        return new PsiOldInferenceHelper(this.myManager);
    }
}

