/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ExceptionUtil;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiInvalidElementAccessException
extends RuntimeException {
    private static final Key<Object> INVALIDATION_TRACE = Key.create("TRACK_INVALIDATION_KEY");
    private final SoftReference<PsiElement> myElementReference;

    public PsiInvalidElementAccessException(PsiElement element) {
        this(element, (String)null);
    }

    public PsiInvalidElementAccessException(PsiElement element, @Nullable String message) {
        this(element, PsiInvalidElementAccessException.getMessageWithReason(element, message), null);
    }

    public PsiInvalidElementAccessException(PsiElement element, @Nullable Throwable cause) {
        this(element, PsiInvalidElementAccessException.getMessageWithReason(element, null), cause);
    }

    public PsiInvalidElementAccessException(PsiElement element, @Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
        this.myElementReference = new SoftReference<PsiElement>(element);
    }

    private static String getMessageWithReason(@Nullable PsiElement element, @Nullable String message) {
        return (element == null ? "Unknown psi element" : "Element: " + element.getClass() + " because: " + PsiInvalidElementAccessException.reason(element) + PsiInvalidElementAccessException.invalidationTraceText(element)) + (message == null ? "" : "; " + message);
    }

    public static Object findInvalidationTrace(ASTNode element) {
        while (element != null) {
            Object trace = element.getUserData(INVALIDATION_TRACE);
            if (trace != null) {
                return trace;
            }
            element = element.getTreeParent();
        }
        return null;
    }

    private static String invalidationTraceText(PsiElement element) {
        Object trace = PsiInvalidElementAccessException.findInvalidationTrace(element.getNode());
        return "\ninvalidated at: " + (!PsiInvalidElementAccessException.isTrackingInvalidation() ? "disabled" : (trace instanceof Throwable ? ExceptionUtil.getThrowableText((Throwable)trace) : (trace != null ? trace : "no info")));
    }

    @NonNls
    @NotNull
    private static String reason(@NotNull PsiElement root) {
        PsiFile file;
        PsiElement element;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/PsiInvalidElementAccessException", "reason"));
        }
        if (root == PsiUtilCore.NULL_PSI_ELEMENT) {
            if ("NULL_PSI_ELEMENT" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return "NULL_PSI_ELEMENT";
        }
        PsiElement psiElement = element = root instanceof PsiFile ? root : root.getParent();
        if (element == null) {
            if ("parent is null" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return "parent is null";
        }
        while (element != null && !(element instanceof PsiFile) && element.getParent() != null) {
            element = element.getParent();
        }
        PsiFile psiFile = file = element instanceof PsiFile ? (PsiFile)element : null;
        if (file == null) {
            if ("containing file is null" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return "containing file is null";
        }
        FileViewProvider provider = file.getViewProvider();
        VirtualFile vFile = provider.getVirtualFile();
        if (!vFile.isValid()) {
            String string = vFile + " is invalid";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return string;
        }
        if (!provider.isPhysical()) {
            PsiElement context = file.getContext();
            if (context != null && !context.isValid()) {
                String string = "invalid context: " + PsiInvalidElementAccessException.reason(context);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiInvalidElementAccessException", "reason"));
                }
                return string;
            }
            String string = "non-physical provider: " + provider;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return string;
        }
        PsiManager manager = file.getManager();
        if (manager.getProject().isDisposed()) {
            if ("project is disposed" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return "project is disposed";
        }
        Language language = file.getLanguage();
        if (language != provider.getBaseLanguage()) {
            String string = "File language:" + language + " != Provider base language:" + provider.getBaseLanguage();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return string;
        }
        FileViewProvider provider1 = manager.findViewProvider(vFile);
        if (provider != provider1) {
            String string = "different providers: " + provider + "(" + Integer.toHexString(System.identityHashCode(provider)) + "); " + provider1 + "(" + Integer.toHexString(System.identityHashCode(provider1)) + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiInvalidElementAccessException", "reason"));
            }
            return string;
        }
        if ("psi is outdated" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiInvalidElementAccessException", "reason"));
        }
        return "psi is outdated";
    }

    public static void setInvalidationTrace(ASTNode element, Object trace) {
        element.putUserData(INVALIDATION_TRACE, trace);
    }

    public static boolean isTrackingInvalidation() {
        return Registry.is("psi.track.invalidation", true);
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myElementReference.get();
    }
}

