/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.operation.IncrementTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public final class OverloadedIncrementTranslator
extends IncrementTranslator {
    @NotNull
    private final FunctionDescriptor operationDescriptor;

    OverloadedIncrementTranslator(@NotNull JetUnaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/operation/OverloadedIncrementTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/k2js/translate/operation/OverloadedIncrementTranslator", "<init>"));
        }
        super(expression, context);
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(context.bindingContext(), expression);
        assert (functionDescriptor != null) : "Descriptor should not be null for overloaded increment expression.";
        this.operationDescriptor = functionDescriptor;
    }

    @Override
    @NotNull
    protected JsExpression operationExpression(@NotNull JsExpression receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/k2js/translate/operation/OverloadedIncrementTranslator", "operationExpression"));
        }
        JsExpression jsExpression = CallBuilder.build(this.context()).receiver(receiver).descriptor(this.operationDescriptor).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/OverloadedIncrementTranslator", "operationExpression"));
        }
        return jsExpression;
    }
}

