/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetPostfixExpression;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.jet.lang.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lexer.JetTokens;

public class ControlStructureTypingUtils {
    private ControlStructureTypingUtils() {
    }

    static ResolvedCall<FunctionDescriptor> resolveSpecialConstructionAsCall(@NotNull Call call, @NotNull String constructionName, @NotNull List<String> argumentNames, @NotNull List<Boolean> isArgumentNullable, @NotNull ExpressionTypingContext context, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "resolveSpecialConstructionAsCall"));
        }
        if (constructionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "resolveSpecialConstructionAsCall"));
        }
        if (argumentNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "resolveSpecialConstructionAsCall"));
        }
        if (isArgumentNullable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "resolveSpecialConstructionAsCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "resolveSpecialConstructionAsCall"));
        }
        SimpleFunctionDescriptorImpl function = ControlStructureTypingUtils.createFunctionDescriptorForSpecialConstruction(constructionName.toUpperCase(), argumentNames, isArgumentNullable);
        JetSimpleNameExpression reference = JetPsiFactory.createSimpleName(context.expressionTypingServices.getProject(), "fake" + constructionName + "Call");
        TracingStrategy tracing = ControlStructureTypingUtils.createTracingForSpecialConstruction(call, constructionName);
        ResolutionCandidate<CallableDescriptor> resolutionCandidate = ResolutionCandidate.create(function, null);
        CallResolver callResolver = context.expressionTypingServices.getCallResolver();
        OverloadResolutionResults<FunctionDescriptor> results = callResolver.resolveCallWithKnownCandidate(call, tracing, reference, context, resolutionCandidate, dataFlowInfoForArguments);
        assert (results.isSingleResult()) : "Not single result after resolving one known candidate";
        return results.getResultingCall();
    }

    private static SimpleFunctionDescriptorImpl createFunctionDescriptorForSpecialConstruction(@NotNull String constructionName, @NotNull List<String> argumentNames, @NotNull List<Boolean> isArgumentNullable) {
        if (constructionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "createFunctionDescriptorForSpecialConstruction"));
        }
        if (argumentNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "createFunctionDescriptorForSpecialConstruction"));
        }
        if (isArgumentNullable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "createFunctionDescriptorForSpecialConstruction"));
        }
        assert (argumentNames.size() == isArgumentNullable.size());
        List<AnnotationDescriptor> noAnnotations = Collections.emptyList();
        Name specialFunctionName = Name.identifierNoValidate("<SPECIAL-FUNCTION-FOR-" + constructionName + "-RESOLVE>");
        SimpleFunctionDescriptorImpl function = new SimpleFunctionDescriptorImpl(ErrorUtils.getErrorModule(), noAnnotations, specialFunctionName, CallableMemberDescriptor.Kind.DECLARATION);
        TypeParameterDescriptor typeParameter = TypeParameterDescriptorImpl.createWithDefaultBound(function, noAnnotations, false, Variance.INVARIANT, Name.identifierNoValidate("<TYPE-PARAMETER-FOR-" + constructionName + "-RESOLVE>"), 0);
        JetTypeImpl type = new JetTypeImpl(typeParameter.getTypeConstructor(), JetScope.EMPTY);
        JetTypeImpl nullableType = new JetTypeImpl(noAnnotations, typeParameter.getTypeConstructor(), true, Collections.emptyList(), JetScope.EMPTY);
        ArrayList<ValueParameterDescriptor> valueParameters = Lists.newArrayList();
        for (int i = 0; i < argumentNames.size(); ++i) {
            JetTypeImpl argumentType = isArgumentNullable.get(i) != false ? nullableType : type;
            ValueParameterDescriptorImpl valueParameter = new ValueParameterDescriptorImpl(function, i, noAnnotations, Name.identifier(argumentNames.get(i)), argumentType, false, null);
            valueParameters.add(valueParameter);
        }
        function.initialize(null, ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, Lists.newArrayList(typeParameter), valueParameters, type, Modality.FINAL, Visibilities.PUBLIC, false);
        return function;
    }

    static MutableDataFlowInfoForArguments createIndependentDataFlowInfoForArgumentsForCall(final Map<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap) {
        return new MutableDataFlowInfoForArguments(){
            private DataFlowInfo initialDataFlowInfo;

            @Override
            public void setInitialDataFlowInfo(@NotNull DataFlowInfo dataFlowInfo) {
                if (dataFlowInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$1", "setInitialDataFlowInfo"));
                }
                this.initialDataFlowInfo = dataFlowInfo;
            }

            @Override
            public void updateInfo(@NotNull ValueArgument valueArgument, @NotNull DataFlowInfo dataFlowInfo) {
                if (valueArgument == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$1", "updateInfo"));
                }
                if (dataFlowInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$1", "updateInfo"));
                }
            }

            @Override
            @NotNull
            public DataFlowInfo getInfo(@NotNull ValueArgument valueArgument) {
                if (valueArgument == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$1", "getInfo"));
                }
                DataFlowInfo dataFlowInfo = (DataFlowInfo)dataFlowInfoForArgumentsMap.get(valueArgument);
                if (dataFlowInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$1", "getInfo"));
                }
                return dataFlowInfo;
            }

            @Override
            @NotNull
            public DataFlowInfo getResultInfo() {
                DataFlowInfo dataFlowInfo = this.initialDataFlowInfo;
                if (dataFlowInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$1", "getResultInfo"));
                }
                return dataFlowInfo;
            }
        };
    }

    public static MutableDataFlowInfoForArguments createDataFlowInfoForArgumentsForIfCall(@NotNull Call callForIf, @NotNull DataFlowInfo thenInfo, @NotNull DataFlowInfo elseInfo) {
        if (callForIf == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "createDataFlowInfoForArgumentsForIfCall"));
        }
        if (thenInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "createDataFlowInfoForArgumentsForIfCall"));
        }
        if (elseInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "createDataFlowInfoForArgumentsForIfCall"));
        }
        HashMap<ValueArgument, DataFlowInfo> dataFlowInfoForArgumentsMap = Maps.newHashMap();
        dataFlowInfoForArgumentsMap.put(callForIf.getValueArguments().get(0), thenInfo);
        dataFlowInfoForArgumentsMap.put(callForIf.getValueArguments().get(1), elseInfo);
        return ControlStructureTypingUtils.createIndependentDataFlowInfoForArgumentsForCall(dataFlowInfoForArgumentsMap);
    }

    static Call createCallForSpecialConstruction(final @NotNull JetExpression expression, @NotNull List<? extends JetExpression> arguments) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "createCallForSpecialConstruction"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "createCallForSpecialConstruction"));
        }
        final ArrayList<ValueArgument> valueArguments = Lists.newArrayList();
        for (JetExpression jetExpression : arguments) {
            valueArguments.add(CallMaker.makeValueArgument(jetExpression, jetExpression));
        }
        return new Call(){

            @Override
            @Nullable
            public ASTNode getCallOperationNode() {
                return expression.getNode();
            }

            @Override
            @NotNull
            public ReceiverValue getExplicitReceiver() {
                ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
                if (receiverValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$2", "getExplicitReceiver"));
                }
                return receiverValue;
            }

            @Override
            @NotNull
            public ReceiverValue getThisObject() {
                ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
                if (receiverValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$2", "getThisObject"));
                }
                return receiverValue;
            }

            @Override
            @Nullable
            public JetExpression getCalleeExpression() {
                return expression;
            }

            @Override
            @Nullable
            public JetValueArgumentList getValueArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                List list2 = valueArguments;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$2", "getValueArguments"));
                }
                return list2;
            }

            @Override
            @NotNull
            public List<JetExpression> getFunctionLiteralArguments() {
                List<JetExpression> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$2", "getFunctionLiteralArguments"));
                }
                return list2;
            }

            @Override
            @NotNull
            public List<JetTypeProjection> getTypeArguments() {
                List<JetTypeProjection> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$2", "getTypeArguments"));
                }
                return list2;
            }

            @Override
            @Nullable
            public JetTypeArgumentList getTypeArgumentList() {
                return null;
            }

            @Override
            @NotNull
            public PsiElement getCallElement() {
                JetExpression jetExpression = expression;
                if (jetExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$2", "getCallElement"));
                }
                return jetExpression;
            }

            @Override
            @NotNull
            public Call.CallType getCallType() {
                Call.CallType callType = Call.CallType.DEFAULT;
                if (callType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$2", "getCallType"));
                }
                return callType;
            }
        };
    }

    static TracingStrategy createTracingForSpecialConstruction(final @NotNull Call call, @NotNull String constructionName) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "createTracingForSpecialConstruction"));
        }
        if (constructionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils", "createTracingForSpecialConstruction"));
        }
        class CheckTypeContext {
            public BindingTrace trace;
            public JetType expectedType;

            CheckTypeContext(@NotNull BindingTrace trace, @NotNull JetType expectedType) {
                if (trace == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$1CheckTypeContext", "<init>"));
                }
                if (expectedType == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$1CheckTypeContext", "<init>"));
                }
                this.trace = trace;
                this.expectedType = expectedType;
            }

            CheckTypeContext makeTypeNullable() {
                if (TypeUtils.noExpectedType(this.expectedType)) {
                    return this;
                }
                return new CheckTypeContext(this.trace, TypeUtils.makeNullable(this.expectedType));
            }
        }
        final JetVisitor<Void, CheckTypeContext> checkTypeVisitor = new JetVisitor<Void, CheckTypeContext>(){

            private void checkExpressionType(@Nullable JetExpression expression, CheckTypeContext c) {
                if (expression == null) {
                    return;
                }
                expression.accept(this, c);
            }

            @Override
            public Void visitIfExpression(@NotNull JetIfExpression ifExpression, CheckTypeContext c) {
                if (ifExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$3", "visitIfExpression"));
                }
                this.checkExpressionType(ifExpression.getThen(), c);
                this.checkExpressionType(ifExpression.getElse(), c);
                return null;
            }

            @Override
            public Void visitBlockExpression(@NotNull JetBlockExpression expression, CheckTypeContext c) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$3", "visitBlockExpression"));
                }
                if (expression.getStatements().isEmpty()) {
                    this.visitExpression((JetExpression)expression, c);
                    return null;
                }
                JetElement lastStatement = JetPsiUtil.getLastStatementInABlock(expression);
                if (lastStatement instanceof JetExpression) {
                    this.checkExpressionType((JetExpression)lastStatement, c);
                }
                return null;
            }

            @Override
            public Void visitPostfixExpression(@NotNull JetPostfixExpression expression, CheckTypeContext c) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$3", "visitPostfixExpression"));
                }
                if (expression.getOperationReference().getReferencedNameElementType() == JetTokens.EXCLEXCL) {
                    this.checkExpressionType(expression.getBaseExpression(), c.makeTypeNullable());
                    return null;
                }
                return (Void)super.visitPostfixExpression(expression, c);
            }

            @Override
            public Void visitBinaryExpression(@NotNull JetBinaryExpression expression, CheckTypeContext c) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$3", "visitBinaryExpression"));
                }
                if (expression.getOperationReference().getReferencedNameElementType() == JetTokens.ELVIS) {
                    this.checkExpressionType(expression.getLeft(), c.makeTypeNullable());
                    this.checkExpressionType(expression.getRight(), c);
                    return null;
                }
                return (Void)super.visitBinaryExpression(expression, c);
            }

            @Override
            public Void visitExpression(@NotNull JetExpression expression, CheckTypeContext c) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$3", "visitExpression"));
                }
                JetTypeInfo typeInfo = BindingContextUtils.getRecordedTypeInfo(expression, c.trace.getBindingContext());
                if (typeInfo != null) {
                    DataFlowUtils.checkType(typeInfo.getType(), expression, c.expectedType, typeInfo.getDataFlowInfo(), c.trace);
                }
                return null;
            }
        };
        return new ThrowingOnErrorTracingStrategy("resolve " + constructionName + " as a call"){

            @Override
            public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCallWithTrace<D> resolvedCall) {
                if (trace == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$4", "bindReference"));
                }
                if (resolvedCall == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$4", "bindReference"));
                }
            }

            @Override
            public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCallWithTrace<D> resolvedCall) {
                if (trace == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$4", "bindResolvedCall"));
                }
                if (resolvedCall == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$4", "bindResolvedCall"));
                }
                trace.record(BindingContext.RESOLVED_CALL, call.getCalleeExpression(), resolvedCall);
                trace.record(BindingContext.CALL, call.getCalleeExpression(), call);
            }

            @Override
            public void typeInferenceFailed(@NotNull BindingTrace trace, @NotNull InferenceErrorData data2) {
                if (trace == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$4", "typeInferenceFailed"));
                }
                if (data2 == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$4", "typeInferenceFailed"));
                }
                ConstraintSystem constraintSystem = data2.constraintSystem;
                ConstraintSystemStatus status = constraintSystem.getStatus();
                assert (!status.isSuccessful()) : "Report error only for not successful constraint system";
                if (status.hasErrorInConstrainingTypes()) {
                    return;
                }
                JetExpression expression = call.getCalleeExpression();
                if (expression == null) {
                    return;
                }
                if (status.hasOnlyErrorsFromPosition(ConstraintPosition.EXPECTED_TYPE_POSITION) || status.hasConflictingConstraints()) {
                    expression.accept(checkTypeVisitor, new CheckTypeContext(trace, data2.expectedType));
                    return;
                }
                this.throwError("Expression: " + expression.getText() + ".\nConstraint system status: \n" + ConstraintsUtil.getDebugMessageForStatus(status));
                super.typeInferenceFailed(trace, data2);
            }
        };
    }

    private static abstract class ThrowingOnErrorTracingStrategy
    implements TracingStrategy {
        private final String debugName;

        protected ThrowingOnErrorTracingStrategy(String debugName) {
            this.debugName = debugName;
        }

        private void throwError() {
            this.throwError(null);
        }

        protected void throwError(@Nullable String additionalInformation) {
            String errorMessage = "Resolution error of this type shouldn't occur for " + this.debugName;
            if (additionalInformation != null) {
                errorMessage = errorMessage + ".\n" + additionalInformation;
            }
            throw new IllegalStateException(errorMessage);
        }

        @Override
        public void unresolvedReference(@NotNull BindingTrace trace) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unresolvedReference"));
            }
            this.throwError();
        }

        @Override
        public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> candidates) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unresolvedReferenceWrongReceiver"));
            }
            if (candidates == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unresolvedReferenceWrongReceiver"));
            }
            this.throwError();
        }

        @Override
        public <D extends CallableDescriptor> void recordAmbiguity(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> candidates) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "recordAmbiguity"));
            }
            if (candidates == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "recordAmbiguity"));
            }
            this.throwError();
        }

        @Override
        public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "missingReceiver"));
            }
            if (expectedReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "missingReceiver"));
            }
            this.throwError();
        }

        @Override
        public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "wrongReceiverType"));
            }
            if (receiverParameter == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "wrongReceiverType"));
            }
            if (receiverArgument == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "wrongReceiverType"));
            }
            this.throwError();
        }

        @Override
        public void noReceiverAllowed(@NotNull BindingTrace trace) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "noReceiverAllowed"));
            }
            this.throwError();
        }

        @Override
        public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "noValueForParameter"));
            }
            if (valueParameter == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "noValueForParameter"));
            }
            this.throwError();
        }

        @Override
        public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "wrongNumberOfTypeArguments"));
            }
            this.throwError();
        }

        @Override
        public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> descriptors) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "ambiguity"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "ambiguity"));
            }
            this.throwError();
        }

        @Override
        public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> descriptors) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "noneApplicable"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "noneApplicable"));
            }
            this.throwError();
        }

        @Override
        public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> descriptors) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "cannotCompleteResolve"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "cannotCompleteResolve"));
            }
            this.throwError();
        }

        @Override
        public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "instantiationOfAbstractClass"));
            }
            this.throwError();
        }

        @Override
        public void unsafeCall(@NotNull BindingTrace trace, @NotNull JetType type, boolean isCallForImplicitInvoke) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unsafeCall"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unsafeCall"));
            }
            this.throwError();
        }

        @Override
        public void unnecessarySafeCall(@NotNull BindingTrace trace, @NotNull JetType type) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unnecessarySafeCall"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "unnecessarySafeCall"));
            }
            this.throwError();
        }

        @Override
        public void danglingFunctionLiteralArgumentSuspected(@NotNull BindingTrace trace, @NotNull List<JetExpression> functionLiteralArguments) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "danglingFunctionLiteralArgumentSuspected"));
            }
            if (functionLiteralArguments == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "danglingFunctionLiteralArgumentSuspected"));
            }
            this.throwError();
        }

        @Override
        public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "invisibleMember"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "invisibleMember"));
            }
            this.throwError();
        }

        @Override
        public void typeInferenceFailed(@NotNull BindingTrace trace, @NotNull InferenceErrorData inferenceErrorData) {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "typeInferenceFailed"));
            }
            if (inferenceErrorData == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/expressions/ControlStructureTypingUtils$ThrowingOnErrorTracingStrategy", "typeInferenceFailed"));
            }
            this.throwError();
        }
    }
}

