/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitution;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.utils.DFS;

public class DescriptorSubstitutor {
    private static final Function<TypeProjection, JetType> PROJECTIONS_TO_TYPES = new Function<TypeProjection, JetType>(){

        @Override
        public JetType apply(TypeProjection projection) {
            return projection.getType();
        }
    };

    @NotNull
    public static TypeSubstitutor substituteTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters, final @NotNull TypeSubstitutor originalSubstitutor, @NotNull DeclarationDescriptor newContainingDeclaration, @NotNull List<TypeParameterDescriptor> result) {
        TypeParameterDescriptorImpl substituted;
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/DescriptorSubstitutor", "substituteTypeParameters"));
        }
        if (originalSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/types/DescriptorSubstitutor", "substituteTypeParameters"));
        }
        if (newContainingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/types/DescriptorSubstitutor", "substituteTypeParameters"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/types/DescriptorSubstitutor", "substituteTypeParameters"));
        }
        final HashMap<TypeConstructor, TypeProjectionImpl> mutableSubstitution = Maps.newHashMap();
        TypeSubstitutor substitutor = TypeSubstitutor.create(new TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                if (originalSubstitutor.inRange(key)) {
                    return originalSubstitutor.getSubstitution().get(key);
                }
                return (TypeProjection)mutableSubstitution.get(key);
            }

            @Override
            public boolean isEmpty() {
                return originalSubstitutor.isEmpty() && mutableSubstitution.isEmpty();
            }

            public String toString() {
                return "DescriptorSubstitutor.substituteTypeParameters(" + mutableSubstitution + " / " + originalSubstitutor.getSubstitution() + ")";
            }
        });
        HashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl> substitutedMap = Maps.newHashMap();
        for (TypeParameterDescriptor descriptor : typeParameters) {
            substituted = TypeParameterDescriptorImpl.createForFurtherModification(newContainingDeclaration, descriptor.getAnnotations(), descriptor.isReified(), descriptor.getVariance(), descriptor.getName(), descriptor.getIndex());
            substituted.setInitialized();
            mutableSubstitution.put(descriptor.getTypeConstructor(), new TypeProjectionImpl(substituted.getDefaultType()));
            substitutedMap.put(descriptor, substituted);
            result.add(substituted);
        }
        for (TypeParameterDescriptor descriptor : typeParameters) {
            substituted = (TypeParameterDescriptorImpl)substitutedMap.get(descriptor);
            for (JetType upperBound : descriptor.getUpperBounds()) {
                substituted.getUpperBounds().add(substitutor.substitute(upperBound, Variance.INVARIANT));
            }
        }
        TypeSubstitutor typeSubstitutor = substitutor;
        if (typeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DescriptorSubstitutor", "substituteTypeParameters"));
        }
        return typeSubstitutor;
    }

    @NotNull
    public static TypeSubstitutor createUpperBoundsSubstitutor(@NotNull List<TypeParameterDescriptor> typeParameters) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/types/DescriptorSubstitutor", "createUpperBoundsSubstitutor"));
        }
        HashMap<TypeConstructor, TypeProjection> mutableSubstitution = Maps.newHashMap();
        TypeSubstitutor substitutor = TypeSubstitutor.create(mutableSubstitution);
        for (TypeParameterDescriptor descriptor : DescriptorSubstitutor.topologicallySortTypeParameters(typeParameters)) {
            JetType upperBoundsAsType = descriptor.getUpperBoundsAsType();
            JetType substitutedUpperBoundsAsType = substitutor.substitute(upperBoundsAsType, Variance.INVARIANT);
            mutableSubstitution.put(descriptor.getTypeConstructor(), new TypeProjectionImpl(substitutedUpperBoundsAsType));
        }
        TypeSubstitutor typeSubstitutor = substitutor;
        if (typeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DescriptorSubstitutor", "createUpperBoundsSubstitutor"));
        }
        return typeSubstitutor;
    }

    private static List<TypeParameterDescriptor> topologicallySortTypeParameters(final List<TypeParameterDescriptor> typeParameters) {
        List<TypeParameterDescriptor> topOrder = DFS.topologicalOrder(typeParameters, new DFS.Neighbors<TypeParameterDescriptor>(){

            @Override
            @NotNull
            public Iterable<TypeParameterDescriptor> getNeighbors(TypeParameterDescriptor current) {
                List list2 = DescriptorSubstitutor.getTypeParametersFromUpperBounds(current, typeParameters);
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DescriptorSubstitutor$3", "getNeighbors"));
                }
                return list2;
            }
        });
        assert (topOrder.size() == typeParameters.size()) : "All type parameters must be visited, but only " + topOrder + " were";
        Collections.reverse(topOrder);
        return topOrder;
    }

    private static List<TypeParameterDescriptor> getTypeParametersFromUpperBounds(TypeParameterDescriptor current, final List<TypeParameterDescriptor> typeParameters) {
        return DFS.dfs(current.getUpperBounds(), new DFS.Neighbors<JetType>(){

            @Override
            @NotNull
            public Iterable<JetType> getNeighbors(JetType current) {
                Collection<JetType> collection = Collections2.transform(current.getArguments(), PROJECTIONS_TO_TYPES);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/DescriptorSubstitutor$4", "getNeighbors"));
                }
                return collection;
            }
        }, new DFS.NodeHandlerWithListResult<JetType, TypeParameterDescriptor>(){

            @Override
            public void beforeChildren(JetType current) {
                ClassifierDescriptor declarationDescriptor = current.getConstructor().getDeclarationDescriptor();
                if (typeParameters.contains(declarationDescriptor)) {
                    this.result.add((TypeParameterDescriptor)declarationDescriptor);
                }
            }
        });
    }
}

