/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure;

import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;

public interface JavaTypeSubstitutor {
    public static final JavaTypeSubstitutor EMPTY = new JavaTypeSubstitutor(){

        @Override
        @NotNull
        public JavaType substitute(@NotNull JavaType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/JavaTypeSubstitutor$1", "substitute"));
            }
            JavaType javaType = type;
            if (javaType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/JavaTypeSubstitutor$1", "substitute"));
            }
            return javaType;
        }

        @Override
        @Nullable
        public JavaType substitute(@NotNull JavaTypeParameter typeParameter) {
            if (typeParameter == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/structure/JavaTypeSubstitutor$1", "substitute"));
            }
            return typeParameter.getType();
        }

        @Override
        @NotNull
        public Map<JavaTypeParameter, JavaType> getSubstitutionMap() {
            Map<JavaTypeParameter, JavaType> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/JavaTypeSubstitutor$1", "getSubstitutionMap"));
            }
            return map;
        }

        public String toString() {
            return "Empty JavaTypeSubstitutor";
        }
    };

    @NotNull
    public JavaType substitute(@NotNull JavaType var1);

    @Nullable
    public JavaType substitute(@NotNull JavaTypeParameter var1);

    @NotNull
    public Map<JavaTypeParameter, JavaType> getSubstitutionMap();
}

