/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class NamedMembers {
    @NotNull
    private final Name name;
    @NotNull
    private final List<JavaMethod> methods;
    @NotNull
    private final List<JavaField> fields;
    @Nullable
    private JavaClass samInterface;

    public NamedMembers(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/NamedMembers", "<init>"));
        }
        this.methods = new ArrayList<JavaMethod>();
        this.fields = new ArrayList<JavaField>();
        this.name = name;
    }

    void addMethod(@NotNull JavaMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/NamedMembers", "addMethod"));
        }
        this.methods.add(method);
    }

    void addField(@NotNull JavaField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/NamedMembers", "addField"));
        }
        this.fields.add(field);
    }

    void setSamInterface(@NotNull JavaClass samInterface) {
        if (samInterface == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/scope/NamedMembers", "setSamInterface"));
        }
        this.samInterface = samInterface;
    }

    @NotNull
    public Name getName() {
        Name name = this.name;
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/NamedMembers", "getName"));
        }
        return name;
    }

    @NotNull
    public List<JavaMethod> getMethods() {
        List<JavaMethod> list2 = this.methods;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/NamedMembers", "getMethods"));
        }
        return list2;
    }

    @NotNull
    public List<JavaField> getFields() {
        List<JavaField> list2 = this.fields;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/scope/NamedMembers", "getFields"));
        }
        return list2;
    }

    @Nullable
    public JavaClass getSamInterface() {
        return this.samInterface;
    }
}

