/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolverImpl;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class JavaSupertypeResolver {
    public static final FqName OBJECT_FQ_NAME = new FqName("java.lang.Object");
    private JavaTypeTransformer typeTransformer;
    private JavaClassResolver classResolver;

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    public void setClassResolver(JavaClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @NotNull
    public Collection<JetType> getSupertypes(@NotNull ClassDescriptor classDescriptor, @NotNull JavaClass javaClass, @NotNull List<TypeParameterDescriptor> typeParameters) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaSupertypeResolver", "getSupertypes"));
        }
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaSupertypeResolver", "getSupertypes"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/resolver/JavaSupertypeResolver", "getSupertypes"));
        }
        TypeVariableResolverImpl typeVariableResolver = new TypeVariableResolverImpl(typeParameters, classDescriptor);
        List<JetType> result = this.transformSupertypeList(javaClass.getSupertypes(), typeVariableResolver);
        List<JetType> list2 = result.isEmpty() ? Collections.singletonList(this.getDefaultSupertype(javaClass)) : result;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaSupertypeResolver", "getSupertypes"));
        }
        return list2;
    }

    @NotNull
    private JetType getDefaultSupertype(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaSupertypeResolver", "getDefaultSupertype"));
        }
        if (OBJECT_FQ_NAME.equals(javaClass.getFqName()) || javaClass.isAnnotationType()) {
            JetType jetType = KotlinBuiltIns.getInstance().getAnyType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaSupertypeResolver", "getDefaultSupertype"));
            }
            return jetType;
        }
        ClassDescriptor object2 = this.classResolver.resolveClass(OBJECT_FQ_NAME, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        if (object2 != null) {
            JetType jetType = object2.getDefaultType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaSupertypeResolver", "getDefaultSupertype"));
            }
            return jetType;
        }
        JetType jetType = KotlinBuiltIns.getInstance().getAnyType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaSupertypeResolver", "getDefaultSupertype"));
        }
        return jetType;
    }

    @NotNull
    private List<JetType> transformSupertypeList(@NotNull Collection<JavaClassifierType> supertypes, @NotNull TypeVariableResolver typeVariableResolver) {
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/JavaSupertypeResolver", "transformSupertypeList"));
        }
        if (typeVariableResolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/java/resolver/JavaSupertypeResolver", "transformSupertypeList"));
        }
        ArrayList<JetType> result = new ArrayList<JetType>(supertypes.size());
        for (JavaClassifierType type : supertypes) {
            JetType transformed2 = this.typeTransformer.transformToType(type, TypeUsage.SUPERTYPE, typeVariableResolver);
            if (transformed2.isError()) continue;
            result.add(TypeUtils.makeNotNullable(transformed2));
        }
        ArrayList<JetType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaSupertypeResolver", "transformSupertypeList"));
        }
        return arrayList;
    }
}

