/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.types.JetType;

public interface ExternalSignatureResolver {
    @NotNull
    public PropagatedMethodSignature resolvePropagatedSignature(@NotNull JavaMethod var1, @NotNull ClassDescriptor var2, @NotNull JetType var3, @Nullable JetType var4, @NotNull List<ValueParameterDescriptor> var5, @NotNull List<TypeParameterDescriptor> var6);

    @NotNull
    public AlternativeMethodSignature resolveAlternativeMethodSignature(@NotNull JavaMethod var1, boolean var2, @Nullable JetType var3, @Nullable JetType var4, @NotNull List<ValueParameterDescriptor> var5, @NotNull List<TypeParameterDescriptor> var6);

    @NotNull
    public AlternativeFieldSignature resolveAlternativeFieldSignature(@NotNull JavaField var1, @NotNull JetType var2, boolean var3);

    public void reportSignatureErrors(@NotNull CallableMemberDescriptor var1, @NotNull List<String> var2);

    public static class PropagatedMethodSignature
    extends AlternativeMethodSignature {
        private final List<FunctionDescriptor> superMethods;

        public PropagatedMethodSignature(@Nullable JetType returnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<String> signatureErrors, @NotNull List<FunctionDescriptor> superMethods) {
            if (valueParameters == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$PropagatedMethodSignature", "<init>"));
            }
            if (typeParameters == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$PropagatedMethodSignature", "<init>"));
            }
            if (signatureErrors == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$PropagatedMethodSignature", "<init>"));
            }
            if (superMethods == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$PropagatedMethodSignature", "<init>"));
            }
            super(returnType, receiverType, valueParameters, typeParameters, signatureErrors);
            this.superMethods = superMethods;
        }

        @NotNull
        public List<FunctionDescriptor> getSuperMethods() {
            List<FunctionDescriptor> list2 = this.superMethods;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$PropagatedMethodSignature", "getSuperMethods"));
            }
            return list2;
        }
    }

    public static class AlternativeFieldSignature
    extends MemberSignature {
        private final JetType returnType;

        public AlternativeFieldSignature(@NotNull JetType returnType, @Nullable String signatureError) {
            if (returnType == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$AlternativeFieldSignature", "<init>"));
            }
            super(signatureError == null ? Collections.emptyList() : Collections.singletonList(signatureError));
            this.returnType = returnType;
        }

        @NotNull
        public JetType getReturnType() {
            JetType jetType = this.returnType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$AlternativeFieldSignature", "getReturnType"));
            }
            return jetType;
        }
    }

    public static class AlternativeMethodSignature
    extends MemberSignature {
        private final JetType returnType;
        private final JetType receiverType;
        private final List<ValueParameterDescriptor> valueParameters;
        private final List<TypeParameterDescriptor> typeParameters;

        public AlternativeMethodSignature(@Nullable JetType returnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<String> signatureErrors) {
            if (valueParameters == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$AlternativeMethodSignature", "<init>"));
            }
            if (typeParameters == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$AlternativeMethodSignature", "<init>"));
            }
            if (signatureErrors == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$AlternativeMethodSignature", "<init>"));
            }
            super(signatureErrors);
            this.returnType = returnType;
            this.receiverType = receiverType;
            this.valueParameters = valueParameters;
            this.typeParameters = typeParameters;
        }

        @Nullable
        public JetType getReturnType() {
            return this.returnType;
        }

        @Nullable
        public JetType getReceiverType() {
            return this.receiverType;
        }

        @NotNull
        public List<ValueParameterDescriptor> getValueParameters() {
            List<ValueParameterDescriptor> list2 = this.valueParameters;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$AlternativeMethodSignature", "getValueParameters"));
            }
            return list2;
        }

        @NotNull
        public List<TypeParameterDescriptor> getTypeParameters() {
            List<TypeParameterDescriptor> list2 = this.typeParameters;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$AlternativeMethodSignature", "getTypeParameters"));
            }
            return list2;
        }
    }

    public static abstract class MemberSignature {
        private final List<String> signatureErrors;

        protected MemberSignature(@NotNull List<String> signatureErrors) {
            if (signatureErrors == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$MemberSignature", "<init>"));
            }
            this.signatureErrors = signatureErrors;
        }

        @NotNull
        public List<String> getErrors() {
            List<String> list2 = this.signatureErrors;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/ExternalSignatureResolver$MemberSignature", "getErrors"));
            }
            return list2;
        }
    }
}

