/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.descriptor;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;

public class JavaEnumClassObjectDescriptor
extends MutableClassDescriptorLite {
    private ConstructorDescriptor constructor;

    public JavaEnumClassObjectDescriptor(@NotNull DeclarationDescriptor enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaEnumClassObjectDescriptor", "<init>"));
        }
        super(enumClass, DescriptorUtils.getClassObjectName(enumClass.getName()), ClassKind.CLASS_OBJECT, false);
    }

    private void initConstructor() {
        if (this.constructor == null) {
            ConstructorDescriptorImpl constructor = DescriptorFactory.createPrimaryConstructorForObject(this);
            constructor.setReturnType(this.getDefaultType());
            this.constructor = constructor;
        }
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        this.initConstructor();
        Set<ConstructorDescriptor> set = Collections.singleton(this.constructor);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/descriptor/JavaEnumClassObjectDescriptor", "getConstructors"));
        }
        return set;
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        this.initConstructor();
        return this.constructor;
    }
}

