/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class JvmClassName {
    private final String internalName;
    private FqName fqName;

    @NotNull
    public static JvmClassName byInternalName(@NotNull String internalName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byInternalName"));
        }
        JvmClassName jvmClassName = new JvmClassName(internalName);
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byInternalName"));
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byFqNameWithoutInnerClasses"));
        }
        JvmClassName r = new JvmClassName(fqName.asString().replace('.', '/'));
        r.fqName = fqName;
        JvmClassName jvmClassName = r;
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byFqNameWithoutInnerClasses"));
        }
        return jvmClassName;
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byFqNameWithoutInnerClasses"));
        }
        JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses(new FqName(fqName));
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "byFqNameWithoutInnerClasses"));
        }
        return jvmClassName;
    }

    private JvmClassName(@NotNull String internalName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "<init>"));
        }
        this.internalName = internalName;
    }

    @NotNull
    public FqName getFqNameForClassNameWithoutDollars() {
        if (this.fqName == null) {
            String fqName = this.internalName.replace("object", "<class_object>").replace("$TImpl", "<trait_impl>").replace('$', '.').replace('/', '.').replace("<trait_impl>", "$TImpl").replace("<class_object>", "object");
            this.fqName = new FqName(fqName);
        }
        FqName fqName = this.fqName;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "getFqNameForClassNameWithoutDollars"));
        }
        return fqName;
    }

    @NotNull
    public String getInternalName() {
        String string = this.internalName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmClassName", "getInternalName"));
        }
        return string;
    }

    public String toString() {
        return this.internalName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.internalName.equals(((JvmClassName)o).internalName);
    }

    public int hashCode() {
        return this.internalName.hashCode();
    }
}

