/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import com.google.common.base.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ShortValue
implements CompileTimeConstant<Short> {
    public static final Function<Long, ShortValue> CREATE = new Function<Long, ShortValue>(){

        @Override
        public ShortValue apply(@Nullable Long input) {
            assert (input != null);
            return new ShortValue(input.shortValue());
        }
    };
    private final short value;

    public ShortValue(short value) {
        this.value = value;
    }

    @Override
    public Short getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/constants/ShortValue", "getType"));
        }
        JetType jetType = kotlinBuiltIns.getShortType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/ShortValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitShortValue(this, data2);
    }

    public String toString() {
        return this.value + ".toShort()";
    }
}

