/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class JavaClassValue
implements CompileTimeConstant<JetType> {
    private final JetType value;

    public JavaClassValue(JetType value) {
        this.value = value;
    }

    @Override
    public JetType getValue() {
        return this.value.getArguments().iterator().next().getType();
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        if (kotlinBuiltIns == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/constants/JavaClassValue", "getType"));
        }
        JetType jetType = this.value;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/JavaClassValue", "getType"));
        }
        return jetType;
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitJavaClassValue(this, data2);
    }

    public String toString() {
        return this.getValue() + ".class";
    }
}

