/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;

public interface AutoCastService {
    public static final AutoCastService NO_AUTO_CASTS = new AutoCastService(){

        @Override
        @NotNull
        public DataFlowInfo getDataFlowInfo() {
            DataFlowInfo dataFlowInfo = DataFlowInfo.EMPTY;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastService$1", "getDataFlowInfo"));
            }
            return dataFlowInfo;
        }

        @Override
        public boolean isNotNull(@NotNull ReceiverValue receiver) {
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastService$1", "isNotNull"));
            }
            return !receiver.getType().isNullable();
        }

        @Override
        @NotNull
        public List<ReceiverValue> getVariantsForReceiver(@NotNull ReceiverValue receiverValue) {
            if (receiverValue == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastService$1", "getVariantsForReceiver"));
            }
            List<ReceiverValue> list2 = Collections.singletonList(receiverValue);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastService$1", "getVariantsForReceiver"));
            }
            return list2;
        }
    };

    @NotNull
    public List<ReceiverValue> getVariantsForReceiver(@NotNull ReceiverValue var1);

    @NotNull
    public DataFlowInfo getDataFlowInfo();

    public boolean isNotNull(@NotNull ReceiverValue var1);
}

