/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.CallKey;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.TraceUtil;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CallResolverUtil {
    private CallResolverUtil() {
    }

    public static <D extends CallableDescriptor> ResolvedCallImpl<D> copy(@NotNull ResolvedCallImpl<D> call, @NotNull CallResolutionContext<?> context) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "copy"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "copy"));
        }
        ResolutionCandidate<D> candidate = ResolutionCandidate.create(call.getCandidateDescriptor(), call.getThisObject(), call.getReceiverArgument(), call.getExplicitReceiverKind(), call.isSafeCall());
        ResolvedCallImpl<D> copy = ResolvedCallImpl.create(candidate, TraceUtil.DELEGATING_TRACE_STUB, call.getTracing(), call.getDataFlowInfoForArguments());
        context.trace.record(BindingContext.RESOLVED_CALL, context.call.getCalleeExpression(), copy);
        copy.addStatus(call.getStatus());
        if (call.isDirty()) {
            copy.argumentHasNoType();
        }
        copy.setHasUnknownTypeParameters(call.hasIncompleteTypeParameters());
        ConstraintSystem constraintSystem = call.getConstraintSystem();
        if (constraintSystem != null) {
            copy.setConstraintSystem(constraintSystem.copy());
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : call.getValueArguments().entrySet()) {
            copy.recordValueArgument(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public static boolean hasUnknownFunctionParameter(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "hasUnknownFunctionParameter"));
        }
        assert (KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(type));
        List<TypeProjection> arguments = type.getArguments();
        List<TypeProjection> functionParameters = arguments.subList(0, arguments.size() - 1);
        for (TypeProjection functionParameter : functionParameters) {
            if (!TypeUtils.equalsOrContainsAsArgument(functionParameter.getType(), TypeUtils.CANT_INFER_TYPE_PARAMETER, TypeUtils.DONT_CARE)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUnknownReturnType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "hasUnknownReturnType"));
        }
        assert (KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(type));
        JetType returnTypeFromFunctionType = KotlinBuiltIns.getInstance().getReturnTypeFromFunctionType(type);
        return ErrorUtils.containsErrorType(returnTypeFromFunctionType);
    }

    public static JetType replaceReturnTypeByUnknown(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "replaceReturnTypeByUnknown"));
        }
        assert (KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(type));
        List<TypeProjection> arguments = type.getArguments();
        ArrayList<TypeProjection> newArguments = Lists.newArrayList();
        newArguments.addAll(arguments.subList(0, arguments.size() - 1));
        newArguments.add(new TypeProjectionImpl(Variance.INVARIANT, TypeUtils.DONT_CARE));
        return new JetTypeImpl(type.getAnnotations(), type.getConstructor(), type.isNullable(), newArguments, type.getMemberScope());
    }

    private static boolean hasReturnTypeDependentOnNotInferredParams(@NotNull ResolvedCallImpl<?> callToComplete) {
        if (callToComplete == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "hasReturnTypeDependentOnNotInferredParams"));
        }
        ConstraintSystem constraintSystem = callToComplete.getConstraintSystem();
        if (constraintSystem == null) {
            return false;
        }
        Object candidateDescriptor = callToComplete.getCandidateDescriptor();
        JetType returnType = candidateDescriptor.getReturnType();
        if (returnType == null) {
            return false;
        }
        for (TypeParameterDescriptor typeVariable : constraintSystem.getTypeVariables()) {
            JetType inferredValueForTypeVariable = constraintSystem.getTypeBounds(typeVariable).getValue();
            if (inferredValueForTypeVariable != null || !TypeUtils.dependsOnTypeParameters(returnType, Collections.singleton(typeVariable))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInferredReturnType(ResolvedCallWithTrace<?> call) {
        ResolvedCallImpl<?> callToComplete = call.getCallToCompleteTypeArgumentInference();
        if (CallResolverUtil.hasReturnTypeDependentOnNotInferredParams(callToComplete)) {
            return false;
        }
        ConstraintSystem constraintSystem = callToComplete.getConstraintSystem();
        return constraintSystem == null || !constraintSystem.getStatus().hasOnlyErrorsFromPosition(ConstraintPosition.EXPECTED_TYPE_POSITION);
    }

    @Nullable
    public static CallKey createCallKey(@NotNull BasicCallResolutionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "createCallKey"));
        }
        if (context.call.getCallType() == Call.CallType.INVOKE) {
            return null;
        }
        PsiElement callElement = context.call.getCallElement();
        if (!(callElement instanceof JetExpression)) {
            return null;
        }
        return CallKey.create(context.call.getCallType(), (JetExpression)callElement);
    }

    @NotNull
    public static JetType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor) {
        if (receiverParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "getErasedReceiverType"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "getErasedReceiverType"));
        }
        JetType receiverType = receiverParameterDescriptor.getType();
        for (TypeParameterDescriptor typeParameter : descriptor.getTypeParameters()) {
            if (!typeParameter.getTypeConstructor().equals(receiverType.getConstructor())) continue;
            receiverType = typeParameter.getUpperBoundsAsType();
        }
        ArrayList<TypeProjectionImpl> fakeTypeArguments = Lists.newArrayList();
        for (TypeProjection typeProjection : receiverType.getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(receiverType.getAnnotations(), receiverType.getConstructor(), receiverType.isNullable(), fakeTypeArguments, ErrorUtils.createErrorScope("Error scope for erased receiver type", true));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "getErasedReceiverType"));
        }
        return jetTypeImpl;
    }

    public static boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/calls/CallResolverUtil", "isOrOverridesSynthesized"));
        }
        if (descriptor.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return true;
        }
        if (descriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            for (CallableMemberDescriptor callableMemberDescriptor : descriptor.getOverriddenDescriptors()) {
                if (CallResolverUtil.isOrOverridesSynthesized(callableMemberDescriptor)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static enum ResolveArgumentsMode {
        RESOLVE_FUNCTION_ARGUMENTS,
        SHAPE_FUNCTION_ARGUMENTS;

    }
}

