/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyAccessorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.resolve.ExternalOverridabilityCondition;
import org.jetbrains.jet.lang.resolve.VisibilityUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class OverridingUtil {
    private static final List<ExternalOverridabilityCondition> EXTERNAL_CONDITIONS = ContainerUtil.collect(ServiceLoader.load(ExternalOverridabilityCondition.class, ExternalOverridabilityCondition.class.getClassLoader()).iterator());

    private OverridingUtil() {
    }

    public static <D extends CallableDescriptor> Set<D> filterOverrides(Set<D> candidateSet) {
        return OverridingUtil.filterOverrides(candidateSet, Function.ID);
    }

    public static <D> Set<D> filterOverrides(Set<D> candidateSet, Function<? super D, ? extends CallableDescriptor> transform) {
        LinkedHashSet<D> candidates = Sets.newLinkedHashSet();
        block0: for (D meD : candidateSet) {
            CallableDescriptor other;
            CallableDescriptor me = transform.fun(meD);
            for (Object otherD : candidateSet) {
                other = transform.fun(otherD);
                if (me == other || !OverridingUtil.overrides(other, me)) continue;
                continue block0;
            }
            for (Object otherD : candidates) {
                other = transform.fun(otherD);
                if (me.getOriginal() != other.getOriginal() || OverridingUtil.isOverridableBy(other, me).getResult() != OverrideCompatibilityInfo.Result.OVERRIDABLE || OverridingUtil.isOverridableBy(me, other).getResult() != OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                continue block0;
            }
            candidates.add(meD);
        }
        return candidates;
    }

    public static <Descriptor extends CallableDescriptor> boolean overrides(@NotNull Descriptor f, @NotNull Descriptor g) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "overrides"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "overrides"));
        }
        HashSet<CallableDescriptor> overriddenDescriptors = Sets.newHashSet();
        OverridingUtil.getAllOverriddenDescriptors(f.getOriginal(), overriddenDescriptors);
        CallableDescriptor originalG = g.getOriginal();
        for (CallableDescriptor overriddenFunction : overriddenDescriptors) {
            if (!originalG.equals(overriddenFunction.getOriginal())) continue;
            return true;
        }
        return false;
    }

    private static void getAllOverriddenDescriptors(@NotNull CallableDescriptor current, @NotNull Set<CallableDescriptor> overriddenDescriptors) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "getAllOverriddenDescriptors"));
        }
        if (overriddenDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "getAllOverriddenDescriptors"));
        }
        if (overriddenDescriptors.contains(current)) {
            return;
        }
        for (CallableDescriptor callableDescriptor : current.getOriginal().getOverriddenDescriptors()) {
            OverridingUtil.getAllOverriddenDescriptors(callableDescriptor, overriddenDescriptors);
            overriddenDescriptors.add(callableDescriptor);
        }
    }

    @NotNull
    public static OverrideCompatibilityInfo isOverridableBy(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
        }
        if (superDescriptor instanceof FunctionDescriptor) {
            if (!(subDescriptor instanceof FunctionDescriptor)) {
                OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.memberKindMismatch();
                if (overrideCompatibilityInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
                }
                return overrideCompatibilityInfo;
            }
        } else if (superDescriptor instanceof PropertyDescriptor) {
            if (!(subDescriptor instanceof PropertyDescriptor)) {
                OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.memberKindMismatch();
                if (overrideCompatibilityInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
                }
                return overrideCompatibilityInfo;
            }
        } else {
            throw new IllegalArgumentException("This type of CallableDescriptor cannot be checked for overridability: " + superDescriptor);
        }
        if (!superDescriptor.getName().equals(subDescriptor.getName())) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.nameMismatch();
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
            }
            return overrideCompatibilityInfo;
        }
        OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.isOverridableByImpl(superDescriptor, subDescriptor, true);
        if (overrideCompatibilityInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableBy"));
        }
        return overrideCompatibilityInfo;
    }

    private static List<JetType> compiledValueParameters(CallableDescriptor callableDescriptor) {
        ReceiverParameterDescriptor receiverParameter = callableDescriptor.getReceiverParameter();
        ArrayList<JetType> parameters = new ArrayList<JetType>();
        if (receiverParameter != null) {
            parameters.add(receiverParameter.getType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : callableDescriptor.getValueParameters()) {
            parameters.add(valueParameterDescriptor.getType());
        }
        return parameters;
    }

    static OverrideCompatibilityInfo isOverridableByImpl(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor, boolean forOverride) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableByImpl"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isOverridableByImpl"));
        }
        if (superDescriptor.getReceiverParameter() == null != (subDescriptor.getReceiverParameter() == null)) {
            return OverrideCompatibilityInfo.receiverPresenceMismatch();
        }
        if (superDescriptor.getValueParameters().size() != subDescriptor.getValueParameters().size()) {
            return OverrideCompatibilityInfo.valueParameterNumberMismatch();
        }
        List<JetType> superValueParameters = OverridingUtil.compiledValueParameters(superDescriptor);
        List<JetType> subValueParameters = OverridingUtil.compiledValueParameters(subDescriptor);
        if (forOverride && superDescriptor.getTypeParameters().size() != subDescriptor.getTypeParameters().size()) {
            for (int i = 0; i < superValueParameters.size(); ++i) {
                JetType subValueParameterType;
                JetType superValueParameterType = OverridingUtil.getUpperBound(superValueParameters.get(i));
                if (JetTypeChecker.INSTANCE.equalTypes(superValueParameterType, subValueParameterType = OverridingUtil.getUpperBound(subValueParameters.get(i)))) continue;
                return OverrideCompatibilityInfo.typeParameterNumberMismatch();
            }
            return OverrideCompatibilityInfo.valueParameterTypeMismatch(null, null, OverrideCompatibilityInfo.Result.CONFLICT);
        }
        if (forOverride) {
            TypeParameterDescriptor subTypeParameter;
            TypeParameterDescriptor superTypeParameter;
            int i;
            List<TypeParameterDescriptor> superTypeParameters = superDescriptor.getTypeParameters();
            List<TypeParameterDescriptor> subTypeParameters = subDescriptor.getTypeParameters();
            HashBiMap<TypeConstructor, TypeConstructor> axioms = HashBiMap.create();
            int typeParametersSize = superTypeParameters.size();
            for (i = 0; i < typeParametersSize; ++i) {
                superTypeParameter = superTypeParameters.get(i);
                subTypeParameter = subTypeParameters.get(i);
                axioms.put(superTypeParameter.getTypeConstructor(), subTypeParameter.getTypeConstructor());
            }
            typeParametersSize = superTypeParameters.size();
            for (i = 0; i < typeParametersSize; ++i) {
                superTypeParameter = superTypeParameters.get(i);
                subTypeParameter = subTypeParameters.get(i);
                if (JetTypeChecker.INSTANCE.equalTypes(superTypeParameter.getUpperBoundsAsType(), subTypeParameter.getUpperBoundsAsType(), axioms)) continue;
                return OverrideCompatibilityInfo.boundsMismatch(superTypeParameter, subTypeParameter);
            }
            int unsubstitutedValueParametersSize = superValueParameters.size();
            for (i = 0; i < unsubstitutedValueParametersSize; ++i) {
                boolean bothErrors;
                JetType superValueParameter = superValueParameters.get(i);
                JetType subValueParameter = subValueParameters.get(i);
                boolean bl = bothErrors = superValueParameter.isError() && subValueParameter.isError();
                if (bothErrors || JetTypeChecker.INSTANCE.equalTypes(superValueParameter, subValueParameter, axioms)) continue;
                return OverrideCompatibilityInfo.valueParameterTypeMismatch(superValueParameter, subValueParameter, OverrideCompatibilityInfo.Result.INCOMPATIBLE);
            }
            for (ExternalOverridabilityCondition externalCondition : EXTERNAL_CONDITIONS) {
                if (externalCondition.isOverridable(superDescriptor, subDescriptor)) continue;
                return OverrideCompatibilityInfo.externalConditionFailed(externalCondition.getClass());
            }
        } else {
            for (int i = 0; i < superValueParameters.size(); ++i) {
                JetType subValueParameterType;
                JetType superValueParameterType = OverridingUtil.getUpperBound(superValueParameters.get(i));
                if (JetTypeChecker.INSTANCE.equalTypes(superValueParameterType, subValueParameterType = OverridingUtil.getUpperBound(subValueParameters.get(i)))) continue;
                return OverrideCompatibilityInfo.valueParameterTypeMismatch(superValueParameterType, subValueParameterType, OverrideCompatibilityInfo.Result.INCOMPATIBLE);
            }
            return OverrideCompatibilityInfo.success();
        }
        return OverrideCompatibilityInfo.success();
    }

    private static JetType getUpperBound(JetType type) {
        if (type.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return type;
        }
        if (type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return ((TypeParameterDescriptor)type.getConstructor().getDeclarationDescriptor()).getUpperBoundsAsType();
        }
        throw new IllegalStateException("unknown type constructor: " + type.getConstructor().getClass().getName());
    }

    public static boolean isReturnTypeOkForOverride(@NotNull JetTypeChecker typeChecker, @NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (typeChecker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isReturnTypeOkForOverride"));
        }
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isReturnTypeOkForOverride"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isReturnTypeOkForOverride"));
        }
        TypeSubstitutor typeSubstitutor = OverridingUtil.prepareTypeSubstitutor(superDescriptor, subDescriptor);
        if (typeSubstitutor == null) {
            return false;
        }
        JetType superReturnType = superDescriptor.getReturnType();
        assert (superReturnType != null);
        JetType subReturnType = subDescriptor.getReturnType();
        assert (subReturnType != null);
        JetType substitutedSuperReturnType = typeSubstitutor.substitute(superReturnType, Variance.OUT_VARIANCE);
        assert (substitutedSuperReturnType != null);
        return typeChecker.isSubtypeOf(subReturnType, substitutedSuperReturnType);
    }

    @Nullable
    private static TypeSubstitutor prepareTypeSubstitutor(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "prepareTypeSubstitutor"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "prepareTypeSubstitutor"));
        }
        List<TypeParameterDescriptor> superTypeParameters = superDescriptor.getTypeParameters();
        List<TypeParameterDescriptor> subTypeParameters = subDescriptor.getTypeParameters();
        if (subTypeParameters.size() != superTypeParameters.size()) {
            return null;
        }
        HashMap<TypeConstructor, TypeProjection> substitutionContext = Maps.newHashMap();
        for (int i = 0; i < superTypeParameters.size(); ++i) {
            TypeParameterDescriptor superTypeParameter = superTypeParameters.get(i);
            TypeParameterDescriptor subTypeParameter = subTypeParameters.get(i);
            substitutionContext.put(superTypeParameter.getTypeConstructor(), new TypeProjectionImpl(subTypeParameter.getDefaultType()));
        }
        return TypeSubstitutor.create(substitutionContext);
    }

    public static boolean isPropertyTypeOkForOverride(@NotNull JetTypeChecker typeChecker, @NotNull PropertyDescriptor superDescriptor, @NotNull PropertyDescriptor subDescriptor) {
        if (typeChecker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isPropertyTypeOkForOverride"));
        }
        if (superDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isPropertyTypeOkForOverride"));
        }
        if (subDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isPropertyTypeOkForOverride"));
        }
        TypeSubstitutor typeSubstitutor = OverridingUtil.prepareTypeSubstitutor(superDescriptor, subDescriptor);
        JetType substitutedSuperReturnType = typeSubstitutor.substitute(superDescriptor.getReturnType(), Variance.OUT_VARIANCE);
        assert (substitutedSuperReturnType != null);
        return !superDescriptor.isVar() || typeChecker.equalTypes(subDescriptor.getReturnType(), substitutedSuperReturnType);
    }

    public static Collection<CallableMemberDescriptor> getOverriddenDeclarations(CallableMemberDescriptor descriptor) {
        HashMap<ClassDescriptor, CallableMemberDescriptor> result = Maps.newHashMap();
        OverridingUtil.getOverriddenDeclarations(descriptor, result);
        return result.values();
    }

    private static void getOverriddenDeclarations(CallableMemberDescriptor descriptor, Map<ClassDescriptor, CallableMemberDescriptor> r) {
        if (descriptor.getKind().isReal()) {
            r.put((ClassDescriptor)descriptor.getContainingDeclaration(), descriptor);
        } else {
            if (descriptor.getOverriddenDescriptors().isEmpty()) {
                throw new IllegalStateException("No overridden descriptors found for (fake override) " + descriptor);
            }
            for (CallableMemberDescriptor callableMemberDescriptor : descriptor.getOverriddenDescriptors()) {
                OverridingUtil.getOverriddenDeclarations(callableMemberDescriptor, r);
            }
        }
    }

    public static void bindOverride(CallableMemberDescriptor fromCurrent, CallableMemberDescriptor fromSupertype) {
        fromCurrent.addOverriddenDescriptor(fromSupertype);
        for (ValueParameterDescriptor parameterFromCurrent : fromCurrent.getValueParameters()) {
            assert (parameterFromCurrent.getIndex() < fromSupertype.getValueParameters().size()) : "An override relation between functions implies that they have the same number of value parameters";
            ValueParameterDescriptor parameterFromSupertype = fromSupertype.getValueParameters().get(parameterFromCurrent.getIndex());
            parameterFromCurrent.addOverriddenDescriptor(parameterFromSupertype);
        }
    }

    public static void generateOverridesInFunctionGroup(@NotNull Name name, @NotNull Collection<? extends CallableMemberDescriptor> membersFromSupertypes, @NotNull Collection<? extends CallableMemberDescriptor> membersFromCurrent, @NotNull ClassDescriptor current, @NotNull DescriptorSink sink) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "generateOverridesInFunctionGroup"));
        }
        if (membersFromSupertypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "generateOverridesInFunctionGroup"));
        }
        if (membersFromCurrent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/OverridingUtil", "generateOverridesInFunctionGroup"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/OverridingUtil", "generateOverridesInFunctionGroup"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/jet/lang/resolve/OverridingUtil", "generateOverridesInFunctionGroup"));
        }
        LinkedHashSet<CallableMemberDescriptor> notOverridden = Sets.newLinkedHashSet(membersFromSupertypes);
        for (CallableMemberDescriptor callableMemberDescriptor : membersFromCurrent) {
            Collection<CallableMemberDescriptor> bound = OverridingUtil.extractAndBindOverridesForMember(callableMemberDescriptor, membersFromSupertypes, current, sink);
            notOverridden.removeAll(bound);
        }
        OverridingUtil.createAndBindFakeOverrides(current, notOverridden, sink);
    }

    private static Collection<CallableMemberDescriptor> extractAndBindOverridesForMember(@NotNull CallableMemberDescriptor fromCurrent, @NotNull Collection<? extends CallableMemberDescriptor> descriptorsFromSuper, @NotNull ClassDescriptor current, @NotNull DescriptorSink sink) {
        if (fromCurrent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractAndBindOverridesForMember"));
        }
        if (descriptorsFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractAndBindOverridesForMember"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractAndBindOverridesForMember"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractAndBindOverridesForMember"));
        }
        ArrayList<CallableMemberDescriptor> bound = Lists.newArrayList();
        for (CallableMemberDescriptor callableMemberDescriptor : descriptorsFromSuper) {
            OverrideCompatibilityInfo.Result result = OverridingUtil.isOverridableBy(callableMemberDescriptor, fromCurrent).getResult();
            boolean isVisible = Visibilities.isVisible(callableMemberDescriptor, current);
            switch (result) {
                case OVERRIDABLE: {
                    if (isVisible) {
                        OverridingUtil.bindOverride(fromCurrent, callableMemberDescriptor);
                    }
                    bound.add(callableMemberDescriptor);
                    break;
                }
                case CONFLICT: {
                    if (isVisible) {
                        sink.conflict(callableMemberDescriptor, fromCurrent);
                    }
                    bound.add(callableMemberDescriptor);
                    break;
                }
            }
        }
        return bound;
    }

    private static void createAndBindFakeOverrides(@NotNull ClassDescriptor current, @NotNull Collection<CallableMemberDescriptor> notOverridden, @NotNull DescriptorSink sink) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createAndBindFakeOverrides"));
        }
        if (notOverridden == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createAndBindFakeOverrides"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createAndBindFakeOverrides"));
        }
        LinkedList<CallableMemberDescriptor> fromSuperQueue = new LinkedList<CallableMemberDescriptor>(notOverridden);
        while (!fromSuperQueue.isEmpty()) {
            CallableMemberDescriptor notOverriddenFromSuper = VisibilityUtil.findMemberWithMaxVisibility(fromSuperQueue);
            Collection<CallableMemberDescriptor> overridables = OverridingUtil.extractMembersOverridableInBothWays(notOverriddenFromSuper, fromSuperQueue, sink);
            OverridingUtil.createAndBindFakeOverride(overridables, current, sink);
        }
    }

    private static boolean isMoreSpecific(@NotNull CallableMemberDescriptor a, @NotNull CallableMemberDescriptor b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isMoreSpecific"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "isMoreSpecific"));
        }
        if (a instanceof SimpleFunctionDescriptor) {
            assert (b instanceof SimpleFunctionDescriptor) : "b is " + b.getClass();
            JetType aReturnType = a.getReturnType();
            assert (aReturnType != null);
            JetType bReturnType = b.getReturnType();
            assert (bReturnType != null);
            return JetTypeChecker.INSTANCE.isSubtypeOf(aReturnType, bReturnType);
        }
        if (a instanceof PropertyDescriptor) {
            assert (b instanceof PropertyDescriptor) : "b is " + b.getClass();
            if (((PropertyDescriptor)a).isVar() || ((PropertyDescriptor)b).isVar()) {
                return ((PropertyDescriptor)a).isVar();
            }
            return JetTypeChecker.INSTANCE.isSubtypeOf(((PropertyDescriptor)a).getType(), ((PropertyDescriptor)b).getType());
        }
        throw new IllegalArgumentException("Unexpected callable: " + a.getClass());
    }

    private static CallableMemberDescriptor selectMostSpecificMemberFromSuper(@NotNull Collection<CallableMemberDescriptor> overridables) {
        if (overridables == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "selectMostSpecificMemberFromSuper"));
        }
        CallableMemberDescriptor result = null;
        for (CallableMemberDescriptor overridable : overridables) {
            if (result != null && !OverridingUtil.isMoreSpecific(overridable, result)) continue;
            result = overridable;
        }
        return result;
    }

    private static void createAndBindFakeOverride(@NotNull Collection<CallableMemberDescriptor> overridables, @NotNull ClassDescriptor current, @NotNull DescriptorSink sink) {
        if (overridables == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createAndBindFakeOverride"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createAndBindFakeOverride"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/OverridingUtil", "createAndBindFakeOverride"));
        }
        Collection<CallableMemberDescriptor> visibleOverridables = OverridingUtil.filterVisibleFakeOverrides(current, overridables);
        Modality modality = OverridingUtil.getMinimalModality(visibleOverridables);
        boolean allInvisible = visibleOverridables.isEmpty();
        Collection<CallableMemberDescriptor> effectiveOverridden = allInvisible ? overridables : visibleOverridables;
        Visibility visibility = allInvisible ? Visibilities.INVISIBLE_FAKE : Visibilities.INHERITED;
        CallableMemberDescriptor mostSpecific = OverridingUtil.selectMostSpecificMemberFromSuper(effectiveOverridden);
        CallableMemberDescriptor fakeOverride = mostSpecific.copy(current, modality, visibility, CallableMemberDescriptor.Kind.FAKE_OVERRIDE, false);
        for (CallableMemberDescriptor descriptor : effectiveOverridden) {
            OverridingUtil.bindOverride(fakeOverride, descriptor);
        }
        sink.addToScope(fakeOverride);
    }

    @NotNull
    private static Modality getMinimalModality(@NotNull Collection<CallableMemberDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "getMinimalModality"));
        }
        Modality modality = Modality.ABSTRACT;
        for (CallableMemberDescriptor descriptor : descriptors) {
            if (descriptor.getModality().compareTo(modality) >= 0) continue;
            modality = descriptor.getModality();
        }
        Modality modality2 = modality;
        if (modality2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "getMinimalModality"));
        }
        return modality2;
    }

    @NotNull
    private static Collection<CallableMemberDescriptor> filterVisibleFakeOverrides(final @NotNull ClassDescriptor current, @NotNull Collection<CallableMemberDescriptor> toFilter) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "filterVisibleFakeOverrides"));
        }
        if (toFilter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "filterVisibleFakeOverrides"));
        }
        Collection<CallableMemberDescriptor> collection = Collections2.filter(toFilter, new Predicate<CallableMemberDescriptor>(){

            @Override
            public boolean apply(@Nullable CallableMemberDescriptor descriptor) {
                return descriptor != null && descriptor.getVisibility() != Visibilities.PRIVATE && Visibilities.isVisible(descriptor, current);
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "filterVisibleFakeOverrides"));
        }
        return collection;
    }

    @NotNull
    private static Collection<CallableMemberDescriptor> extractMembersOverridableInBothWays(@NotNull CallableMemberDescriptor overrider, @NotNull Queue<CallableMemberDescriptor> extractFrom, @NotNull DescriptorSink sink) {
        if (overrider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractMembersOverridableInBothWays"));
        }
        if (extractFrom == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractMembersOverridableInBothWays"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractMembersOverridableInBothWays"));
        }
        ArrayList<CallableMemberDescriptor> overridable = Lists.newArrayList();
        overridable.add(overrider);
        Iterator iterator2 = extractFrom.iterator();
        while (iterator2.hasNext()) {
            CallableMemberDescriptor candidate = (CallableMemberDescriptor)iterator2.next();
            if (overrider == candidate) {
                iterator2.remove();
                continue;
            }
            OverrideCompatibilityInfo.Result result1 = OverridingUtil.isOverridableBy(candidate, overrider).getResult();
            OverrideCompatibilityInfo.Result result2 = OverridingUtil.isOverridableBy(overrider, candidate).getResult();
            if (result1 == OverrideCompatibilityInfo.Result.OVERRIDABLE && result2 == OverrideCompatibilityInfo.Result.OVERRIDABLE) {
                overridable.add(candidate);
                iterator2.remove();
                continue;
            }
            if (result1 != OverrideCompatibilityInfo.Result.CONFLICT && result2 != OverrideCompatibilityInfo.Result.CONFLICT) continue;
            sink.conflict(overrider, candidate);
            iterator2.remove();
        }
        ArrayList<CallableMemberDescriptor> arrayList = overridable;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil", "extractMembersOverridableInBothWays"));
        }
        return arrayList;
    }

    public static void resolveUnknownVisibilityForMember(@NotNull CallableMemberDescriptor memberDescriptor, @NotNull NotInferredVisibilitySink sink) {
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "resolveUnknownVisibilityForMember"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/resolve/OverridingUtil", "resolveUnknownVisibilityForMember"));
        }
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            if (callableMemberDescriptor.getVisibility() != Visibilities.INHERITED) continue;
            OverridingUtil.resolveUnknownVisibilityForMember(callableMemberDescriptor, sink);
        }
        if (memberDescriptor.getVisibility() != Visibilities.INHERITED) {
            return;
        }
        Visibility visibility = OverridingUtil.findMaxVisibility(memberDescriptor.getOverriddenDescriptors());
        if (visibility == null) {
            sink.cannotInferVisibility(memberDescriptor);
            visibility = Visibilities.PUBLIC;
        }
        if (memberDescriptor instanceof PropertyDescriptorImpl) {
            ((PropertyDescriptorImpl)memberDescriptor).setVisibility(visibility.normalize());
            for (PropertyAccessorDescriptor accessor : ((PropertyDescriptor)memberDescriptor).getAccessors()) {
                OverridingUtil.resolveUnknownVisibilityForMember(accessor, sink);
            }
        } else if (memberDescriptor instanceof FunctionDescriptorImpl) {
            ((FunctionDescriptorImpl)memberDescriptor).setVisibility(visibility.normalize());
        } else {
            assert (memberDescriptor instanceof PropertyAccessorDescriptorImpl);
            ((PropertyAccessorDescriptorImpl)memberDescriptor).setVisibility(visibility.normalize());
        }
    }

    @Nullable
    private static Visibility findMaxVisibility(@NotNull Collection<? extends CallableMemberDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/resolve/OverridingUtil", "findMaxVisibility"));
        }
        if (descriptors.isEmpty()) {
            return Visibilities.INTERNAL;
        }
        Visibility maxVisibility = null;
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            Visibility visibility = callableMemberDescriptor.getVisibility();
            assert (visibility != Visibilities.INHERITED);
            if (maxVisibility == null) {
                maxVisibility = visibility;
                continue;
            }
            Integer compareResult = Visibilities.compare(visibility, maxVisibility);
            if (compareResult == null) {
                maxVisibility = null;
                continue;
            }
            if (compareResult <= 0) continue;
            maxVisibility = visibility;
        }
        if (maxVisibility == null) {
            return null;
        }
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            Integer compareResult = Visibilities.compare(maxVisibility, callableMemberDescriptor.getVisibility());
            if (compareResult != null && compareResult >= 0) continue;
            return null;
        }
        return maxVisibility;
    }

    public static class OverrideCompatibilityInfo {
        private static final OverrideCompatibilityInfo SUCCESS = new OverrideCompatibilityInfo(Result.OVERRIDABLE, "SUCCESS");
        private final Result overridable;
        private final String message;

        @NotNull
        public static OverrideCompatibilityInfo success() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = SUCCESS;
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "success"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo nameMismatch() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "nameMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "nameMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo typeParameterNumberMismatch() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "typeParameterNumberMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "typeParameterNumberMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo receiverPresenceMismatch() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "receiverPresenceMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "receiverPresenceMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo valueParameterNumberMismatch() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "valueParameterNumberMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "valueParameterNumberMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo boundsMismatch(TypeParameterDescriptor superTypeParameter, TypeParameterDescriptor subTypeParameter) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "boundsMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "boundsMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo valueParameterTypeMismatch(JetType superValueParameter, JetType subValueParameter, Result result) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(result, "valueParameterTypeMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "valueParameterTypeMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo memberKindMismatch() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "memberKindMismatch");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "memberKindMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo returnTypeMismatch(JetType substitutedSuperReturnType, JetType unsubstitutedSubReturnType) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.CONFLICT, "returnTypeMismatch: " + unsubstitutedSubReturnType + " >< " + substitutedSuperReturnType);
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "returnTypeMismatch"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo varOverriddenByVal() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "varOverriddenByVal");
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "varOverriddenByVal"));
            }
            return overrideCompatibilityInfo;
        }

        @NotNull
        public static OverrideCompatibilityInfo externalConditionFailed(Class<? extends ExternalOverridabilityCondition> conditionClass) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "externalConditionFailed: " + conditionClass.getName());
            if (overrideCompatibilityInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverridingUtil$OverrideCompatibilityInfo", "externalConditionFailed"));
            }
            return overrideCompatibilityInfo;
        }

        public OverrideCompatibilityInfo(Result success, String message) {
            this.overridable = success;
            this.message = message;
        }

        public Result getResult() {
            return this.overridable;
        }

        public String getMessage() {
            return this.message;
        }

        public static enum Result {
            OVERRIDABLE,
            INCOMPATIBLE,
            CONFLICT;

        }
    }

    public static interface NotInferredVisibilitySink {
        public void cannotInferVisibility(@NotNull CallableMemberDescriptor var1);
    }

    public static interface DescriptorSink {
        public void addToScope(@NotNull CallableMemberDescriptor var1);

        public void conflict(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);
    }
}

