/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;

public class JetBinaryExpressionWithTypeRHS
extends JetExpressionImpl
implements JetOperationExpression {
    public JetBinaryExpressionWithTypeRHS(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetBinaryExpressionWithTypeRHS", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetBinaryExpressionWithTypeRHS", "accept"));
        }
        visitor.visitBinaryWithTypeRHSExpression(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/psi/JetBinaryExpressionWithTypeRHS", "accept"));
        }
        return visitor.visitBinaryWithTypeRHSExpression(this, data2);
    }

    @NotNull
    public JetExpression getLeft() {
        JetExpression left = this.findChildByClass(JetExpression.class);
        assert (left != null);
        JetExpression jetExpression = left;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetBinaryExpressionWithTypeRHS", "getLeft"));
        }
        return jetExpression;
    }

    @IfNotParsed
    @Nullable
    public JetTypeReference getRight() {
        for (ASTNode node = this.getOperationReference().getNode(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof JetTypeReference)) continue;
            return (JetTypeReference)psi;
        }
        return null;
    }

    @Override
    @NotNull
    public JetSimpleNameExpression getOperationReference() {
        JetSimpleNameExpression jetSimpleNameExpression = (JetSimpleNameExpression)this.findChildByType(JetNodeTypes.OPERATION_REFERENCE);
        if (jetSimpleNameExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetBinaryExpressionWithTypeRHS", "getOperationReference"));
        }
        return jetSimpleNameExpression;
    }
}

