/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics.rendering;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.Named;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.jet.lang.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.jet.renderer.Renderer;

public class Renderers {
    public static final Renderer<Object> TO_STRING = new Renderer<Object>(){

        @Override
        @NotNull
        public String render(@NotNull Object element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$1", "render"));
            }
            String string = element.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$1", "render"));
            }
            return string;
        }

        public String toString() {
            return "TO_STRING";
        }
    };
    public static final Renderer<Object> NAME = new Renderer<Object>(){

        @Override
        @NotNull
        public String render(@NotNull Object element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$2", "render"));
            }
            if (element instanceof Named) {
                String string = ((Named)element).getName().asString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$2", "render"));
                }
                return string;
            }
            String string = element.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$2", "render"));
            }
            return string;
        }
    };
    public static final Renderer<PsiElement> ELEMENT_TEXT = new Renderer<PsiElement>(){

        @Override
        @NotNull
        public String render(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$3", "render"));
            }
            String string = element.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$3", "render"));
            }
            return string;
        }
    };
    public static final Renderer<JetClassOrObject> RENDER_CLASS_OR_OBJECT = new Renderer<JetClassOrObject>(){

        @Override
        @NotNull
        public String render(@NotNull JetClassOrObject classOrObject) {
            String name;
            if (classOrObject == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$4", "render"));
            }
            String string = name = classOrObject.getName() != null ? " '" + classOrObject.getName() + "'" : "";
            if (classOrObject instanceof JetClass) {
                String string2 = "Class" + name;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$4", "render"));
                }
                return string2;
            }
            String string3 = "Object" + name;
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$4", "render"));
            }
            return string3;
        }
    };
    public static final Renderer<JetType> RENDER_TYPE = new Renderer<JetType>(){

        @Override
        @NotNull
        public String render(@NotNull JetType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$5", "render"));
            }
            String string = DescriptorRenderer.TEXT.renderType(type);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$5", "render"));
            }
            return string;
        }
    };
    public static final Renderer<Collection<? extends ResolvedCall<?>>> AMBIGUOUS_CALLS = new Renderer<Collection<? extends ResolvedCall<? extends CallableDescriptor>>>(){

        @Override
        @NotNull
        public String render(@NotNull Collection<? extends ResolvedCall<? extends CallableDescriptor>> argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$6", "render"));
            }
            StringBuilder stringBuilder = new StringBuilder("\n");
            for (ResolvedCall<? extends CallableDescriptor> resolvedCall : argument) {
                stringBuilder.append(DescriptorRenderer.TEXT.render(resolvedCall.getResultingDescriptor())).append("\n");
            }
            String string = stringBuilder.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$6", "render"));
            }
            return string;
        }
    };
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER = new Renderer<InferenceErrorData>(){

        @Override
        @NotNull
        public String render(@NotNull InferenceErrorData inferenceErrorData) {
            if (inferenceErrorData == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$8", "render"));
            }
            String string = Renderers.renderConflictingSubstitutionsInferenceError(inferenceErrorData, TabledDescriptorRenderer.create()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$8", "render"));
            }
            return string;
        }
    };
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER = new Renderer<InferenceErrorData>(){

        @Override
        @NotNull
        public String render(@NotNull InferenceErrorData inferenceErrorData) {
            if (inferenceErrorData == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$9", "render"));
            }
            String string = Renderers.renderTypeConstructorMismatchError(inferenceErrorData, TabledDescriptorRenderer.create()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$9", "render"));
            }
            return string;
        }
    };
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER = new Renderer<InferenceErrorData>(){

        @Override
        @NotNull
        public String render(@NotNull InferenceErrorData inferenceErrorData) {
            if (inferenceErrorData == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$10", "render"));
            }
            String string = Renderers.renderNoInformationForParameterError(inferenceErrorData, TabledDescriptorRenderer.create()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$10", "render"));
            }
            return string;
        }
    };
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER = new Renderer<InferenceErrorData>(){

        @Override
        @NotNull
        public String render(@NotNull InferenceErrorData inferenceErrorData) {
            if (inferenceErrorData == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$11", "render"));
            }
            String string = Renderers.renderUpperBoundViolatedInferenceError(inferenceErrorData, TabledDescriptorRenderer.create()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$11", "render"));
            }
            return string;
        }
    };
    public static final Renderer<Collection<ClassDescriptor>> CLASSES_OR_SEPARATED = new Renderer<Collection<ClassDescriptor>>(){

        @Override
        @NotNull
        public String render(@NotNull Collection<ClassDescriptor> descriptors) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$14", "render"));
            }
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (ClassDescriptor descriptor : descriptors) {
                sb.append(DescriptorUtils.getFQName(descriptor).asString());
                if (++index <= descriptors.size() - 2) {
                    sb.append(", ");
                    continue;
                }
                if (index != descriptors.size() - 1) continue;
                sb.append(" or ");
            }
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$14", "render"));
            }
            return string;
        }
    };
    public static final Renderer<Collection<JetType>> RENDER_COLLECTION_OF_TYPES = new Renderer<Collection<JetType>>(){

        @Override
        @NotNull
        public String render(@NotNull Collection<JetType> types) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$15", "render"));
            }
            String string = StringUtil.join(types, new Function<JetType, String>(){

                @Override
                public String fun(JetType type) {
                    return RENDER_TYPE.render(type);
                }
            }, ", ");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$15", "render"));
            }
            return string;
        }
    };

    public static <T> Renderer<Collection<? extends T>> commaSeparated(final Renderer<T> itemRenderer) {
        return new Renderer<Collection<? extends T>>(){

            @Override
            @NotNull
            public String render(@NotNull Collection<? extends T> object2) {
                if (object2 == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$7", "render"));
                }
                StringBuilder result = new StringBuilder();
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Object next = iterator2.next();
                    result.append(itemRenderer.render(next));
                    if (!iterator2.hasNext()) continue;
                    result.append(", ");
                }
                String string = result.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers$7", "render"));
                }
                return string;
            }
        };
    }

    public static TabledDescriptorRenderer renderConflictingSubstitutionsInferenceError(InferenceErrorData inferenceErrorData, TabledDescriptorRenderer result) {
        assert (inferenceErrorData.constraintSystem.getStatus().hasConflictingConstraints());
        ArrayList<CallableDescriptor> substitutedDescriptors = Lists.newArrayList();
        Collection<TypeSubstitutor> substitutors = ConstraintsUtil.getSubstitutorsForConflictingParameters(inferenceErrorData.constraintSystem);
        for (TypeSubstitutor substitutor : substitutors) {
            CallableDescriptor substitutedDescriptor = inferenceErrorData.descriptor.substitute(substitutor);
            substitutedDescriptors.add(substitutedDescriptor);
        }
        TypeParameterDescriptor firstConflictingParameter = ConstraintsUtil.getFirstConflictingParameter(inferenceErrorData.constraintSystem);
        assert (firstConflictingParameter != null);
        result.text(TabledDescriptorRenderer.newText().normal("Cannot infer type parameter ").strong(firstConflictingParameter.getName()).normal(" in "));
        TabledDescriptorRenderer.TableRenderer table = TabledDescriptorRenderer.newTable();
        result.table(table);
        table.descriptor(inferenceErrorData.descriptor).text("None of the following substitutions");
        for (CallableDescriptor substitutedDescriptor : substitutedDescriptors) {
            JetType receiverType = DescriptorUtils.getReceiverParameterType(substitutedDescriptor.getReceiverParameter());
            final HashSet<ConstraintPosition> errorPositions = Sets.newHashSet();
            ArrayList<JetType> parameterTypes = Lists.newArrayList();
            for (ValueParameterDescriptor valueParameterDescriptor : substitutedDescriptor.getValueParameters()) {
                JetType actualType;
                parameterTypes.add(valueParameterDescriptor.getType());
                if (valueParameterDescriptor.getIndex() >= inferenceErrorData.valueArgumentsTypes.size() || JetTypeChecker.INSTANCE.isSubtypeOf(actualType = inferenceErrorData.valueArgumentsTypes.get(valueParameterDescriptor.getIndex()), valueParameterDescriptor.getType())) continue;
                errorPositions.add(ConstraintPosition.getValueParameterPosition(valueParameterDescriptor.getIndex()));
            }
            if (receiverType != null && inferenceErrorData.receiverArgumentType != null && !JetTypeChecker.INSTANCE.isSubtypeOf(inferenceErrorData.receiverArgumentType, receiverType)) {
                errorPositions.add(ConstraintPosition.RECEIVER_POSITION);
            }
            Predicate<ConstraintPosition> isErrorPosition = new Predicate<ConstraintPosition>(){

                @Override
                public boolean apply(@Nullable ConstraintPosition constraintPosition) {
                    return errorPositions.contains(constraintPosition);
                }
            };
            table.functionArgumentTypeList(receiverType, parameterTypes, isErrorPosition);
        }
        table.text("can be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes);
        return result;
    }

    public static TabledDescriptorRenderer renderTypeConstructorMismatchError(final InferenceErrorData inferenceErrorData, TabledDescriptorRenderer renderer) {
        Predicate<ConstraintPosition> isErrorPosition = new Predicate<ConstraintPosition>(){

            @Override
            public boolean apply(@Nullable ConstraintPosition constraintPosition) {
                assert (constraintPosition != null);
                return inferenceErrorData.constraintSystem.getStatus().hasTypeConstructorMismatchAt(constraintPosition);
            }
        };
        return renderer.table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("cannot be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes, isErrorPosition));
    }

    public static TabledDescriptorRenderer renderNoInformationForParameterError(InferenceErrorData inferenceErrorData, TabledDescriptorRenderer renderer) {
        Named firstUnknownParameter = null;
        for (TypeParameterDescriptor typeParameter : inferenceErrorData.constraintSystem.getTypeVariables()) {
            if (!inferenceErrorData.constraintSystem.getTypeBounds(typeParameter).isEmpty()) continue;
            firstUnknownParameter = typeParameter;
            break;
        }
        assert (firstUnknownParameter != null);
        return renderer.text(TabledDescriptorRenderer.newText().normal("Not enough information to infer parameter ").strong(firstUnknownParameter.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("Please specify it explicitly."));
    }

    @NotNull
    public static TabledDescriptorRenderer renderUpperBoundViolatedInferenceError(InferenceErrorData inferenceErrorData, TabledDescriptorRenderer result) {
        String errorMessage = "Rendering 'upper bound violated' error for " + inferenceErrorData.descriptor;
        TypeParameterDescriptor typeParameterDescriptor = null;
        ConstraintSystemImpl constraintSystem = (ConstraintSystemImpl)inferenceErrorData.constraintSystem;
        assert (constraintSystem.getStatus().hasViolatedUpperBound());
        ConstraintSystem systemWithoutWeakConstraints = constraintSystem.getSystemWithoutWeakConstraints();
        for (TypeParameterDescriptor typeParameter : inferenceErrorData.descriptor.getTypeParameters()) {
            if (ConstraintsUtil.checkUpperBoundIsSatisfied(systemWithoutWeakConstraints, typeParameter, true)) continue;
            typeParameterDescriptor = typeParameter;
        }
        assert (typeParameterDescriptor != null) : errorMessage;
        JetType inferredValueForTypeParameter = systemWithoutWeakConstraints.getTypeBounds(typeParameterDescriptor).getValue();
        assert (inferredValueForTypeParameter != null) : errorMessage;
        result.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
        JetType violatedUpperBound = null;
        for (JetType upperBound : typeParameterDescriptor.getUpperBounds()) {
            JetType upperBoundWithSubstitutedInferredTypes = systemWithoutWeakConstraints.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            if (upperBoundWithSubstitutedInferredTypes == null || JetTypeChecker.INSTANCE.isSubtypeOf(inferredValueForTypeParameter, upperBoundWithSubstitutedInferredTypes)) continue;
            violatedUpperBound = upperBoundWithSubstitutedInferredTypes;
            break;
        }
        assert (violatedUpperBound != null) : errorMessage;
        Renderer<JetType> typeRenderer = result.getTypeRenderer();
        result.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(typeRenderer.render(inferredValueForTypeParameter)).normal(" is not a subtype of ").strong(typeRenderer.render(violatedUpperBound)));
        TabledDescriptorRenderer tabledDescriptorRenderer = result;
        if (tabledDescriptorRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/rendering/Renderers", "renderUpperBoundViolatedInferenceError"));
        }
        return tabledDescriptorRenderer;
    }

    private Renderers() {
    }
}

